/* ======================================================================
 *   Copyright (C) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Cdd_I2c_Cfg.c
 *
 *  \brief    This file contains generated pre compile configurations
 *            for CDD I2C MCAL driver
 *
 */

/******************************************************************************
    Project         : Cdd_I2c_AM263x
    Date            : 2023-04-27 11:17:38
    SW Ver          : 8.6.2
    Module Rele Ver : AUTOSAR 4.3.1 0

    This file is generated by EB Tresos
    Do not modify this file,otherwise the software may behave in unexpected way.
******************************************************************************/

/*******************************************************************************
 *  INCLUDES
 ******************************************************************************/
#include "Cdd_I2c.h"
#include "Cdd_I2c_Cfg.h"

/** \brief Version checking  */
#if ((CDD_I2C_CFG_MAJOR_VERSION != (8U))||(CDD_I2C_CFG_MINOR_VERSION != (6U)))
    #error "Version numbers of Cdd_I2c_Cfg.c and Cdd_I2c.h are inconsistent!"
#endif

/*******************************************************************************
 *  Local Data
 ******************************************************************************/

/*******************************************************************************
 *  Global Data
 ******************************************************************************/
/**
 *  \brief Notification
 *
 */

#define CDD_I2C_START_SEC_CONFIG_DATA
#include "Cdd_I2c_MemMap.h"

CONST(Cdd_I2c_ConfigType, CDD_I2C_CONFIG_DATA) CddI2cInitParams =
{
    .CddI2cHwCfgPtr =
    {
    [0] =
    {
        .HwInstance         = CDD_I2C_HW_UNIT_0,
        .BaudRate           = CDD_I2C_400KHZ,
        .HwUnitFrequency    = 8000000U,
        .SysClk             = 200000000U,
    },
    [1] =
    {
        .HwInstance         = CDD_I2C_HW_UNIT_2,
        .BaudRate           = CDD_I2C_400KHZ,
        .HwUnitFrequency    = 8000000U,
        .SysClk             = 200000000U,
    },

},
    
};

/** \brief Pointer to CddI2cInitParams */
CONST(Cdd_I2c_ConfigPtrType, CDD_I2C_CONFIG_DATA) pCddI2cInitParams = (Cdd_I2c_ConfigType *)&CddI2cInitParams;

VAR(Cdd_I2c_Channel_Config, CDD_I2C_CONFIG_DATA) Cdd_I2cChannelContainer[CDD_I2C_MAXIMUM_CHANNEL_NUMBER] =
{
    [0] =
    {
        .Dir                = CDD_I2C_WRITE,
        .SlaveAddress       = 76U,
        .SlaveAddressScheme = CDD_I2C_7_BIT_ADDRESS,
        .ChainedChannel     = CHAIN_CHANNEL_OFF,
        .DataBufferLength   = 0U,
        .DataBuffer         = NULL_PTR,
        .ChannelResult      = CDD_I2C_CH_RESULT_OK,
    },
    [1] =
    {
        .Dir                = CDD_I2C_WRITE,
        .SlaveAddress       = 80U,
        .SlaveAddressScheme = CDD_I2C_7_BIT_ADDRESS,
        .ChainedChannel     = CHAIN_CHANNEL_OFF,
        .DataBufferLength   = 0U,
        .DataBuffer         = NULL_PTR,
        .ChannelResult      = CDD_I2C_CH_RESULT_OK,
    },
    [2] =
    {
        .Dir                = CDD_I2C_WRITE,
        .SlaveAddress       = 80U,
        .SlaveAddressScheme = CDD_I2C_7_BIT_ADDRESS,
        .ChainedChannel     = CHAIN_CHANNEL_OFF,
        .DataBufferLength   = 0U,
        .DataBuffer         = NULL_PTR,
        .ChannelResult      = CDD_I2C_CH_RESULT_OK,
    },
    [3] =
    {
        .Dir                = CDD_I2C_READ,
        .SlaveAddress       = 76U,
        .SlaveAddressScheme = CDD_I2C_7_BIT_ADDRESS,
        .ChainedChannel     = CHAIN_CHANNEL_OFF,
        .DataBufferLength   = 0U,
        .DataBuffer         = NULL_PTR,
        .ChannelResult      = CDD_I2C_CH_RESULT_OK,
    },
    [4] =
    {
        .Dir                = CDD_I2C_READ,
        .SlaveAddress       = 80U,
        .SlaveAddressScheme = CDD_I2C_7_BIT_ADDRESS,
        .ChainedChannel     = CHAIN_CHANNEL_OFF,
        .DataBufferLength   = 0U,
        .DataBuffer         = NULL_PTR,
        .ChannelResult      = CDD_I2C_CH_RESULT_OK,
    },

};

CONST(Cdd_I2c_Sequence_Config, CDD_I2C_CONFIG_DATA) Cdd_I2cSequenceContainer[CDD_I2C_MAXIMUM_SEQUENCE_NUMBER] = 
{
    [0] =
    {
        .HwInstance               = CDD_I2C_HW_UNIT_2,
        .MaxChannels              = 1U,
        .SeqResult                = CDD_I2C_SEQ_OK,
        .SequenceCompleteNotify   = I2c_Temperature_Data_Write_Complete,
        .SequenceErrorNotify      = I2c_Temperature_Data_Write_Fail,
        .ChannelList              =
        {
    /* The Number Of Channels generated below are equal to the variable "CddI2cNumberOfChannelsInSequence" */
            0U,

        },
    },
    [1] =
    {
        .HwInstance               = CDD_I2C_HW_UNIT_0,
        .MaxChannels              = 1U,
        .SeqResult                = CDD_I2C_SEQ_OK,
        .SequenceCompleteNotify   = I2c_Eeprom_Data_Write_Complete,
        .SequenceErrorNotify      = I2c_Eeprom_Data_Write_Fail,
        .ChannelList              =
        {
    /* The Number Of Channels generated below are equal to the variable "CddI2cNumberOfChannelsInSequence" */
            1U,

        },
    },
    [2] =
    {
        .HwInstance               = CDD_I2C_HW_UNIT_0,
        .MaxChannels              = 1U,
        .SeqResult                = CDD_I2C_SEQ_OK,
        .SequenceCompleteNotify   = I2c_Eeprom_Address_Ptr_Reset,
        .SequenceErrorNotify      = I2c_Eeprom_Address_Ptr_Fail,
        .ChannelList              =
        {
    /* The Number Of Channels generated below are equal to the variable "CddI2cNumberOfChannelsInSequence" */
            2U,

        },
    },
    [3] =
    {
        .HwInstance               = CDD_I2C_HW_UNIT_2,
        .MaxChannels              = 1U,
        .SeqResult                = CDD_I2C_SEQ_OK,
        .SequenceCompleteNotify   = I2c_Temperature_Read_Callback,
        .SequenceErrorNotify      = I2c_Temperature_Read_Callback_Fail,
        .ChannelList              =
        {
    /* The Number Of Channels generated below are equal to the variable "CddI2cNumberOfChannelsInSequence" */
            3U,

        },
    },
    [4] =
    {
        .HwInstance               = CDD_I2C_HW_UNIT_0,
        .MaxChannels              = 1U,
        .SeqResult                = CDD_I2C_SEQ_OK,
        .SequenceCompleteNotify   = I2c_Eeprom_Read_Callback,
        .SequenceErrorNotify      = I2c_Eeprom_Read_Callback_Fail,
        .ChannelList              =
        {
    /* The Number Of Channels generated below are equal to the variable "CddI2cNumberOfChannelsInSequence" */
            4U,

        },
    },

};

/** \brief CDD_I2C Arbitration loss condition parameter, possible values are CDD_I2C_BURST_MODE 
 * (for detaching from bus) or CDD_I2C_RECURRENT_MODE 
 * (For sending 9 clock pulses to the slave in order to synchronize the bus) 
*/
CONST(Cdd_I2c_HandlingType, CDD_I2C_CONFIG_DATA) CddI2cArbitrationLossParam = CDD_I2C_BURST_MODE;

#define CDD_I2C_STOP_SEC_CONFIG_DATA
#include "Cdd_I2c_MemMap.h"

#define CDD_I2C_START_SEC_VAR_INIT_32
#include "Cdd_I2c_MemMap.h"
/**
 * I2C register base address, SOC specific
*/
CONST(uint32,CDD_I2C_CONST)
    CddI2cHwUnitBaseAddr[CDD_I2C_HW_UNITS_MAX]    =   
    {
        0x52500000U,     /*I2C0_BASE_ADDR*/
        0x52501000U,     /*I2C1_BASE_ADDR*/
        0x52502000U,     /*I2C2_BASE_ADDR*/
        0x52503000U      /*I2C3_BASE_ADDR */
    };
#define CDD_I2C_STOP_SEC_VAR_INIT_32
#include "Cdd_I2c_MemMap.h"

#define CDD_I2C_START_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Cdd_I2c_MemMap.h"
/**
 * I2C transmission queue array
*/
VAR(Cdd_I2c_Queue_obj,CDD_I2C_VAR_INIT) CddI2cTransmissionQueue[CDD_I2C_MAX_QUEUE_SIZE];

/**
 * Pointer to I2C queue
*/
VAR(Cdd_I2c_Queue_obj *,CDD_I2C_VAR_INIT) pCddI2cTransmissionQueue = &CddI2cTransmissionQueue[0];

#define CDD_I2C_STOP_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Cdd_I2c_MemMap.h"

/* The last generated configuration variant is not
PRE-COMPILE variant. Refer Cdd_I2c_PBcfg.c. */
