/*
*
* Copyright (c) 2022 Texas Instruments Incorporated
*
* All rights reserved not granted herein.
*
* Limited License.
*
* Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
* license under copyrights and patents it now or hereafter owns or controls to make,
* have made, use, import, offer to sell and sell ("Utilize") this software subject to the
* terms herein.  With respect to the foregoing patent license, such license is granted
* solely to the extent that any such patent is necessary to Utilize the software alone.
* The patent license shall not apply to any combinations which include this software,
* other than combinations with devices manufactured by or for TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license
* (including the above copyright notice and the disclaimer and (if applicable) source
* code license limitations below) in the documentation and/or other materials provided
* with the distribution
*
* Redistribution and use in binary form, without modification, are permitted provided
* that the following conditions are met:
*
* *       No reverse engineering, decompilation, or disassembly of this software is
* permitted with respect to any software provided in binary form.
*
* *       any redistribution and use are licensed by TI for use only with TI Devices.
*
* *       Nothing shall obligate TI to provide you with source code for the software
* licensed and provided to you in object code.
*
* If software source code is provided to you, modification and redistribution of the
* source code are permitted provided that the following conditions are met:
*
* *       any redistribution and use of the source code, including any resulting derivative
* works, are licensed by TI for use only with TI Devices.
*
* *       any redistribution and use of any object code compiled from the source code
* and any resulting derivative works, are licensed by TI for use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers
*
* may be used to endorse or promote products derived from this software without
* specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

  /****************************************************************************
  
    Project: icu
    Date   : 2023-05-12 17:54:54


    This file is generated by EB Tresos
    Do not modify this file,otherwise the software may behave in unexpected way.

 ******************************************************************************/

/**
 *  \file     Icu_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file
 *            for ICU MCAL driver.
 *
 */

/**
 *  \defgroup MCAL_ICU_CFG ICU Configuration
 *
 *  This files defines ICU MCAL configuration structures
 *  @{
 */

#ifndef ICU_CFG_H
#define ICU_CFG_H

#ifdef __cplusplus
extern "C" {
#endif
#include "Os.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
/**
 *  \brief ICU Build Variant.
 *   Build variants.(i.e Pre-compile,Post-build or Link time)
 */
#define ICU_PRE_COMPILE_VARIANT         (    STD_OFF)


/** \brief ISR type */
#define ICU_ISR_TYPE                (ICU_ISR_CAT1)

 /** \brief Enable/Disable Icu DeInit API */
#define ICU_DE_INIT_API                   (STD_ON)

/** \brief Enable/Disable Edge Count API */
#define ICU_EDGE_COUNT_API                (STD_ON)

/** \brief Enable/Disable Edge Detect API */
#define ICU_EDGE_DETECT_API               (STD_ON)

/** \brief Enable/Disable Get Duty Cycle Values API */
#define ICU_GET_DUTY_CYCLE_VALUES_API     (STD_ON)

/** \brief Enable/Disable Get Input State API */
#define ICU_GET_INPUT_STATE_API           (STD_ON)

/** \brief Enable/Disable Get Time Elapsed API */
#define ICU_GET_TIME_ELAPSED_API          (STD_ON)

/** \brief Enable/Disable Get Version Info API */
#define ICU_GET_VERSION_INFO_API          (STD_ON)

/** \brief Enable/Disable Signal Measurement API */
#define ICU_SIGNAL_MEASUREMENT_API        (STD_ON)

/** \brief Enable/Disable Timestamp  API */
#define ICU_TIMESTAMP_API                 (STD_ON)

/** \brief Enable/Disable Development error detet */
#define ICU_DEV_ERROR_DETECT              (STD_ON)
/**
*  \brief Channel ID
*  Symbolic Names Configured channel ID(s)
*/
#define IcuConf_IcuChannel_IcuChannel_0          (0U)
/**< Channel identifiers */


#define ICU_MAX_NUM_CHANNELS               (10U)

/*
 * ICU channels available for user
 */
/** \brief ECAP Channel 0, in MAIN DOMAIN */
#define ICU_CHANNEL0               (0U)


extern CONST(uint32, ICU_CONST)
    Icu_HwUnitBaseAddr[ICU_MAX_NUM_CHANNELS];



/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
/** \brief ICU Configuration structure declaration */
extern const struct Icu_ConfigType_PC_s IcuConfigSet_PC;
extern const struct Icu_ConfigType_s IcuConfigSet;




/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */
/**
 *  \brief ICU ISR
 */
/** ICU Channel 0 ISR */
    FUNC(void, ICU_CODE_FAST) Icu_ch0Notify(void);



#ifdef __cplusplus
}
#endif

#endif /* ICU_CFG_H */

/* @} */
