/*
*
* Copyright (c) 2022 Texas Instruments Incorporated
*
* All rights reserved not granted herein.
*
* Limited License.
*
* Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
* license under copyrights and patents it now or hereafter owns or controls to make,
* have made, use, import, offer to sell and sell ("Utilize") this software subject to the
* terms herein.  With respect to the foregoing patent license, such license is granted
* solely to the extent that any such patent is necessary to Utilize the software alone.
* The patent license shall not apply to any combinations which include this software,
* other than combinations with devices manufactured by or for TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license
* (including the above copyright notice and the disclaimer and (if applicable) source
* code license limitations below) in the documentation and/or other materials provided
* with the distribution
*
* Redistribution and use in binary form, without modification, are permitted provided
* that the following conditions are met:
*
* *       No reverse engineering, decompilation, or disassembly of this software is
* permitted with respect to any software provided in binary form.
*
* *       any redistribution and use are licensed by TI for use only with TI Devices.
*
* *       Nothing shall obligate TI to provide you with source code for the software
* licensed and provided to you in object code.
*
* If software source code is provided to you, modification and redistribution of the
* source code are permitted provided that the following conditions are met:
*
* *       any redistribution and use of the source code, including any resulting derivative
* works, are licensed by TI for use only with TI Devices.
*
* *       any redistribution and use of any object code compiled from the source code
* and any resulting derivative works, are licensed by TI for use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers
*
* may be used to endorse or promote products derived from this software without
* specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/
  /*****************************************************************************
    Project: icu
    Date   : 2023-05-12 17:54:54
    This file is generated by EB Tresos
    Do not modify this file,otherwise the software may behave in unexpected way.

 ******************************************************************************/
#include "Std_Types.h"
#include "Icu_Irq.h"
#ifdef __cplusplus

extern "C" {
#endif


/* ---- Perform version checking  ----------------------------------------- */
 #if ((ICU_SW_MAJOR_VERSION != (8U))||(ICU_SW_MINOR_VERSION != (6U)))
  #error "Version numbers of Icu_PBcfg.c and Icu_Cfg.h are inconsistent!"
#endif

#define ICU_START_SEC_CONFIG_DATA
#include "Icu_MemMap.h"








/* Icu Channel Configuration parameters */
 CONST(struct Icu_ConfigType_s, ICU_CONFIG_DATA)
     IcuConfigSet =
{
    .icuMaxChannel = 1U,
    .chCfg =
    {
        [0] =
        {
            .defaultStartEdge = ICU_BOTH_EDGES,/* Default start edge*/
            .xbarSelect = INPUT_XBAR_0,/* Xbar Select */
            .intrcapSelect = ECAP_INT_ALLCAPS, /* Capture Event interupt enable */
            .measurementMode = ICU_MODE_SIGNAL_MEASUREMENT,/* Measurement Mode*/
            .signalMeasurementProperty = ICU_PERIOD_TIME,
            .instanceClkMHz = 200U,
            .prescaler = 0, /* prescale */
        }
    },
};

#ifdef __cplusplus
}
#endif

/*</ICU_CONFIGURATION>*/
#define ICU_STOP_SEC_CONFIG_DATA
#include "Icu_MemMap.h"

#define  ICU_START_SEC_ISR_CODE
#include "Icu_MemMap.h"

/**
 *  \brief ICU ISR
 */

#if defined CLANG
__attribute__((target("arm")))
#endif
#if ((ICU_ISR_TYPE == ICU_ISR_CAT1) || (ICU_ISR_TYPE == ICU_ISR_VOID))
 void Icu_ch0Notify(void)
#elif (ICU_ISR_TYPE == ICU_ISR_CAT2)
ISR(Icu_ch0Notify)
#endif
{
    Icu_IntISR_Fun(ICU_CHANNEL0);
}


#define  ICU_STOP_SEC_ISR_CODE
#include "Icu_MemMap.h"


/*******************************************************************************
 *  END OF FILE: Icu_PBcfg.c                                                   *
 ******************************************************************************/
