/* ======================================================================
 *   Copyright (c) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Cdd_Ipc_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file
 *            for Complex device driver
 */

  /*********************************************************************************************************************
    Project: ipc
      Date   : 2023-05-05 15:47:59 
    
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
 *********************************************************************************************************************/

/**
 *  \defgroup CDD_IPC_CFG  Configuration
 *
 *  This files defines CDD IPC configuration structures
 *  @{
 */

#ifndef CDD_IPC_CFG_H_
#define CDD_IPC_CFG_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "Std_Types.h"
#include "Os.h"
#include "Dem.h"
#include "Det.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 *  \name CDD Driver Configuration SW Version Info
 *
 *  Defines for CDD Driver configuration version
 *  @{
 */
/** \brief CDD configuration Major Version */
#define CDD_IPC_CFG_MAJOR_VERSION           (8U)
/** \brief CDD configuration Minor Version */
#define CDD_IPC_CFG_MINOR_VERSION           (6U)
/** \brief CDD configuration Patch Version */
#define CDD_IPC_CFG_PATCH_VERSION           (2U)
/* @} */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
/** \brief SPI Config ID */
#define CDD_IPC_ID                      (0x1U)


/** \brief Enable/disable CDD dev detect error */
/* Requirements:  */
#define CDD_IPC_DEV_ERROR_DETECT      (STD_ON)

/** \brief ISR type */
#define CDD_IPC_ISR_TYPE              (CDD_IPC_ISR_VOID)

/** \brief Number of Buffers for the RpMsg*/
#define CDD_IPC_NUM_OF_BUFFERS            (8U)

/** \brief Size of each buffer for the RpMsg*/
#define CDD_IPC_MAX_BUFFER_SIZE              (128U)

/** \brief VRING Size calculation for buffer allocation in Mbox memory*/
#define CDD_IPC_VRING_SIZE                (((CDD_IPC_NUM_OF_BUFFERS)*((CDD_IPC_MAX_BUFFER_SIZE)+32U))+32)

/** \brief Timeout value for the read/write/sync API's. Unit is in clock ticks (Default value is 5 milli seconds (2*10^6 ticks))*/
#define CDD_IPC_TIMEOUT                 (2000000U)

#define CDD_IPC_LOCALEP_COUNT           (1U)


/** \brief IPC Shared memory size for the selected number of buffers and the buffer size*/
#define CDD_IPC_SHARED_MEMORY_SIZE (15744U)

#define CDD_IPC_R5FSS0_0_ID   (0U)
#define CDD_IPC_R5FSS0_1_ID   (1U) 
#define CDD_IPC_R5FSS1_0_ID   (2U) 
#define CDD_IPC_R5FSS1_1_ID   (3U) 
#define CDD_IPC_CORE_ID_MAX   (4U)

#define CDD_IPC_MAX_ENDPOINTS_PER_CORE (64U)   

#define CDD_IPC_MAX_NOTIFY_CLIENT_ID_PER_CORE (16U)

/**
 *  \name Pre-Compile Switches for API Services
 *  @{
 */
/** \brief Enable/disable CDD get version info API */
#define CDD_IPC_VERSION_INFO_API                                  (STD_ON)
/** \brief Enable/disable CDD deinit API */
#define CDD_IPC_DEINIT_API                                        (STD_ON)
/** \brief Enable/disable CDD  Write API */
#define CDD_IPC_WRITE_API                                         (STD_ON)
/** \brief Enable/disable CDD Read API */
#define CDD_IPC_READ_API                                          (STD_ON)
/** \brief Enable/disable CDD RPMsg APIs */
#define CDD_IPC_RPMSG_ENABLE_API                                  (STD_ON)
/** \brief CDD register readback functionality API */
#define CDD_IPC_REGISTER_READBACK_API                             (STD_OFF)
/** \brief Counter ID for counter used to count wait ticks */
#define CDD_IPC_OS_COUNTER_ID               ((CounterType)0U)

/** \brief Symbolic names for the Cdd Ipc Local End points for better indexing */
#define CddIpcConf_CddIpclocalEndPt_CddIpcEndPtConfig_0   0

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/**
 *  \brief This type defines a range of specific status for Complex driver
 */
 /** Requirements :  AUTORADAR_MCAL-70 */
typedef enum
{
    CDD_IPC_UNINIT = 0U,
    /**< The Complex Driver is not initialized or not usable */
    CDD_IPC_IDLE = 1U,
    /**< The Complex Driver is not currently  writing */
    CDD_IPC_ALLOW_ACCESS = 2U,
    /**< The Complex Driver is  currently open */
    CDD_IPC_BUSY = 3U,
    /**< The Complex Driver is performing a Write*/
    CDD_IPC_CLOSE = 4U,
       /**< The Complex Driver is  currently open */
} Cdd_IpcStatusType;

typedef struct Cdd_Ipc_RPMessage_EpObject_s {
    uint32 rsv[192/sizeof(uint32)]; /**< reserved, should NOT be modified by end users */
} Cdd_Ipc_RPMessage_EpObject;

typedef void (*Cdd_Ipc_RPMessage_lld_recvCallback)(void *handle, Cdd_Ipc_RPMessage_EpObject *obj, void *arg,
    void *data, uint16 dataLen,
    uint16 remoteCoreId, uint16 remoteEndPt);

typedef void (*Cdd_Ipc_RPMessage_lld_recvNotifyCallback)(void *handle, Cdd_Ipc_RPMessage_EpObject *obj, void *arg);

typedef struct
{
    uint32 Cdd_Ipc_localEndPt;
    Cdd_Ipc_RPMessage_lld_recvCallback recvCallback;
    void *recvCallbackArgs;
    Cdd_Ipc_RPMessage_lld_recvNotifyCallback recvNotifyCallback;
    void *recvNotifyCallbackArgs;
}Cdd_IpcCreateParams;


typedef struct
{
    uint32 Cdd_Ipc_SelfCoreId;
    uint32 Cdd_Ipc_numCores;
    uint32 Cdd_Ipc_coreIdList[CDD_IPC_CORE_ID_MAX];
 	#if(CDD_IPC_RPMSG_ENABLE_API == STD_ON)
    Cdd_IpcCreateParams Cdd_Ipc_RpMsgParams[CDD_IPC_LOCALEP_COUNT];
	#endif
  
}Cdd_IpcConfigType;


/** \brief Cdd Configuration struct declaration */
extern CONST(Cdd_IpcConfigType, CDD_PBCFG)CddIpcDriver_0; 

extern P2CONST(Cdd_IpcConfigType, AUTOMATIC, CDD_PBCFG)CfgPtr;

/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif

#endif  /* #ifndef CDD_IPC_H_ */

/* @} */



