/* ======================================================================
 *   Copyright (c) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Cdd_Ipc_PBCfg.c
 *
 *  \brief    This file contains generated post build configuration file
 *            for Complex device driver
 */

  /*********************************************************************************************************************
  Project: ipc
    Date   : 2023-05-05 15:47:59
    
    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/


#define CDD_PBCFG_SOURCE 1U

/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/
#include "Cdd_Ipc.h"
#include "soc.h"

/**********************************************************************************************************************
 *  VERSION CHECK
 *********************************************************************************************************************/
#if (   (CDD_IPC_CFG_MAJOR_VERSION != (8U)) \
    ||(CDD_IPC_CFG_MINOR_VERSION != (6U)))
  #error "Version numbers of Cdd_Ipc_PbCfg.c and Cdd_Ipc_Cfg.h are inconsistent!"
#endif

/**********************************************************************************************************************
 *  LOCAL CONSTANT MACROS
 **********************************************************************************************************************/

/**********************************************************************************************************************
 *  LOCAL FUNCTION MACROS
 **********************************************************************************************************************/

/**********************************************************************************************************************
 *  LOCAL DATA TYPES AND STRUCTURES
 **********************************************************************************************************************/

/**********************************************************************************************************************
 *  LOCAL DATA PROTOTYPES
 **********************************************************************************************************************/

/**********************************************************************************************************************
 *  GLOBAL DATA
 **********************************************************************************************************************/

#define  CDD_IPC_START_SEC_CONFIG_DATA
#include "Cdd_Ipc_MemMap.h"

/*
 * Requirements : AUTORADAR_MCAL-66, AUTORADAR_MCAL-65
*/

CONST(Cdd_IpcConfigType, CDD_PBCFG) CddIpcDriver_0 =
{
    .Cdd_Ipc_SelfCoreId = CDD_IPC_R5FSS0_0_ID,
    .Cdd_Ipc_numCores = 3,
    .Cdd_Ipc_coreIdList = {
        CDD_IPC_R5FSS0_1_ID,
        CDD_IPC_R5FSS1_0_ID,
        CDD_IPC_R5FSS1_1_ID,
        },

    .Cdd_Ipc_RpMsgParams = 
    {
        
        [0] = 
        {
        .Cdd_Ipc_localEndPt = 12,
        .recvCallback = NULL,
        .recvCallbackArgs = NULL,
        .recvNotifyCallback = NULL,
        .recvNotifyCallbackArgs = NULL,
        },
    }

            
};

P2CONST(Cdd_IpcConfigType, AUTOMATIC, CDD_PBCFG)CfgPtr = &CddIpcDriver_0;

#if(CDD_IPC_RPMSG_ENABLE_API == STD_ON)
/* IPC RPMessage init objects */
extern IpcNotify_Object CddIpc_NotifyObject;

uint8 Cdd_RPMessageVringMem[12][CDD_IPC_VRING_SIZE] __attribute__((aligned(128), section("ipc_vring")));

RPMessageLLD_InitObject CddIpc_RPMessageInitObj =
{
    /* VRING mapping from source core to destination core, '-1' means NO VRING,
    r5fss0_0 => {"r5fss0_0":-1,"r5fss0_1":0,"r5fss1_0":1,"r5fss1_1":2}
    r5fss0_1 => {"r5fss0_0":3,"r5fss0_1":-1,"r5fss1_0":4,"r5fss1_1":5}
    r5fss1_0 => {"r5fss0_0":6,"r5fss0_1":7,"r5fss1_0":-1,"r5fss1_1":8}
    r5fss1_1 => {"r5fss0_0":9,"r5fss0_1":10,"r5fss1_0":11,"r5fss1_1":-1}
*/
    /* TX VRINGs */
    .vringTxBaseAddr[CDD_IPC_R5FSS0_1_ID] = (uint32)Cdd_RPMessageVringMem[0],
    .vringTxBaseAddr[CDD_IPC_R5FSS1_0_ID] = (uint32)Cdd_RPMessageVringMem[1],
    .vringTxBaseAddr[CDD_IPC_R5FSS1_1_ID] = (uint32)Cdd_RPMessageVringMem[2],
    /* RX VRINGs */
    .vringRxBaseAddr[CDD_IPC_R5FSS0_1_ID] = (uint32)Cdd_RPMessageVringMem[3],
    .vringRxBaseAddr[CDD_IPC_R5FSS1_0_ID] = (uint32)Cdd_RPMessageVringMem[6],
    .vringRxBaseAddr[CDD_IPC_R5FSS1_1_ID] = (uint32)Cdd_RPMessageVringMem[9],
    /* Other VRING properties */
    .vringSize = CDD_IPC_VRING_SIZE,
    .vringNumBuf = CDD_IPC_NUM_OF_BUFFERS,
    .vringMsgSize = CDD_IPC_MAX_BUFFER_SIZE,

    .hIpcNotify = &CddIpc_NotifyObject,
};

#endif

#define  CDD_IPC_STOP_SEC_CONFIG_DATA
#include "Cdd_Ipc_MemMap.h"

/**********************************************************************************************************************
 *  END OF FILE: Cdd_PBcfg.c
 *********************************************************************************************************************/
