/* ======================================================================
 *   Copyright (C) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Mcu_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file
 *            for MCU MCAL driver
 *
 */

/**
 *  \defgroup MCAL_MCU_CFG MCU Configuration
 *
 *  This files defines MCU MCAL configuration structures
 *  @{
 */

 /*********************************************************************************************************************
    Project: MCU_Am263
	Date   : 2023-05-06 20:00:29

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/
 /* Protection against multiple inclusion */
#ifndef MCU_CFG_H
#define MCU_CFG_H

/*********************************************************************************************************************
 * Standard Header Files
 *********************************************************************************************************************/
#include "Mcu.h"
/*********************************************************************************************************************
 * Other Header Files
 *********************************************************************************************************************/
#include "Dem.h"
#ifdef __cplusplus
extern "C" {
#endif

/**********************************************************************************************************************
 * Version Check
 *********************************************************************************************************************/
/** \brief MCU Config ID */
#define MCU_CFG_ID                      (0x1U)

/* Requirements: SWS_Mcu_00129 */
/**
 *  \name Mcu Driver Configuration SW Version Info
 *
 *  Defines for Mcu Driver configuration version
 *  @{
 */
/** \brief Mcu configuration Major Version */
#define MCU_CFG_MAJOR_VERSION           (8U)
/** \brief Mcu configuration Minor Version */
#define MCU_CFG_MINOR_VERSION           (6U)
/** \brief Mcu configuration Patch Version */
#define MCU_CFG_PATCH_VERSION           (2U)
/* @} */


/*********************************************************************************************************************
 * Exported enums
 *********************************************************************************************************************/
/**
* \brief  Type of McuModes supported
*/
enum
{
   MCU_MODE_NORMAL = 1 /*!< Mcu normal mode. Only supported mode */
};

/*********************************************************************************************************************
 * Exported Preprocessor #define Constants
 *********************************************************************************************************************/
/** \brief Enable/Disable Development Error Detection */
#define MCU_DEV_ERROR_DETECT       (STD_ON)
/** \brief Enable/Disable Mcu_CheckRamState() API */
#define MCU_GET_RAM_STATE_API      (STD_ON)
/** \brief Enable/Disable Mcu_InitClock() API */
#define MCU_INIT_CLOCK_API         (STD_ON)
/** \brief Enable/Disable Mcu_PerformReset() API */
#define MCU_PERFORM_RESET_API      (STD_ON)
/** \brief Enable/Disable Mcu_GetVersionInfo() API */
#define MCU_GET_VERSION_INFO_API   (STD_ON)
/** \brief Enable/Disable Mcu_InitRamSection() API */
#define MCU_INIT_RAM_API           (STD_ON)
/** \brief Enable/Disable PLL support */
#define MCU_NO_PLL                 (STD_ON)
/** \brief Enable/Disable Mcu_ClearResetReason() API */
#define MCU_REGISTER_READBACK_API (STD_ON)
/** \brief Enable/Disable MCU Interrupt Crossbar */
#define MCU_INTRCROSSBAR_ENABLE      (STD_ON)
/** \brief Enable/Disable MCU Input Crossbar */
#define MCU_INPUT_CROSSBAR_ENABLE      (STD_ON)
/** \brief Enable/Disable MCU PWM Enable */
#define MCU_PWM_ENABLE (STD_ON)
/** \brief Enable/Disable MCU ADC Enable */
#define MCU_ADC_ENABLE (STD_ON)

/*
Reset Reason Config
*/
/*<MCU_CFG_RESETREASONUSERCONFIG_LIST>*/

#define McuConf_McuResetReasonConf_MCU_POWER_ON_RESET (1U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_WDT0 (2U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_WDT1 (3U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_WDT2 (4U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_WDT3 (5U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET (6U)


#define McuConf_McuResetReasonConf_MCU_EXT_PAD_RESET (7U)


#define McuConf_McuResetReasonConf_MCU_HSM_WDT_RESET (8U)


#define McuConf_McuResetReasonConf_MCU_DEBUGGER_RESET (9U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_TEMP0 (10U)


#define McuConf_McuResetReasonConf_MCU_WARM_RESET_TEMP1 (11U)


#define McuConf_McuResetReasonConf_MCU_RESET_UNDEFINED (12U)




/*
 * The following defines shall be used as input
 * parameter for: Mcu_SetMode(),
 *                Mcu_InitClock()
 *                Mcu_InitRamSection()
 */

/*<MCU_CFG_MODEUSERCONFIG_LIST>*/


#define McuConf_McuModeSettingConf_McuModeSettingConf_0 MCU_MODE_NORMAL


/*</MCU_CFG_MODEUSERCONFIG_LIST>*/

#define MCU_VARIANT_PRE_COMPILE       (STD_OFF)

#define MCU_VARIANT_POST_BUILD        (STD_ON)



/*
* Clock configuration
*/
/* SourceId : MCU_SourceId_040 */
/* Requirements : AR_MCU_SR125, AR_MCU_SR126 */
/*<MCU_CFG_CLOCKUSERCONFIG_LIST>*/
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_QSPI (0U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCAN0 (1U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCAN1 (2U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCAN2 (3U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCAN3 (4U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RTI0 (5U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RTI1 (6U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RTI2 (7U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RTI3 (8U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI0 (9U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI1 (10U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI2 (11U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI3 (12U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MCSPI4 (13U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_I2C (14U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI0 (15U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI1 (16U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI2 (17U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI3 (18U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI4 (19U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_SCI5 (20U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_CPSW (21U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_CPTS_0 (22U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_RGMI_CLK (23U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MII100_CLK (24U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_MII10_CLK (25U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_CPTS_2 (26U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_WDT0 (27U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_WDT1 (28U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_WDT2 (29U)
#define McuConf_McuClockSettingConfig_McuClockSettingConfig_WDT3 (30U)

/*</MCU_CFG_CLOCKUSERCONFIG_LIST>*/

/*
* RAM Section configuration
*/
/*<MCU_CFG_RAMSECTIONUSERCONFIG_LIST>*/
#define McuConf_McuRamSectorSettingConf_McuRamSectorSettingConf (11U)

/*</MCU_CFG_RAMSECTIONUSERCONFIG_LIST>*/


/** \brief Counter ID for counter used to count wait ticks */
#define MCU_OS_COUNTER_ID               ((CounterType)1U)

/**
*  \brief MCU timeout.
*   Each tick is 31.25us (for 32K Counter). Wait for 5s which comes to
*   below value
*/
#define MCU_TIMEOUT_DURATION            (32000U)

/** \brief MCU PLL timeout.*/
#define MCU_PLL_TIMEOUT_DURATION            (6600U)

/* DEM Error Definitions */
/* DEM Error Codes */
/** \brief No event error code */
#define DemConf_DemEventParameter_MCU_DEM_NO_EVENT (0xFFFFU)
#define MCU_DEM_NO_EVENT DemConf_DemEventParameter_MCU_DEM_NO_EVENT

/* MCU DEM Event Configuration*/
#ifndef MCU_E_MODE_FAILURE
/** \brief MCU Mode failed - Additional DEM event supported by the Texas Instruments*/
#define MCU_E_MODE_FAILURE (MCU_DEM_NO_EVENT)
#endif

/* MCU DEM Event Configuration*/
#ifndef MCU_E_CLOCK_FAILURE
/** \brief MCU Clock failed - AUTOSAR ECUC Driver SWS Item - ECUC_Mcu_00188*/
#define MCU_E_CLOCK_FAILURE (DemConf_DemEventParameter_MCU_E_CLOCK_FAILURE)
#endif


/* MCU PWM Channel */
#define MCU_PWM_CHANNEL (2U)

/* MCU ADC Channel */
#define MCU_ADC_HWUNIT (2U)

/** @brief Number of ETPWM instances */
#define MCU_CSL_ETPWM_PER_CNT                (32U)

/*Control MMRs partition*/
#define MCU_TOP_CTRL_PARTITION0                                (2)
#define MCU_CONTROLSS_CTRL_PARTITION0                          (3)

#define MCU_CSL_CONTROLSS_CTRL_EPWM_STATICXBAR_SEL0                          (0x00000004U)

#define MCU_CSL_CONTROLSS_CTRL_U_BASE                  (0x502F0000ul)
#define MCU_CSL_CONTROLSS_CTRL_LOCK0_KICK0                                   (0x00001008U)
#define MCU_CSL_CONTROLSS_CTRL_LOCK0_KICK1                                   (0x0000100CU)

#define MCU_CSL_CONTROLSS_CTRL_EPWM_CLKSYNC                                  (0x00000010U)

/* EPWM_CLKSYNC */
#define MCU_CSL_CONTROLSS_CTRL_EPWM_CLKSYNC_BIT_MASK                         (0xFFFFFFFFU)

/* define the unlock and lock values for MSS_CTRL, TOP_CTRL, MSS_RCM, TOP_RCM*/
#define MCU_TEST_KICK_LOCK_VAL                           (0x00000000U)
#define MCU_TEST_KICK0_UNLOCK_VAL                        (0x01234567U)
#define MCU_TEST_KICK1_UNLOCK_VAL                        (0x0FEDCBA8U)

/* EPWM_CHANNELS */
#define MCU_PWM_CHANNEL_0   0
#define MCU_PWM_CHANNEL_1   1 
#define MCU_PWM_CHANNEL_2   2
#define MCU_PWM_CHANNEL_3   3
#define MCU_PWM_CHANNEL_4   4
#define MCU_PWM_CHANNEL_5   5
#define MCU_PWM_CHANNEL_6   6
#define MCU_PWM_CHANNEL_7   7
#define MCU_PWM_CHANNEL_8   8
#define MCU_PWM_CHANNEL_9   9
#define MCU_PWM_CHANNEL_10 10
#define MCU_PWM_CHANNEL_11 11
#define MCU_PWM_CHANNEL_12 12
#define MCU_PWM_CHANNEL_13 13
#define MCU_PWM_CHANNEL_14 14
#define MCU_PWM_CHANNEL_15 15
#define MCU_PWM_CHANNEL_16 16
#define MCU_PWM_CHANNEL_17 17
#define MCU_PWM_CHANNEL_18 18
#define MCU_PWM_CHANNEL_19 19
#define MCU_PWM_CHANNEL_20 20
#define MCU_PWM_CHANNEL_21 21
#define MCU_PWM_CHANNEL_22 22
#define MCU_PWM_CHANNEL_23 23
#define MCU_PWM_CHANNEL_24 24
#define MCU_PWM_CHANNEL_25 25
#define MCU_PWM_CHANNEL_26 26
#define MCU_PWM_CHANNEL_27 27
#define MCU_PWM_CHANNEL_28 28
#define MCU_PWM_CHANNEL_29 29
#define MCU_PWM_CHANNEL_30 30
#define MCU_PWM_CHANNEL_31 31

/* EPWM_GROUPS */
#define MCU_PWM_CONTROLSS_G0   0
#define MCU_PWM_CONTROLSS_G1   1 
#define MCU_PWM_CONTROLSS_G2   2
#define MCU_PWM_CONTROLSS_G3   3

/* ADC_GROUPS */
#define MCU_ADC_HWUNIT_0   0
#define MCU_ADC_HWUNIT_1   1 
#define MCU_ADC_HWUNIT_2   2
#define MCU_ADC_HWUNIT_3   3
#define MCU_ADC_HWUNIT_4   4

/* ADC BUFFER CONTROL */
#define MCU_CSL_TOP_CTRL_ADC_REFBUF0_CTRL                                     (0x00000C00U)
#define MCU_CSL_TOP_CTRL_ADC_REFBUF1_CTRL                                     (0x00000C04U)
		 
#define MCU_CSL_TOP_CTRL_ADC_REF_COMP_CTRL                                    (0x00000C08U)
		 
#define MCU_CSL_TOP_CTRL_U_BASE                  (0x50D80000ul)

void Mcu_IntXbar(void);
void Mcu_InputXbar(void);

/*********************************************************************************************************************
 *  Exported Object Declarations
 *********************************************************************************************************************/

/** \brief MCU Configuration struct declaration */
extern const struct Mcu_ConfigType_s McuModuleConfiguration;



#ifdef __cplusplus
}
#endif

#endif /* #ifndef MCU_CFG_H */
/**********************************************************************************************************************
 *  End of File: Mcu_Cfg.h
 *********************************************************************************************************************/
