
/* ======================================================================
 *   Copyright (C) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Mcu_PBcfg.c
 *
 *  \brief    This file contains generated post build configuration file
 *            for MCU MCAL driver
 *
 */

 /*********************************************************************************************************************
    Project: MCU_Am263
	Date   : 2023-05-06 20:00:29

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/

/* Module switch */
#define MCU_PBCFG_SOURCE

/**********************************************************************************************************************
 * Standard Header Files
 **********************************************************************************************************************/

/*********************************************************************************************************************
 * Other Header Files
 *********************************************************************************************************************/
#include "Mcu.h"
#include "Mcu_Xbar.h"
/**********************************************************************************************************************
 *  Version Check
 *********************************************************************************************************************/

/*  Version checking  */
#if ((MCU_SW_MAJOR_VERSION != (8U))||(MCU_SW_MINOR_VERSION != (6U)))
   #error "Version numbers of Mcu_PBcfg.c and Mcu.h are inconsistent!"
#endif

#if ((MCU_CFG_MAJOR_VERSION != (8U))||(MCU_CFG_MINOR_VERSION != (6U)))
  #error "Version numbers of Mcu_PBcfg.c and Mcu_Cfg.h are inconsistent!"
#endif
/**********************************************************************************************************************
 * Local Preprocessor #define Constants
 **********************************************************************************************************************/

/**********************************************************************************************************************
 * Local Preprocessor #define Macros
 **********************************************************************************************************************/

/**********************************************************************************************************************
 * Local Data Types and Structures
 **********************************************************************************************************************/
#define MCU_START_SEC_CONFIG_DATA
#include "Mcu_MemMap.h"

/**********************************************************************************************************************
 * Constants for Post-Build Configuration
 **********************************************************************************************************************/

/* SourceId : MCU_SourceId_031 */
/* DesignId : MCU_DesignId_019 */
/* Requirements : AR_MCU_SR122, AR_MCU_SR132, AR_MCU_SR133, AR_MCU_SR134, AR_MCU_SR135 */

static CONST(Mcu_RamSectionConfigType, MCU_CONFIG_DATA) Mcu_RamSectionConfig[] =
{
    {
	   ((uint8*)0x70000000),
	   0xbeU,
	   256U
    }

};




#define  MCU_STOP_SEC_CONFIG_DATA
#include "Mcu_MemMap.h"

#define  MCU_START_SEC_CONFIG_DATA
#include "Mcu_MemMap.h"
/* SourceId : MCU_SourceId_031 */
/* DesignId : MCU_DesignId_019 */
/* Requirements : AR_MCU_SR122, AR_MCU_SR132, AR_MCU_SR133, AR_MCU_SR134, AR_MCU_SR135 */

static CONST(Mcu_ClockConfigType, MCU_CONFIG_DATA) Mcu_ClockConfiguration[] =
{
    [0] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_QSPI,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 4,
        .Mcu_InitCfg  = TRUE,
    },
    [1] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCAN0,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 4,
        .Mcu_InitCfg  = TRUE,
    },
    [2] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCAN1,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 4,
        .Mcu_InitCfg  = TRUE,
    },
    [3] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCAN2,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 4,
        .Mcu_InitCfg  = TRUE,
    },
    [4] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCAN3,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 4,
        .Mcu_InitCfg  = TRUE,
    },
    [5] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_RTI0,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [6] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_RTI1,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [7] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_RTI2,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [8] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_RTI3,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [9] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCSPI0,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 7,
        .Mcu_InitCfg  = TRUE,
    },
    [10] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCSPI1,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 7,
        .Mcu_InitCfg  = TRUE,
    },
    [11] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCSPI2,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 7,
        .Mcu_InitCfg  = TRUE,
    },
    [12] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCSPI3,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 7,
        .Mcu_InitCfg  = TRUE,
    },
    [13] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MCSPI4,
        .Mcu_ClockSourceId = MCU_CLKSRC_4,
        .Mcu_ClockDiv = 7,
        .Mcu_InitCfg  = TRUE,
    },
    [14] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_I2C,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 7,
        .Mcu_InitCfg  = TRUE,
    },
    [15] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_SCI0,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 3,
        .Mcu_InitCfg  = TRUE,
    },
    [16] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_SCI1,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 3,
        .Mcu_InitCfg  = TRUE,
    },
    [17] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_SCI2,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 3,
        .Mcu_InitCfg  = TRUE,
    },
    [18] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_SCI3,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 3,
        .Mcu_InitCfg  = TRUE,
    },
    [19] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_SCI4,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 3,
        .Mcu_InitCfg  = TRUE,
    },
    [20] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_SCI5,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 3,
        .Mcu_InitCfg  = TRUE,
    },
    [21] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_CPSW,
        .Mcu_ClockSourceId = MCU_CLKSRC_0,
        .Mcu_ClockDiv = 200,
        .Mcu_InitCfg  = TRUE,
    },
    [22] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_CPTS,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 200,
        .Mcu_InitCfg  = TRUE,
    },
    [23] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_RGMI_CLK,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 1,
        .Mcu_InitCfg  = TRUE,
    },
    [24] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MII100_CLK,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 9,
        .Mcu_InitCfg  = TRUE,
    },
    [25] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_MII10_CLK,
        .Mcu_ClockSourceId = MCU_CLKSRC_3,
        .Mcu_ClockDiv = 99,
        .Mcu_InitCfg  = TRUE,
    },
    [26] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_CPTS,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [27] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_WDT0,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [28] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_WDT1,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [29] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_WDT2,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    },
    [30] =
    {
        .Mcu_ClockModuleId = MCU_CLKSRC_MODULE_ID_WDT3,
        .Mcu_ClockSourceId = MCU_CLKSRC_2,
        .Mcu_ClockDiv = 0,
        .Mcu_InitCfg  = TRUE,
    }
};




static CONST(Mcu_PwmConfigType, MCU_PBCFG) Mcu_PwmConfiguration[MCU_PWM_CHANNEL] =
{
    [0] =
    {
        .Mcu_PwmChannelId = 0,
        .Mcu_PwmGroupId = MCU_PWM_CONTROLSS_G0,
    },
	[1] =
    {
        .Mcu_PwmChannelId = 1,
        .Mcu_PwmGroupId = MCU_PWM_CONTROLSS_G0,
    }
};





static CONST(Mcu_AdcConfigType, MCU_PBCFG) Mcu_AdcConfiguration[MCU_ADC_HWUNIT] =
{
    [0] =
    {
        .Mcu_AdcHWUniId = MCU_ADC_HWUNIT_0,
    },
    [1] =
    {
        .Mcu_AdcHWUniId = MCU_ADC_HWUNIT_3,
    }
};


#define  MCU_STOP_SEC_CONFIG_DATA
#include "Mcu_MemMap.h"

#define  MCU_START_SEC_CONFIG_DATA
#include "Mcu_MemMap.h"

/*<MCU_CFG_CONFIG>*/
/* SourceId : MCU_SourceId_041 */
/* DesignId : MCU_DesignId_019 */
/* Requirements : AR_MCU_SR124, AR_MCU_SR125, AR_MCU_SR126 */

CONST(Mcu_ConfigType, MCU_CONFIG_DATA) McuModuleConfiguration =
{
    .Mcu_ResetMode = MCU_PERFORM_RESET_MODE_WARM,
    /**< Reset mode to be used @sa  MCAL_MCU_API:ResetModes */
    .Mcu_ConfigRamSection = Mcu_RamSectionConfig,
    /**< Configration of Ram Sections */
    .Mcu_NumberOfRamSectors =  1,
    /**< Number of entries in Mcu_ConfigRamSection */
    .Mcu_ClockConfig = Mcu_ClockConfiguration,
    /**< Configuration of Module functional clock source */
    .Mcu_NumberOfClockConfig = 31,
    /**< Number of entries in Mcu_ClockConfig */
#if (STD_OFF == MCU_NO_PLL)
    .Mcu_PllConfig = Mcu_PLLConfiguration,
    /**< PLL Configuration */
    .Mcu_PllSourceId = MCU_CLKSRC_DPLL,
    /**< PLL source selection */
#endif
#if (STD_ON == MCU_PWM_ENABLE)
    .Mcu_Pwmconfig = Mcu_PwmConfiguration,
    /**< PWM Configuration */
#endif
#if (STD_ON == MCU_ADC_ENABLE)
    .Mcu_AdcConfig = Mcu_AdcConfiguration,
    /**< ADC Configuration */
#endif
};



void Mcu_IntXbar(void)
{
    /* Interrupt XBAR */

    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_0,MCU_INT_XBAR_EPWM0_INT, 0, 0, 0, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_1,MCU_INT_XBAR_EPWM1_INT, 0, 0, 0, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_2,0, 0, MCU_INT_XBAR_ADC0_INT1, 0, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_3,0, 0, MCU_INT_XBAR_ADC0_INT2, 0, 0, 0, 0);
    MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_4,0, 0, MCU_INT_XBAR_ADC0_INT3, 0, 0, 0, 0);
    //MCU_xbarSelectInterruptXBarInputSource(MCU_CSL_CONTROLSS_INTXBAR_U_BASE, MCU_INTRXBAR0_OUT_2,MCU_INT_XBAR_ADC3_INT1, 0, MCU_INT_XBAR_ADC3_INT1, 0, 0, 0, 0);
}

void Mcu_InputXbar(void)
{
    /* Input XBAR */

    MCU_xbarSelectInputXBarInputSource(MCU_CSL_CONTROLSS_INPUTXBAR_U_BASE, MCU_INPUT_XBAR0_OUT_0, 0, MCU_INPUT_XBAR_GPIO0, 0);
}
/*</MCU_CFG_CONFIG>*/ 
#define  MCU_STOP_SEC_CONFIG_DATA
#include "Mcu_MemMap.h"
/**********************************************************************************************************************
 *  End of File: Mcu_PBcfg.c
 *********************************************************************************************************************/

