/* ======================================================================
 *   Copyright (C) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Port_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file
 *            for PORT MCAL driver
 *
 */

/**
 *  \defgroup MCAL_PORT_CFG PORT Configuration
 *
 *  This files defines PORT MCAL configuration structures
 *  @{
 */

/**********************************************************************************************************************
    Project: AM263x
    Date   : 2023-05-05 22:44:32

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/
#ifndef PORT_CFG_H
#define PORT_CFG_H

/**********************************************************************************************************************
 * INCLUDES
 *********************************************************************************************************************/
/*LDRA_NOANALYSIS*/
#include "Std_Types.h"
/*LDRA_ANALYSIS*/

#include "Dem.h"
#include "Os.h"

#ifdef __cplusplus
extern "C" {
#endif

/**********************************************************************************************************************
 *  GLOBAL CONSTANT MACROS
 *********************************************************************************************************************/
/** \brief PORT Config ID */
#define PORT_CFG_ID                      (0x1U)

/**
 *  \name Port Driver Configuration SW Version Info
 *
 *  Defines for Port Driver configuration version
 *  @{
 */
/** \brief Port configuration Major Version */
#define PORT_CFG_MAJOR_VERSION           (8U)
/** \brief Port configuration Minor Version */
#define PORT_CFG_MINOR_VERSION           (6U)
/** \brief Port configuration Patch Version */
#define PORT_CFG_PATCH_VERSION           (2U)
/* @} */

/**
*  \brief PORT Build Variant.
*   Build variants.(i.e Pre Compile,Post Build)
*/
#define PORT_PRE_COMPILE_VARIANT   (STD_OFF)

#define PORT_POST_BUILD_VARIANT    (STD_ON)



/* List of symbolic names for Dio pin channels */
/*<PORT_PIN_CHANNEL_LIST>*/


#define PortConf_PortPin_PortPin_0 (41U)

#define PortConf_PortPin_PortPin_1 (24U)

#define PortConf_PortPin_PortPin_2 (6U)

#define PortConf_PortPin_PortPin_3 (14U)

#define PortConf_PortPin_PortPin_4 (13U)

#define PortConf_PortPin_PortPin_5 (2U)

#define PortConf_PortPin_PortPin_6 (37U)

#define PortConf_PortPin_PortPin_7 (36U)

#define PortConf_PortPin_PortPin_8 (19U)

#define PortConf_PortPin_PortPin_9 (126U)

#define PortConf_PortPin_PortPin_10 (122U)

#define PortConf_PortPin_PortPin_11 (127U)

#define PortConf_PortPin_PortPin_12 (121U)

#define PortConf_PortPin_PortPin_13 (134U)

#define PortConf_PortPin_PortPin_14 (128U)

#define PortConf_PortPin_PortPin_15 (102U)

#define PortConf_PortPin_PortPin_16 (103U)

#define PortConf_PortPin_PortPin_17 (95U)

#define PortConf_PortPin_PortPin_18 (94U)

#define PortConf_PortPin_PortPin_19 (101U)

#define PortConf_PortPin_PortPin_20 (100U)

#define PortConf_PortPin_PortPin_21 (116U)

#define PortConf_PortPin_PortPin_22 (115U)

#define PortConf_PortPin_PortPin_23 (90U)

#define PortConf_PortPin_PortPin_24 (89U)

#define PortConf_PortPin_PortPin_25 (108U)

#define PortConf_PortPin_PortPin_26 (91U)

#define PortConf_PortPin_PortPin_27 (117U)

#define PortConf_PortPin_PortPin_28 (123U)

#define PortConf_PortPin_PortPin_29 (142U)

#define PortConf_PortPin_PortPin_30 (140U)

#define PortConf_PortPin_PortPin_31 (143U)

#define PortConf_PortPin_PortPin_32 (141U)

#define PortConf_PortPin_PortPin_33 (137U)

#define PortConf_PortPin_PortPin_34 (136U)

#define PortConf_PortPin_PortPin_35 (130U)

#define PortConf_PortPin_PortPin_36 (131U)

#define PortConf_PortPin_PortPin_37 (132U)

#define PortConf_PortPin_PortPin_38 (124U)

#define PortConf_PortPin_PortPin_39 (118U)

#define PortConf_PortPin_PortPin_40 (125U)

#define PortConf_PortPin_PortPin_41 (4U)

#define PortConf_PortPin_PortPin_42 (21U)

#define PortConf_PortPin_PortPin_43 (49U)

#define PortConf_PortPin_PortPin_44 (32U)

#define PortConf_PortPin_PortPin_45 (114U)

#define PortConf_PortPin_PortPin_46 (107U)

#define PortConf_PortPin_PortPin_47 (111U)

#define PortConf_PortPin_PortPin_48 (99U)

#define PortConf_PortPin_PortPin_49 (80U)

#define PortConf_PortPin_PortPin_50 (55U)

#define PortConf_PortPin_PortPin_51 (113U)

#define PortConf_PortPin_PortPin_52 (138U)

#define PortConf_PortPin_PortPin_53 (3U)

#define PortConf_PortPin_PortPin_54 (20U)

#define PortConf_PortPin_PortPin_55 (1U)

#define PortConf_PortPin_PortPin_56 (51U)

#define PortConf_PortPin_PortPin_57 (18U)

#define PortConf_PortPin_PortPin_58 (64U)

#define PortConf_PortPin_PortPin_59 (34U)

#define PortConf_PortPin_PortPin_60 (16U)

#define PortConf_PortPin_PortPin_61 (33U)

#define PortConf_PortPin_PortPin_62 (15U)

#define PortConf_PortPin_PortPin_63 (22U)

#define PortConf_PortPin_PortPin_64 (5U)

#define PortConf_PortPin_PortPin_65 (104U)

#define PortConf_PortPin_PortPin_66 (38U)

#define PortConf_PortPin_PortPin_67 (53U)

#define PortConf_PortPin_PortPin_68 (12U)

#define PortConf_PortPin_PortPin_69 (48U)

#define PortConf_PortPin_PortPin_70 (31U)

#define PortConf_PortPin_PortPin_71 (11U)

#define PortConf_PortPin_PortPin_72 (87U)

#define PortConf_PortPin_PortPin_73 (98U)

#define PortConf_PortPin_PortPin_74 (144U)

#define PortConf_PortPin_PortPin_75 (105U)

#define PortConf_PortPin_PortPin_76 (106U)

#define PortConf_PortPin_PortPin_77 (96U)

#define PortConf_PortPin_PortPin_78 (112U)

#define PortConf_PortPin_PortPin_79 (120U)

#define PortConf_PortPin_PortPin_80 (88U)

#define PortConf_PortPin_PortPin_81 (97U)

#define PortConf_PortPin_PortPin_82 (30U)

#define PortConf_PortPin_PortPin_83 (10U)

#define PortConf_PortPin_PortPin_84 (54U)

#define PortConf_PortPin_PortPin_85 (7U)

#define PortConf_PortPin_PortPin_86 (135U)

#define PortConf_PortPin_PortPin_87 (129U)

#define PortConf_PortPin_PortPin_88 (65U)

#define PortConf_PortPin_PortPin_89 (78U)

#define PortConf_PortPin_PortPin_90 (79U)

#define PortConf_PortPin_PortPin_91 (82U)

#define PortConf_PortPin_PortPin_92 (67U)

#define PortConf_PortPin_PortPin_93 (68U)

#define PortConf_PortPin_PortPin_94 (25U)

#define PortConf_PortPin_PortPin_95 (57U)

#define PortConf_PortPin_PortPin_96 (43U)

#define PortConf_PortPin_PortPin_97 (71U)

#define PortConf_PortPin_PortPin_98 (77U)

#define PortConf_PortPin_PortPin_99 (85U)

#define PortConf_PortPin_PortPin_100 (66U)

#define PortConf_PortPin_PortPin_102 (74U)

#define PortConf_PortPin_PortPin_101 (76U)

#define PortConf_PortPin_PortPin_103 (42U)

#define PortConf_PortPin_PortPin_104 (8U)

#define PortConf_PortPin_PortPin_105 (26U)

#define PortConf_PortPin_PortPin_106 (27U)

#define PortConf_PortPin_PortPin_107 (17U)

#define PortConf_PortPin_PortPin_108 (61U)

#define PortConf_PortPin_PortPin_109 (60U)

#define PortConf_PortPin_PortPin_110 (45U)

#define PortConf_PortPin_PortPin_111 (35U)

#define PortConf_PortPin_PortPin_112 (69U)

#define PortConf_PortPin_PortPin_113 (70U)

#define PortConf_PortPin_PortPin_114 (86U)

#define PortConf_PortPin_PortPin_115 (92U)

#define PortConf_PortPin_PortPin_116 (109U)

#define PortConf_PortPin_PortPin_117 (110U)

#define PortConf_PortPin_PortPin_118 (83U)

#define PortConf_PortPin_PortPin_119 (75U)

#define PortConf_PortPin_PortPin_120 (84U)

#define PortConf_PortPin_PortPin_121 (81U)

#define PortConf_PortPin_PortPin_122 (73U)

#define PortConf_PortPin_PortPin_123 (44U)

#define PortConf_PortPin_PortPin_124 (58U)

#define PortConf_PortPin_PortPin_125 (59U)


/*</PORT_PIN_CHANNEL_LIST>*/

/**
 *  \name Port Driver Maximum number of modes per pin
 *
 *  Maximum number of runtime changeable port pin modes per pin
 *  This value is calculated based on actual configuration and is
 *  not the maximum number of modes supported by SoC (16)
 *  @{
 */
#define PORT_MAX_MUXMODE (1U)
/* @} */

/**
 *  \name Service enable/diable defines
 *
 *  Pre-compile switches for enabling/disabling PORT MCAL APIs
 *  @{
 */
/** \brief Enable/Disable Port_SetPinDirection() */
#define PORT_SET_PIN_DIRECTION_API       (STD_ON) 
/** \brief Enable/Disable Port_RefreshPinDirection() */
/*LDRA_INSPECTED 61 X MR:5.1,MR:5.2 "Custom type definition" */
#define PORT_REFRESH_PORT_DIRECTION_API  (STD_ON) 
/** \brief Enable/Disable Port_GetVersionInfo() */
#define PORT_VERSION_INFO_API            (STD_ON) 
/** \brief Enable/Disable Port_SetPinMode() */
#define PORT_SET_PIN_MODE_API            (STD_ON) 
/** \brief Enable/Disable development error detection */
#define PORT_DEV_ERROR_DETECT            (STD_ON) 
/** \brief Enable/Disable SAFETI Configuration register readback */
#define PORT_SAFETI_API                      (STD_OFF) 
/* @} */

/**********************************************************************************************************************
 *  STATIC TESTS
 *********************************************************************************************************************/


/** \brief Counter ID for counter used to count wait ticks */
#define PORT_OS_COUNTER_ID               ((CounterType)OsCounter_0)

/**
*  \brief PORT timeout.
*   Each tick is 31.25us (for 32K Counter). Wait for 5s which comes to
*   below value
*/
#define PORT_TIMEOUT_DURATION            (32000U)

/* DEM Error Definitions */
/* DEM Error Codes */
/** \brief No event error code */
#define PORT_DEM_NO_EVENT                (0xFFFFFFFFU)


#ifndef PORT_E_HARDWARE_ERROR
/** \brief Hardware failed */
#define PORT_E_HARDWARE_ERROR          (DemConf_DemEventParameter_PORT_E_HARDWARE_ERROR)
#endif

/**
 *  \brief Pin Mode map structure
 *
 *  Structure to map selected mode to corresponding PAD CONFIG MUXMODE value
 */


/**********************************************************************************************************************
 *  GLOBAL DATA TYPES AND STRUCTURES
 *********************************************************************************************************************/
/*LDRA_INSPECTED 33 D: MISRAC_2012_8.6
 * "Reason -  Port configuration structure declaration" */

extern const struct Port_ConfigType_s PortConfigSet_0;


/**********************************************************************************************************************
 *  GLOBAL FUNCTION PROTOTYPES
 *********************************************************************************************************************/

#ifdef __cplusplus
}
#endif

#endif  /* PORT_CFG_H */


/**********************************************************************************************************************
 *  END OF FILE: Port_Cfg.h
 *********************************************************************************************************************/
