/* ======================================================================
 *   Copyright (C) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**

 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Pwm_Cfg.h
 *      Project:  TI Sitara PWM driver configuration
 *       Module:  Pwm
 *    Generator:  EB Tresos
 *
 *  Description:  This component provides services for initialization and control of the microcontroller internal
 *                PWM unit (pulse width modulation). The PWM module generates pulses with variable pulse width.
 *                It allows the selection of the duty cycle and the signal period time.
 *
 
*******************************************************************************************************************/

/**********************************************************************************************************************
    Project: AM263x
	Date   : 2023-05-05 22:44:32

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/
#ifndef PWM_CFG_H
#define PWM_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
/**
 *  \brief PWM Build Variant.
 *   Build variants.(i.e Pre-compile,Post-build or Link time)
 */
#define PWM_PRE_COMPILE_VARIANT         (STD_OFF)

/**
 *  \name Pwm Driver Configuration SW Version Info
 *
 *  Defines for Pwm Driver configuration version
 *  @{
 */
/** \brief Pwm configuration Major Version */
#define PWM_CFG_MAJOR_VERSION           (8U)
/** \brief Pwm configuration Minor Version */
#define PWM_CFG_MINOR_VERSION           (6U)
/** \brief Pwm configuration Patch Version */
#define PWM_CFG_PATCH_VERSION           (2U)
/* @} */



/** \brief PWM Config ID */
#define PWM_CFG_ID                      (0U)

 /** \brief Enable/Disable PWM DeInit API */
#define PWM_DEINIT_API      (STD_ON)

/** \brief Enable/Disable PWM SetDutyCycle API */
#define PWM_SET_DUTY_CYCLE_API      (STD_ON)

/** \brief Enable/Disable PWM SetOutputToIdle API */
#define PWM_SET_OUTPUT_TO_IDLE_API      (STD_ON)

/** \brief Enable/Disable PWM SetPeriodAndDuty API */
#define PWM_SET_PERIOD_AND_DUTY_API     (STD_ON)

/** \brief Enable/Disable PWM VersionInfo API */
#define PWM_VERSION_INFO_API    (STD_ON)

/** \brief Enable/Disable PWM RegisterReadback API */
#define PWM_REGISTER_READBACK_API       (STD_ON)

/** \brief Enable/Disable PWM Dutycycle update always at the end of the period */
#define PWM_DUTYCYCLE_UPDATED_ENDPERIOD     (STD_ON)

/** \brief Enable/Disable PWM Period update always at the end of the period */
#define PWM_PERIOD_UPDATED_ENDPERIOD    (STD_ON)

/** \brief ISR type */
#define PWM_ISR_TYPE    (PWM_ISR_CAT1)

/** \brief Number of configured channels */
#define PWM_MAX_NUM_CHANNELS   (1U)

/** \brief Enable/Disable PWM dev detect error */
#define PWM_DEV_ERROR_DETECT              (STD_ON)

/** \brief Enable/Disable PWM notifications */
#define PWM_NOTIFICATION_SUPPORTED        (STD_ON)

/** \brief Instance ID for driver module. */
#define PWM_INDEX       (0U)
#define PWM_INSTANCE_ID                 (PWM_INDEX)

/**
*  \brief Channel ID
*  Symbolic Names Configured channel ID(s)
*/
#define PwmConf_PwmChannel_PwmChannel_0          (0U)
/**< Channel identifiers */


/** \brief EPWM Channel 1, in MAIN DOMAIN */
#define PWM_CHANNEL_PWM_CONTROLSS_G0_PWMCHANNEL9   (9)
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
/** \brief PWM Configuration structure declaration */
extern const struct Pwm_ConfigType_PC_s PwmChannelConfigSet_PC;
extern const struct Pwm_ConfigType_s PwmChannelConfigSet;



#ifdef __cplusplus
}
#endif

#endif /* PWM_CFG_H */


/**********************************************************************************************************************
 *  END OF FILE: Pwm_Cfg.h
 *********************************************************************************************************************/

