/* ======================================================================
 *   Copyright (C) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**

 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Pwm_PBcfg.c
 *      Project:  TI Sitara MCU AM263x PwmDriver
 *       Module:  DriverPwm
 *    Generator:  EB Tresos
 *
 *  Description:  This component provides services for initialization and control of the microcontroller internal
 *                PWM unit (pulse width modulation). The PWM module generates pulses with variable pulse width.
 *                It allows the selection of the duty cycle and the signal period time.
 *
 *********************************************************************************************************************/


/**********************************************************************************************************************
    Project: AM263x
    Date   : 2023-05-05 22:44:32

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.
 *********************************************************************************************************************/

#include "Std_Types.h"

#include "Pwm.h"
#ifdef __cplusplus

extern "C" {
#endif


/* ---- Perform version checking  ----------------------------------------- */
 #if ((PWM_SW_MAJOR_VERSION != (8U))||(PWM_SW_MINOR_VERSION != (6U)))
  #error "Version numbers of Pwm_PBcfg.c and Pwm_Cfg.h are inconsistent!"
#endif

#if ((PWM_CFG_MAJOR_VERSION != (8U))||(PWM_CFG_MINOR_VERSION != (6U)))
  #error "Version numbers of Pwm_PBcfg.c and Pwm_Cfg.h are inconsistent!"
#endif

/*Requirements : SWS_Pwm_60075*/
#define PWM_START_SEC_CONFIG_DATA
#include "Pwm_MemMap.h"


extern void Pwm_Notification_Channel1 (void);
/* Pwm Channel Configuration parameters */
CONST(struct Pwm_ConfigType_s, PWM_CONFIG_DATA)
     PwmChannelConfigSet =
{
    .chCfg =
    {
        [0] =
        {
            .baseaddr =0x50009000UL,
            .instanceClkHz = 200000000U,
            .dutyCycle =0x4000U,/* Dutycycle */
            .hwPeriod =25000U, /* Number of HW Unit ticks value which sets initial period */
            .polarity = PWM_HIGH,/* Polarity */
            .idleState = PWM_HIGH,/* Idle State */
            .channelClass = PWM_VARIABLE_PERIOD,
            .prescale = 2, /* prescale */
            .hsPrescale = 0, /*High Speed Clock Divider*/
            .enableHR =FALSE, /*Enable High Resolution */
#if (PWM_NOTIFICATION_SUPPORTED == STD_ON)
            .notificationHandler = (Pwm_NotifyFuncType) Pwm_Notification_Channel1, /*Notification Function*/
#endif
        }
    },
};

#ifdef __cplusplus
}
#endif

/*</PWM_CONFIGURATION>*/
#define PWM_STOP_SEC_CONFIG_DATA
#include "Pwm_MemMap.h"

/**********************************************************************************************************************
 *  END OF FILE: Pwm_PBcfg.c                                                                                          *
 *********************************************************************************************************************/
