/*
*
* Copyright (c) 2022 Texas Instruments Incorporated
*
* All rights reserved not granted herein.
*
* Limited License.
*
* Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
* license under copyrights and patents it now or hereafter owns or controls to make,
* have made, use, import, offer to sell and sell ("Utilize") this software subject to the
* terms herein.  With respect to the foregoing patent license, such license is granted
* solely to the extent that any such patent is necessary to Utilize the software alone.
* The patent license shall not apply to any combinations which include this software,
* other than combinations with devices manufactured by or for TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license
* (including the above copyright notice and the disclaimer and (if applicable) source
* code license limitations below) in the documentation and/or other materials provided
* with the distribution
*
* Redistribution and use in binary form, without modification, are permitted provided
* that the following conditions are met:
*
* *       No reverse engineering, decompilation, or disassembly of this software is
* permitted with respect to any software provided in binary form.
*
* *       any redistribution and use are licensed by TI for use only with TI Devices.
*
* *       Nothing shall obligate TI to provide you with source code for the software
* licensed and provided to you in object code.
*
* If software source code is provided to you, modification and redistribution of the
* source code are permitted provided that the following conditions are met:
*
* *       any redistribution and use of the source code, including any resulting derivative
* works, are licensed by TI for use only with TI Devices.
*
* *       any redistribution and use of any object code compiled from the source code
* and any resulting derivative works, are licensed by TI for use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers
*
* may be used to endorse or promote products derived from this software without
* specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

/**
 *  \file     Spi_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file
 *            for SPI MCAL driver
 */

  /*****************************************************************************
    Project: SPI_AM263
    Date   : 2023-05-12 14:12:35
    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.
 ******************************************************************************/

/**
 *  \defgroup MCAL_SPI_CFG SPI Configuration
 *
 *  This files defines SPI MCAL configuration structures
 *  @{
 */

#ifndef SPI_CFG_H_
#define SPI_CFG_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "Os.h"
#include "Dem.h"
#include "Det.h"
#include "Spi_Cbk.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
*  \brief SPI Build Variant.
*   Build variants.(i.e Pre Compile,Post Build or Link time)
*/

#define SPI_PRE_COMPILE_VARIANT       (STD_OFF)

#define SPI_VARIANT_POST_BUILD        (STD_ON)

#define SPI_LINK_TIME_VARIANT         (STD_OFF)

/** \brief SPI Config ID */
#define SPI_CFG_ID          (0x1U)

/**
 *  \brief Pre Compile config macro name.
 */


/** \brief Buffer mode - Internal or External or Both */
#define SPI_CHANNELBUFFERS          (SPI_IB_EB)

/** \brief Internal Buffer length in bytes - applicable only for SPI_IB */
#define SPI_IB_MAX_LENGTH           (64U)

/** \brief Enable/disable SPI dev detect error */
#define SPI_DEV_ERROR_DETECT        (STD_ON)

/** \brief Enable/disable SPI job log */
#define SPI_JOB_LOG                 (STD_ON)

/** \brief Maximum job log entries when logging is ON */
#define SPI_MAX_JOB_LOG             (100U)

/*
 * Scalability levels
 */
/** \brief Basic Synchronous functions */
#define SPI_LEVEL_0                     (0U)
/** \brief Basic Asynchronous functions */
#define SPI_LEVEL_1                     (1U)
/** \brief Synchronous and Asynchronous functions */
#define SPI_LEVEL_2                     (2U)

/** \brief Concurrent sync transmit support - by defualt this is off */
#define SPI_SUPPORT_CONCURRENT_SYNC_TRANSMIT    (STD_OFF)

/** \brief Scalability level */
#define SPI_SCALEABILITY            (SPI_LEVEL_2)

/** \brief Enable/disable SPI get version info API */
#define SPI_VERSION_INFO_API        (STD_ON)

/** \brief Enable/disable SPI HW Status API */
#define SPI_HW_STATUS_API           (STD_ON)

/** \brief Enable/disable SPI cancel API */
#define SPI_CANCEL_API              (STD_ON)

/*
 * All below macros are used for static memory allocation and can be changed to
 * match the usecase requirements.
 */
/** \brief Maximum channels allowed per job */
#define SPI_MAX_CHANNELS_PER_JOB    (4U)

/** \brief Maximum jobs allowed per sequence */
#define SPI_MAX_JOBS_PER_SEQ        (4U)

/** \brief Maximum channels across all jobs/sequence/hwunit */
#define SPI_MAX_CHANNELS            (10U)

/** \brief Maximum jobs across all sequence/hwunit */
#define SPI_MAX_JOBS                (6U)

/** \brief Maximum sequence across all hwunit */
#define SPI_MAX_SEQ                 (3U)

/**
 *  \brief Maximum HW unit - This should match the sum for the below units ISR
 *  which are ON.
 */
#define SPI_MAX_HW_UNIT             (5U)

/**
 *  \brief Maximum external device cfg
 */
#define SPI_MAX_EXT_DEV             (5U)








/*
 All below macros are used for enabling the ISR for a particular hardware.
 */


/** \brief Enable/disable SPI MCSPI0 unit ISR */

#define SPI_UNIT_MCSPI0_ACTIVE      (STD_ON)

/** \brief Enable/disable SPI MCSPI1 unit ISR */

#define SPI_UNIT_MCSPI1_ACTIVE      (STD_ON)

/** \brief Enable/disable SPI MCSPI2 unit ISR */

#define SPI_UNIT_MCSPI2_ACTIVE      (STD_ON)

/** \brief Enable/disable SPI MCSPI3 unit ISR */

#define SPI_UNIT_MCSPI3_ACTIVE      (STD_ON)


/** \brief Enable/disable SPI MCSPI4 unit ISR */

#define SPI_UNIT_MCSPI4_ACTIVE      (STD_ON)







/** \brief ISR type */
#define SPI_ISR_TYPE                (SPI_ISR_CAT1)

/** \brief OS counter ID - used for timeout in case of error */
#define SPI_OS_COUNTER_ID           ((CounterType)OsCounter_0)

/**
 *  \brief SPI timeout - used in McSPI IP reset
 *   Each tick is 31.25us (for 32K Counter). Wait for 100ms which comes to
 *   below value
 */
#define SPI_TIMEOUT_DURATION        (32000U)

/** \brief Enable/disable SPI register read back API */
#define SPI_REGISTER_READBACK_API   (STD_ON)

/** \brief Enable/disable SPI safety API */
#define SPI_SAFETY_API   (STD_ON)

/** \brief Symbolic Name Channel Id  - 0 SpiChannel_0 */
#define SpiConf_SpiChannel_SpiChannel_0   0
/** \brief Symbolic Name Channel Id  - 1 SpiChannel_1 */
#define SpiConf_SpiChannel_SpiChannel_1   1
/** \brief Symbolic Name Channel Id  - 2 SpiChannel_2 */
#define SpiConf_SpiChannel_SpiChannel_2   2
/** \brief Symbolic Name Channel Id  - 3 SpiChannel_3 */
#define SpiConf_SpiChannel_SpiChannel_3   3
/** \brief Symbolic Name Channel Id  - 4 SpiChannel_4 */
#define SpiConf_SpiChannel_SpiChannel_4   4
/** \brief Symbolic Name Channel Id  - 5 SpiChannel_5 */
#define SpiConf_SpiChannel_SpiChannel_5   5
/** \brief Symbolic Name Channel Id  - 6 SpiChannel_6 */
#define SpiConf_SpiChannel_SpiChannel_6   6
/** \brief Symbolic Name Channel Id  - 7 SpiChannel_7 */
#define SpiConf_SpiChannel_SpiChannel_7   7
/** \brief Symbolic Name Channel Id  - 8 SpiChannel_8 */
#define SpiConf_SpiChannel_SpiChannel_8   8
/** \brief Symbolic Name Channel Id  - 9 SpiChannel_9 */
#define SpiConf_SpiChannel_SpiChannel_9   9

/** \brief Symbolic Name Chip Select  - 0 */
#define SpiConf_SpiExternalDevice_CS0 (SPI_CS0)


/** \brief Symbolic Name Job Id - 0 SpiJob_0 */
#define SpiConf_SpiJob_SpiJob_0            0


/** \brief Symbolic Name Chip Select  - 1 */
#define SpiConf_SpiExternalDevice_CS1 (SPI_CS0)


/** \brief Symbolic Name Job Id - 1 SpiJob_1 */
#define SpiConf_SpiJob_SpiJob_1            1


/** \brief Symbolic Name Chip Select  - 2 */
#define SpiConf_SpiExternalDevice_CS2 (SPI_CS0)


/** \brief Symbolic Name Job Id - 2 SpiJob_2 */
#define SpiConf_SpiJob_SpiJob_2            2


/** \brief Symbolic Name Chip Select  - 3 */
#define SpiConf_SpiExternalDevice_CS3 (SPI_CS0)


/** \brief Symbolic Name Job Id - 3 SpiJob_3 */
#define SpiConf_SpiJob_SpiJob_3            3

/** \brief Symbolic Name Sequence Id - 0 SpiSequence_0 */
#define SpiConf_SpiSequence_SpiSequence_0  0
/** \brief Symbolic Name Sequence Id - 1 SpiSequence_1 */
#define SpiConf_SpiSequence_SpiSequence_1  1
/** \brief Symbolic Name Sequence Id - 2 SpiSequence_2 */
#define SpiConf_SpiSequence_SpiSequence_2  2


#define SpiConf_SpiExternalDevice_SpiExternalDevice_0_CS0 SCS0
#define SpiConf_SpiExternalDevice_SpiExternalDevice_1_CS0 SCS0
#define SpiConf_SpiExternalDevice_SpiExternalDevice_2_CS0 SCS0
#define SpiConf_SpiExternalDevice_SpiExternalDevice_3_CS0 SCS0
#define SpiConf_SpiExternalDevice_SpiExternalDevice_4_CS1 SCS1
/** \brief Symbolic Name HW Unit - 0 */
#define SpiConf_SpiExternalDevice_SpiExternalDevice_0_HwUnitId0 CSIB0
/** \brief Symbolic Name HW Unit - 0 */
#define SpiConf_SpiExternalDevice_SpiExternalDevice_1_HwUnitId1 CSIB1
/** \brief Symbolic Name HW Unit - 0 */
#define SpiConf_SpiExternalDevice_SpiExternalDevice_2_HwUnitId2 CSIB2
/** \brief Symbolic Name HW Unit - 0 */
#define SpiConf_SpiExternalDevice_SpiExternalDevice_3_HwUnitId3 CSIB3
/** \brief Symbolic Name HW Unit - 0 */
#define SpiConf_SpiExternalDevice_SpiExternalDevice_4_HwUnitId4 CSIB4


/**
 *  \name SPI DEM Error codes to report
 *
 *  Pre-compile switches for enabling/disabling DEM events
 *  @{
 */
#define DemConf_DemEventParameter_SPI_DEM_NO_EVENT (0xFFFFU)
#define SPI_DEM_NO_EVENT DemConf_DemEventParameter_SPI_DEM_NO_EVENT

#ifndef SPI_E_HARDWARE_ERROR
/** \brief Hardware failed */
#define SPI_E_HARDWARE_ERROR        (DemConf_DemEventParameter_SPI_E_HARDWARE_ERROR)
#endif
/**
 *  \name SPI HW unit Info
 *  @{
 */

/** \brief MCSPI0 instance */
#define SPI_UNIT_MCSPI0                     ((Spi_HWUnitType) CSIB0)
/** \brief MCSPI1 instance */
#define SPI_UNIT_MCSPI1                     ((Spi_HWUnitType) CSIB1)
/** \brief MCSPI2 instance */
#define SPI_UNIT_MCSPI2                     ((Spi_HWUnitType) CSIB2)
/** \brief MCSPI3 instance */
#define SPI_UNIT_MCSPI3                     ((Spi_HWUnitType) CSIB3)
/** \brief MCSPI4 instance */
#define SPI_UNIT_MCSPI4                     ((Spi_HWUnitType) CSIB4)


/**
 *  \brief Total HW units - used for array allocation. This should be +1 of the
 *  max unit number
 */
#define SPI_HW_UNIT_CNT                 (5U)

extern const uint32 Spi_HwUnitBaseAddr[SPI_HW_UNIT_CNT];

/* @} */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */


/** \brief SPI Configuration struct declaration */
extern const struct Spi_ConfigType_s SpiDriver;


/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */
/**
 *  \brief SPI Hwunit ISR
 */

#if (STD_ON == SPI_UNIT_MCSPI0_ACTIVE)

    
        /** \brief SPI MCSPI0 ISR */
        FUNC(void, SPI_CODE_FAST) Spi_IrqUnitMcspi0TxRx(void); 
    
#endif
#if (STD_ON == SPI_UNIT_MCSPI1_ACTIVE)

    
        /** \brief SPI MCSPI1 ISR */
        FUNC(void, SPI_CODE_FAST) Spi_IrqUnitMcspi1TxRx(void); 
    
#endif
#if (STD_ON == SPI_UNIT_MCSPI2_ACTIVE)

    
        /** \brief SPI MCSPI2 ISR */
        FUNC(void, SPI_CODE_FAST) Spi_IrqUnitMcspi2TxRx(void); 
    
#endif
#if (STD_ON == SPI_UNIT_MCSPI3_ACTIVE)

    
        /** \brief SPI MCSPI3 ISR */
        FUNC(void, SPI_CODE_FAST) Spi_IrqUnitMcspi3TxRx(void); 
    
#endif
#if (STD_ON == SPI_UNIT_MCSPI4_ACTIVE)

    
        /** \brief SPI MCSPI4 ISR */
        FUNC(void, SPI_CODE_FAST) Spi_IrqUnitMcspi4TxRx(void); 
    
#endif

#ifdef __cplusplus
}
#endif

#endif  /* #ifndef SPI_CFG_H_ */

/* @} */
