/*
*
* Copyright (c) 2022 Texas Instruments Incorporated
*
* All rights reserved not granted herein.
*
* Limited License.
*
* Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
* license under copyrights and patents it now or hereafter owns or controls to make,
* have made, use, import, offer to sell and sell ("Utilize") this software subject to the
* terms herein.  With respect to the foregoing patent license, such license is granted
* solely to the extent that any such patent is necessary to Utilize the software alone.
* The patent license shall not apply to any combinations which include this software,
* other than combinations with devices manufactured by or for TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license
* (including the above copyright notice and the disclaimer and (if applicable) source
* code license limitations below) in the documentation and/or other materials provided
* with the distribution
*
* Redistribution and use in binary form, without modification, are permitted provided
* that the following conditions are met:
*
* *       No reverse engineering, decompilation, or disassembly of this software is
* permitted with respect to any software provided in binary form.
*
* *       any redistribution and use are licensed by TI for use only with TI Devices.
*
* *       Nothing shall obligate TI to provide you with source code for the software
* licensed and provided to you in object code.
*
* If software source code is provided to you, modification and redistribution of the
* source code are permitted provided that the following conditions are met:
*
* *       any redistribution and use of the source code, including any resulting derivative
* works, are licensed by TI for use only with TI Devices.
*
* *       any redistribution and use of any object code compiled from the source code
* and any resulting derivative works, are licensed by TI for use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers
*
* may be used to endorse or promote products derived from this software without
* specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

/**
 *  \file     Spi_PBcfg.c
 *
 *  \brief    This file contains generated post build configuration file
 *            for SPI MCAL driver
 */

  /*****************************************************************************
    Project: SPI_AM263
    Date   : 2023-05-12 14:12:35
    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way
 ******************************************************************************/
/*******************************************************************************
 *  INCLUDES
 ******************************************************************************/
#include "Spi.h"
#include "Spi_Irq.h"


/*******************************************************************************
 *  VERSION CHECK
 ******************************************************************************/
#if ((SPI_SW_MAJOR_VERSION != (8U)) || (SPI_SW_MINOR_VERSION != (6U)))
  #error "Version numbers of Spi_PBcfg.c and Spi.h are inconsistent!"
#endif
/*******************************************************************************
 *  LOCAL CONSTANT MACROS
 ******************************************************************************/

/*******************************************************************************
 *  LOCAL FUNCTION MACROS
 ******************************************************************************/

/*******************************************************************************
 *  LOCAL DATA TYPES AND STRUCTURES
 ******************************************************************************/

/*******************************************************************************
 *  LOCAL DATA PROTOTYPES
 ******************************************************************************/

/*******************************************************************************
 *  GLOBAL DATA
 ******************************************************************************/
#define  SPI_START_SEC_CONFIG_DATA
#include "Spi_MemMap.h"
/* generation of runtime configuration       */

#ifdef __cplusplus
extern "C" {
#endif



extern void SpiApp_McspiJob0EndNotification(void);
extern void SpiApp_McspiJob1EndNotification(void);
extern void SpiApp_McspiJob2EndNotification(void);
extern void SpiApp_McspiJob3EndNotification(void);

extern void SpiApp_McspiSeq0EndNotification(void);
extern void SpiApp_McspiSeq1EndNotification(void);
extern void SpiApp_McspiSeq2EndNotification(void);

CONST(struct Spi_ConfigType_s, SPI_CONFIG_DATA) SpiDriver =
{
    .maxChannels = 10U,
    .maxJobs = 4U,
    .maxSeq  = 3U,
    .maxHwUnit = 5U,
    .maxExtDevCfg = 5U,
    .channelCfg =
    {
            [0] =
            {
                .channelBufType = SPI_EB,
                .dataWidth = 4U,
                .defaultTxData = 0U,
                .maxBufLength = 100U,
                .transferType = SPI_MSB,
            },
            [1] =
            {
                .channelBufType = SPI_EB,
                .dataWidth = 5U,
                .defaultTxData = 0U,
                .maxBufLength = 100U,
                .transferType = SPI_MSB,
            },
            [2] =
            {
                .channelBufType = SPI_EB,
                .dataWidth = 7U,
                .defaultTxData = 0U,
                .maxBufLength = 100U,
                .transferType = SPI_MSB,
            },
            [3] =
            {
                .channelBufType = SPI_EB,
                .dataWidth = 8U,
                .defaultTxData = 0U,
                .maxBufLength = 100U,
                .transferType = SPI_MSB,
            },
            [4] =
            {
                .channelBufType = SPI_EB,
                .dataWidth = 9U,
                .defaultTxData = 0U,
                .maxBufLength = 100U,
                .transferType = SPI_MSB,
            },
            [5] =
            {
                .channelBufType = SPI_EB,
                .dataWidth = 13U,
                .defaultTxData = 0U,
                .maxBufLength = 100U,
                .transferType = SPI_MSB,
            },
            [6] =
            {
                .channelBufType = SPI_EB,
                .dataWidth = 16U,
                .defaultTxData = 0U,
                .maxBufLength = 100U,
                .transferType = SPI_MSB,
            },
            [7] =
            {
                .channelBufType = SPI_EB,
                .dataWidth = 17U,
                .defaultTxData = 0U,
                .maxBufLength = 100U,
                .transferType = SPI_MSB,
            },
            [8] =
            {
                .channelBufType = SPI_EB,
                .dataWidth = 31U,
                .defaultTxData = 0U,
                .maxBufLength = 100U,
                .transferType = SPI_MSB,
            },
            [9] =
            {
                .channelBufType = SPI_EB,
                .dataWidth = 32U,
                .defaultTxData = 0U,
                .maxBufLength = 100U,
                .transferType = SPI_MSB,
            },
        },
    .jobCfg =
    {
            [0] =
            {
                .jobPriority = SPI_JOB_PRIORITY_0,
                .hwUnitId = SPI_UNIT_MCSPI0,
                .Spi_JobEndNotification = SpiApp_McspiJob0EndNotification,
                .channelPerJob = 2U,
                .channelList =
                {
                    [0] = 0U,
                    [1] = 1U,
                },
            },
            [1] =
            {
                .jobPriority = SPI_JOB_PRIORITY_1,
                .hwUnitId = SPI_UNIT_MCSPI0,
                .Spi_JobEndNotification = SpiApp_McspiJob1EndNotification,
                .channelPerJob = 2U,
                .channelList =
                {
                    [0] = 2U,
                    [1] = 3U,
                },
            },
            [2] =
            {
                .jobPriority = SPI_JOB_PRIORITY_2,
                .hwUnitId = SPI_UNIT_MCSPI0,
                .Spi_JobEndNotification = SpiApp_McspiJob2EndNotification,
                .channelPerJob = 2U,
                .channelList =
                {
                    [0] = 4U,
                    [1] = 5U,
                },
            },
            [3] =
            {
                .jobPriority = SPI_JOB_PRIORITY_3,
                .hwUnitId = SPI_UNIT_MCSPI0,
                .Spi_JobEndNotification = SpiApp_McspiJob3EndNotification,
                .channelPerJob = 4U,
                .channelList =
                {
                    [0] = 6U,
                    [1] = 7U,
                    [2] = 8U,
                    [3] = 9U,
                },
            },
        },
    .seqCfg =
    {
            [0] =
            {
                .seqInterruptible = (uint8) TRUE,
                .Spi_SequenceEndNotification = SpiApp_McspiSeq0EndNotification,
                .jobPerSeq = 1U,
                .jobList =
                {
                    0U,
                },
            },
            [1] =
            {
                .seqInterruptible = (uint8) TRUE,
                .Spi_SequenceEndNotification = SpiApp_McspiSeq1EndNotification,
                .jobPerSeq = 2U,
                .jobList =
                {
                    1U,
                    2U,
                },
            },
            [2] =
            {
                .seqInterruptible = (uint8) TRUE,
                .Spi_SequenceEndNotification = SpiApp_McspiSeq2EndNotification,
                .jobPerSeq = 1U,
                .jobList =
                {
                    3U,
                },
            },
        },
    .hwUnitCfg =
    {
            [0] =
            {
                .hwUnitId = SPI_UNIT_MCSPI0,
            },
            [1] =
            {
                .hwUnitId = SPI_UNIT_MCSPI1,
            },
            [2] =
            {
                .hwUnitId = SPI_UNIT_MCSPI2,
            },
            [3] =
            {
                .hwUnitId = SPI_UNIT_MCSPI3,
            },
            [4] =
            {
                .hwUnitId = SPI_UNIT_MCSPI4,
            },
        },
    .extDevCfg =
    {
            [0] =
            {
        .mcspi =
                {
                    .csEnable = (uint16) TRUE,
                    .csMode   = SPI_CONTINUOUS,
                    .csPolarity = SPI_HIGH,
                    .csIdleTime = SPI_DATADELAY_0,
                    .clkDivider = 0U,
                    .clkMode = SPI_CLK_MODE_0,
                    .txRxMode     = SPI_TX_RX_MODE_BOTH,
                    .startBitEnable =  (uint16) FALSE,
                    .startBitLevel  = SPI_LOW,
                    .receptionLineEnable  = DATA_LINE_1_RECEPTION,
                    .transmissionLineEnable  = DATA_LINE_1_TRANSMISSION,
                },
            },
            [1] =
            {
        .mcspi =
                {
                    .csEnable = (uint16) TRUE,
                    .csMode   = SPI_CONTINUOUS,
                    .csPolarity = SPI_HIGH,
                    .csIdleTime = SPI_DATADELAY_0,
                    .clkDivider = 0U,
                    .clkMode = SPI_CLK_MODE_0,
                    .txRxMode     = SPI_TX_RX_MODE_BOTH,
                    .startBitEnable =  (uint16) FALSE,
                    .startBitLevel  = SPI_LOW,
                    .receptionLineEnable  = DATA_LINE_1_RECEPTION,
                    .transmissionLineEnable  = DATA_LINE_1_TRANSMISSION,
                },
            },
            [2] =
            {
        .mcspi =
                {
                    .csEnable = (uint16) TRUE,
                    .csMode   = SPI_CONTINUOUS,
                    .csPolarity = SPI_LOW,
                    .csIdleTime = SPI_DATADELAY_0,
                    .clkDivider = 0U,
                    .clkMode = SPI_CLK_MODE_0,
                    .txRxMode     = SPI_TX_RX_MODE_BOTH,
                    .startBitEnable =  (uint16) FALSE,
                    .startBitLevel  = SPI_LOW,
                    .receptionLineEnable  = DATA_LINE_1_RECEPTION,
                    .transmissionLineEnable  = DATA_LINE_1_TRANSMISSION,
                },
            },
            [3] =
            {
        .mcspi =
                {
                    .csEnable = (uint16) TRUE,
                    .csMode   = SPI_CONTINUOUS,
                    .csPolarity = SPI_HIGH,
                    .csIdleTime = SPI_DATADELAY_0,
                    .clkDivider = 0U,
                    .clkMode = SPI_CLK_MODE_0,
                    .txRxMode     = SPI_TX_RX_MODE_BOTH,
                    .startBitEnable =  (uint16) FALSE,
                    .startBitLevel  = SPI_LOW,
                    .receptionLineEnable  = DATA_LINE_1_RECEPTION,
                    .transmissionLineEnable  = DATA_LINE_1_TRANSMISSION,
                },
            },
            [4] =
            {
        .mcspi =
                {
                    .csEnable = (uint16) TRUE,
                    .csMode   = SPI_CONTINUOUS,
                    .csPolarity = SPI_HIGH,
                    .csIdleTime = SPI_DATADELAY_0,
                    .clkDivider = 0U,
                    .clkMode = SPI_CLK_MODE_0,
                    .txRxMode     = SPI_TX_RX_MODE_BOTH,
                    .startBitEnable =  (uint16) FALSE,
                    .startBitLevel  = SPI_LOW,
                    .receptionLineEnable  = DATA_LINE_1_RECEPTION,
                    .transmissionLineEnable  = DATA_LINE_1_TRANSMISSION,
                },
            },
        },
};



CONST(Spi_ChannelConfigType_PC, SPI_CONFIG_DATA) Spi_ChannelConfig_PC[] =
{
    [0] =
        {
            .channelId = SpiConf_SpiChannel_SpiChannel_0,
        },
    [1] =
        {
            .channelId = SpiConf_SpiChannel_SpiChannel_1,
        },
    [2] =
        {
            .channelId = SpiConf_SpiChannel_SpiChannel_2,
        },
    [3] =
        {
            .channelId = SpiConf_SpiChannel_SpiChannel_3,
        },
    [4] =
        {
            .channelId = SpiConf_SpiChannel_SpiChannel_4,
        },
    [5] =
        {
            .channelId = SpiConf_SpiChannel_SpiChannel_5,
        },
    [6] =
        {
            .channelId = SpiConf_SpiChannel_SpiChannel_6,
        },
    [7] =
        {
            .channelId = SpiConf_SpiChannel_SpiChannel_7,
        },
    [8] =
        {
            .channelId = SpiConf_SpiChannel_SpiChannel_8,
        },
    [9] =
        {
            .channelId = SpiConf_SpiChannel_SpiChannel_9,
        },
};

CONST(Spi_JobConfigType_PC, SPI_CONFIG_DATA) Spi_JobConfig_PC[] =
{
    [0] =
        {
            .jobId = SpiConf_SpiJob_SpiJob_0,
            .csPin = SpiConf_SpiExternalDevice_CS0,
            .externalDeviceCfgId = (uint8)0,
        },
    [1] =
        {
            .jobId = SpiConf_SpiJob_SpiJob_1,
            .csPin = SpiConf_SpiExternalDevice_CS1,
            .externalDeviceCfgId = (uint8)1,
        },
    [2] =
        {
            .jobId = SpiConf_SpiJob_SpiJob_2,
            .csPin = SpiConf_SpiExternalDevice_CS2,
            .externalDeviceCfgId = (uint8)1,
        },
    [3] =
        {
            .jobId = SpiConf_SpiJob_SpiJob_3,
            .csPin = SpiConf_SpiExternalDevice_CS3,
            .externalDeviceCfgId = (uint8)0,
        },
};

CONST(Spi_SeqConfigType_PC, SPI_CONFIG_DATA) Spi_SeqConfig_PC[] =
{
    [0] =
        {
            .seqId = SpiConf_SpiSequence_SpiSequence_0,
        },
    [1] =
        {
            .seqId = SpiConf_SpiSequence_SpiSequence_1,
        },
    [2] =
        {
            .seqId = SpiConf_SpiSequence_SpiSequence_2,
        },
};



/**
 *  \brief This type defines a range of HW SPI Hardware microcontroller
 *         peripheral allocated to this Job
 */
const uint32 Spi_HwUnitBaseAddr[SPI_HW_UNIT_CNT] =
{
 
 
   0x52200000 ,      	            /* MCSPI0 */
   0x52201000 ,      	    /* MCSPI1 */
   0x52202000 ,      	    /* MCSPI2 */
   0x52203000 ,      	    /* MCSPI3 */
   0x52204000      	    /* MCSPI4 */
};

#ifdef __cplusplus
}
#endif

#define  SPI_STOP_SEC_CONFIG_DATA
#include "Spi_MemMap.h"

#define  SPI_START_SEC_ISR_CODE
#include "Spi_MemMap.h"
/**
 *  \brief SPI Hwunit ISR
 */

#if defined CLANG
__attribute__((target("arm")))
#endif
/** \brief SPI MCSPI0 ISR */
FUNC(void, SPI_CODE_FAST) Spi_IrqUnitMcspi0TxRx(void)
{
    Spi_IntISR_McspiTxRx(SPI_UNIT_MCSPI0);
}
#if defined CLANG
__attribute__((target("arm")))
#endif
/** \brief SPI MCSPI1 ISR */
FUNC(void, SPI_CODE_FAST) Spi_IrqUnitMcspi1TxRx(void)
{
    Spi_IntISR_McspiTxRx(SPI_UNIT_MCSPI1);
}
#if defined CLANG
__attribute__((target("arm")))
#endif
/** \brief SPI MCSPI2 ISR */
FUNC(void, SPI_CODE_FAST) Spi_IrqUnitMcspi2TxRx(void)
{
    Spi_IntISR_McspiTxRx(SPI_UNIT_MCSPI2);
}
#if defined CLANG
__attribute__((target("arm")))
#endif
/** \brief SPI MCSPI3 ISR */
FUNC(void, SPI_CODE_FAST) Spi_IrqUnitMcspi3TxRx(void)
{
    Spi_IntISR_McspiTxRx(SPI_UNIT_MCSPI3);
}
#if defined CLANG
__attribute__((target("arm")))
#endif
/** \brief SPI MCSPI4 ISR */
FUNC(void, SPI_CODE_FAST) Spi_IrqUnitMcspi4TxRx(void)
{
    Spi_IntISR_McspiTxRx(SPI_UNIT_MCSPI4);
}

#define  SPI_STOP_SEC_ISR_CODE
#include "Spi_MemMap.h"
/*******************************************************************************
 *  END OF FILE: Spi_PBcfg.c
 ******************************************************************************/
