/* ======================================================================
 *   Copyright (C) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Cdd_Uart_Cfg.h
 *
 *  \brief    This file contains generated configuration file for 
 *            UART Complex Device Driver
 */

  /*********************************************************************************************************************
    Project: UART_CDD_AM263
    Date   : 2023-05-12 19:22:46

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/

/**
 *  \defgroup CDD_UART_CFG  Configuration
 *
 *  This files defines CDD UART configuration structures
 *  @{
 */

#ifndef CDD_UART_CFG_H_
#define CDD_UART_CFG_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "Std_Types.h"
#include "Os.h"
#include "Dem.h"
#include "Det.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 *  \name CDD UART Driver Configuration SW Version Info
 *
 *  Defines for CDD UART Driver configuration version
 *  @{
 */
/** \brief CDD UART configuration Major Version */
#define CDD_UART_MAJOR_VERSION                     (8U)
/** \brief CDD UART configuration Minor Version */
#define CDD_UART_MINOR_VERSION                     (6U)
/** \brief CDD UART configuration Patch Version */
#define CDD_UART_CFG_PATCH_VERSION                 (2U)
/* @} */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/** \brief CDD UART Config ID */
#define CDD_UART_CFG_ID                            (0x1U)

/** \brief Enable/disable CDD UART dev detect error */
/* Requirements: ___ */
#define CDD_UART_DEV_ERROR_DETECT                  STD_ON

#define CDD_UART_DMA_ENABLE                        STD_ON

#define CDD_UART_ISR_TYPE                          CDD_UART_ISR_VOID

/** \brief CDD UART Channel Hardware IDs */
#define CDD_UART_CHANNEL_ID_0                      (0)
#define CDD_UART_CHANNEL_ID_1                      (1)
#define CDD_UART_CHANNEL_ID_2                      (2)
#define CDD_UART_CHANNEL_ID_3                      (3)
#define CDD_UART_CHANNEL_ID_4                      (4)
#define CDD_UART_CHANNEL_ID_5                      (5)

/**
 *  \name CDD UART transaction modes
 */
/** \brief Polling mode */
#define CDD_UART_MODE_POLLING                      (0U)
/** \brief Interrupt mode */
#define CDD_UART_MODE_INTERRUPT                    (1U)
/** \brief DMA mode */
#define CDD_UART_MODE_DMA                          (3U)

/**
 *  \name CDD UART word length
 */
/** \brief Word Length 5 */
#define CDD_UART_WORD_LENGTH_5                     (0U)
/** \brief Word Length 6 */
#define CDD_UART_WORD_LENGTH_6                     (1U)
/** \brief Word Length 7 */
#define CDD_UART_WORD_LENGTH_7                     (2U)
/** \brief Word Length 8 */
#define CDD_UART_WORD_LENGTH_8                     (3U)

/**
 *  \name CDD UART parity types
 */
/** \brief None Parity */
#define CDD_UART_PARITY_NONE                       (0U)
/** \brief Odd Parity */
#define CDD_UART_PARITY_ODD                        (1U)
/** \brief Even Parity */
#define CDD_UART_PARITY_EVEN                       (2U)

/**
 *  \name CDD UART Transmit/Receive trigger levels
 */
/** \brief Trigger Level 1 */
#define CDD_UART_TRIGGER_LEVEL_1                   (1U)
/** \brief Trigger Level 8 */
#define CDD_UART_TRIGGER_LEVEL_8                   (8U)
/** \brief Trigger Level 16 */
#define CDD_UART_TRIGGER_LEVEL_16                  (16U)
/** \brief Trigger Level 32 */
#define CDD_UART_TRIGGER_LEVEL_32                  (32U)
/** \brief Trigger Level 56 */
#define CDD_UART_TRIGGER_LEVEL_56                  (56U)
/** \brief Trigger Level 60 */
#define CDD_UART_TRIGGER_LEVEL_60                  (60U)

/**
 *  \name CDD UART operational modes
 */
/** \brief UART13X mode */
#define CDD_UART_13x_OPER                          (3U)
/** \brief UART16X mode */
#define CDD_UART_16x_OPER                          (0U)
/** \brief UART16X AUTO mode */
#define CDD_UART_16x_AUTO_OPER                     (2U)

/**
 *  \name CDD UART read return modes
 */
/** \brief Full read return mode */
#define CDD_UART_FULL_READ_RETURN                  (0U)
/** \brief Partial read return mode */
#define CDD_UART_PARTIAL_READ_RETURN               (1U)

/**
 *  \name CDD UART stop bits
 */
/** \brief Stop Bit 1 */
#define CDD_UART_STOP_BIT_1                        (0U)
/** \brief Stop Bit 2 */
#define CDD_UART_STOP_BITS_2                       (1U)

/**
 *  \name Pre-Compile Switches for API Services
 */
/** \brief Enable/disable CDD UART get version info API */
#define CDD_UART_VERSION_INFO_API                  STD_ON
/** \brief Enable/disable CDD UART DeInit API */
#define CDD_UART_DEINIT_API                        STD_ON
/** \brief Enable/disable CDD UART Write API */
#define CDD_UART_WRITE_API                         STD_ON
/** \brief Enable/disable CDD UART Read API */
#define CDD_UART_READ_API                          STD_ON
/** \brief Enable/disable CDD UART Cancel API */
#define CDD_UART_CANCEL_API                        STD_ON
/** \brief Enable/disable CDD UART GetRemainingWords API */
#define CDD_UART_GETREMAININGWORDS_API             STD_ON

/** \brief total number of UART channels allocated */
#define CDD_UART_NUM_CHANNELS                      1

/** \brief Counter ID for counter used to count wait ticks */
#define CDD_UART_OS_COUNTER_ID                     ((CounterType)0U)

/** \brief Symbolic Names for UART channels */
#define CddUartConf_CddUartChannelConfiguration_CddUartChannel_0 (0U)

#define CDD_UART_PRE_COMPILE_VARIANT               STD_ON
#define CDD_UART_INIT_CONFIG_PC                    CddUartDriver_0

/** \brief Typedef for the data buffer elements*/
typedef uint8 CddUartDataBufferType;

/** \brief Type for defining the direction of data transfer, i.e., sending or receival */
typedef uint8_least CddUartDataDirectionType;

/* UART maximum channels check to ensure it is within bounds */
#if (CDD_UART_NUM_CHANNELS < 1 || CDD_UART_NUM_CHANNELS > 6)
    #error "CDD UART: Unsupported maximum channels in use"
#endif

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/**
 *  \brief This type defines a range of specific status for UART Complex Driver
 */
/** Requirements: SitaraMCU_MCAL-__ */
/** Design: SitaraMCU_MCAL-__ */
typedef enum
{
    /**< The UART Complex Driver is not initialized or not usable */
    CDD_UART_UNINIT =       0U,
    /**< The UART Complex Driver is not currently transferring */
    CDD_UART_INIT =         1U,
    /**< The UART Complex Driver is performing a read/write operation */
    CDD_UART_BUSY =         2U,
} CddUart_StatusType;

/**
 *  \name CDD UART Notification Callbacks
 *
 * \brief UART notification callbacks structure
 *
 * Requirements: SitaraMCU_MCAL-__, SitaraMCU_MCAL-__
 * Design: SitaraMCU_MCAL-__, SitaraMCU_MCAL-__
 */
typedef struct
{
    /**< UART Read Notification Handler */
    void (*uartNotificationReadHandler)();
    /**< UART Write Notification Handler */
    void (*uartNotificationWriteHandler)();
    /**< UART Error Notification Handler */
    void (*uartNotificationErrorHandler)();
} CddUart_NotifCallbacks;

/**
 *  \name CDD UART Config type
 *
 * \brief UART configuration type data structure for a channel
 *
 * Requirements: SitaraMCU_MCAL-__, SitaraMCU_MCAL-__
 * Design: SitaraMCU_MCAL-__, SitaraMCU_MCAL-__
 */
typedef struct
{
    /**< CoreID on which the UART is instantiated */
    uint32 uartHwUnitID;
    /**< Clock Frequency */
    uint32 uartClockFrequency;
    /**< Baud Rate for signal transfer */
    uint32 uartBaudRate;
    /**< IO Mode for signal transfer */
    uint32 uartIOMode;
    /**< Trigger level for Transmission of signal */
    uint32 uartTXTriggerLevel;
    /**< Trigger level for Receival of signal */
    uint32 uartRXTriggerLevel;
    /**< Trigger threshold for signal flow control */
    uint32 uartHwFlowControlThreshold;
    /**< Word Length for packets */
    uint32 uartWordLength;
    /**< Parity for data */
    uint32 uartParity;
    /**< Read return mode */
    uint32 uartReadReturnMode;
    /**< Mode of Operation */
    uint32 uartOperatingMode;
    /**< Amount of stop bits per packet */
    uint32 uartStopBits;
    /**< UART EDMA Receival channel ID */
    uint8 edmaXbarRxChannelID;
    /**< UART EDMA Transmittal channel ID */
    uint8 edmaXbarTxChannelID;
    /**< Callback Handles */
    CddUart_NotifCallbacks uartNotificationHandlers;
} CddUart_ConfigType;

/**
 *  \name CDD UART Configurations type
 *
 *  \brief UART configuration type structure for all channels in use
 *
 * Requirements: SitaraMCU_MCAL-__, SitaraMCU_MCAL-__
 * Design: SitaraMCU_MCAL-__, SitaraMCU_MCAL-__
 */
typedef struct
{
    /* Count of channels configured */
    uint8 netChannels;
    /* Channel Configurations */
    CddUart_ConfigType channelCfg[CDD_UART_NUM_CHANNELS];
} CddUart_CfgType;

/** \brief CDD Uart Configuration struct declaration */
extern CONST(CddUart_CfgType, CDD_UART_CFG)CddUartDriver_0;

/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */

/** Requirements: SitaraMCU_MCAL-__ */
/** Design: SitaraMCU_MCAL-__ */


#ifdef __cplusplus
}
#endif

#endif  /* #ifndef CDD_UART_CFG_H_ */

/* @} */
