/* ======================================================================
 *   Copyright (C) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Cdd_Uart_Cfg.c
 *
 *  \brief    This file contains generated pre-compile configuration file
 *            for UART Complex Device Driver
 */

  /*********************************************************************************************************************
  Project: UART_CDD_AM263
	Date   : 2023-05-12 19:22:46

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/


#define CDD_UART_CFG_SOURCE 1U

/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/
#include "Cdd_Uart_Cfg.h"
#include "Cdd_Uart_Irq.h"
#include "soc.h"

/**********************************************************************************************************************
 *  VERSION CHECK
 *********************************************************************************************************************/
#if ( (CDD_UART_MAJOR_VERSION != (8U)) \
    ||(CDD_UART_MINOR_VERSION != (6U)))
  #error "Version numbers of Cdd_Uart_Cfg.c and Cdd_Uart_Cfg.h are inconsistent!"
#endif

/**********************************************************************************************************************
 *  LOCAL CONSTANT MACROS
 **********************************************************************************************************************/

/**********************************************************************************************************************
 *  LOCAL FUNCTION MACROS
 **********************************************************************************************************************/

/**********************************************************************************************************************
 *  LOCAL DATA TYPES AND STRUCTURES
 **********************************************************************************************************************/

/**********************************************************************************************************************
 *  LOCAL DATA PROTOTYPES
 **********************************************************************************************************************/

/**********************************************************************************************************************
 *  GLOBAL DATA
 **********************************************************************************************************************/

#define  CDD_UART_START_SEC_CONFIG_DATA
#include "Cdd_Uart_MemMap.h"

/* Callback Notify Functions */
/** \brief Prototype for the read notification callback function */
extern void CddUart_CallbackReadNotify(void);
/** \brief Prototype for the write notification callback function */
extern void CddUart_CallbackWriteNotify(void);
/** \brief Prototype for the error notification callback function */
extern void CddUart_CallbackErrorNotify(void);

/* Generation of runtime configuration */
/* Requirements: SitaraMCU_MCAL-__, SitaraMCU_MCAL-__ */
CONST(CddUart_CfgType, CDD_UART_CFG) CddUartDriver_0 =
{
  .netChannels = 1,
  .channelCfg = {
    [0] =
    {
      .uartHwUnitID = CDD_UART_CHANNEL_ID_0,
      .uartClockFrequency = 48000000U,
      .uartBaudRate = 115200,
      .uartIOMode = CDD_UART_MODE_DMA,
      .uartTXTriggerLevel = CDD_UART_TRIGGER_LEVEL_1,
      .uartRXTriggerLevel = CDD_UART_TRIGGER_LEVEL_1,
      .uartHwFlowControlThreshold = CDD_UART_TRIGGER_LEVEL_1,
      .uartWordLength = CDD_UART_WORD_LENGTH_8,
      .uartParity = CDD_UART_PARITY_NONE,
      .uartReadReturnMode = CDD_UART_FULL_READ_RETURN,
      .uartOperatingMode = CDD_UART_16x_OPER,
      .uartStopBits = CDD_UART_STOP_BIT_1,
      .edmaXbarRxChannelID = 0,
      .edmaXbarTxChannelID = 1,
      .uartNotificationHandlers.uartNotificationReadHandler = CddUart_CallbackReadNotify,
      .uartNotificationHandlers.uartNotificationWriteHandler = CddUart_CallbackWriteNotify,
      .uartNotificationHandlers.uartNotificationErrorHandler = CddUart_CallbackErrorNotify,
    },
  }
};

#define  CDD_UART_STOP_SEC_CONFIG_DATA
#include "Cdd_Uart_MemMap.h"

#define  CDD_UART_START_SEC_ISR_CODE
#include "Cdd_Uart_MemMap.h"



#define  CDD_UART_STOP_SEC_ISR_CODE
#include "Cdd_Uart_MemMap.h"



/**********************************************************************************************************************
 *  END OF FILE: Cdd_Uart_Cfg.c
 *********************************************************************************************************************/
