/* ======================================================================
 *   Copyright (c) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Wdg_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file
 *            for WDG MCAL driver
 *
 */

/**
 *  \defgroup MCAL_WDG_CFG WDG Configuration
 *
 *  This files defines WDG MCAL configuration structures
 *  @{
 */

/*******************************************************************************
    Project: AM263x
	Date   : 2023-05-05 22:44:32

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

*******************************************************************************/
/* Requirements : SWS_Wdg_00157, SWS_Wdg_00158, SWS_Wdg_00159 */
/* Protection against multiple inclusion */
#ifndef WDG_CFG_H
#define WDG_CFG_H

/*******************************************************************************
 * Standard Header Files
 ******************************************************************************/

/*******************************************************************************
 * Other Header Files
 ******************************************************************************/
 /*LDRA_NOANALYSIS*/
#include "Wdg.h"
#include "Dem.h"
/*LDRA_ANALYSIS*/
#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
 * Version Check
 *******************************************************************************/
/**
 *  \name Wdg Driver Configuration SW Version Info
 *
 *  Defines for Wdg Driver configuration version
 *  @{
 */
/** \brief Wdg configuration Major Version */
#define WDG_CFG_MAJOR_VERSION           (8U)
/** \brief Wdg configuration Minor Version */
#define WDG_CFG_MINOR_VERSION           (6U)
/** \brief Wdg configuration Patch Version */
#define WDG_CFG_PATCH_VERSION           (2U)
/* @} */

#define WDG_VARIANT_PRE_COMPILE       (STD_OFF)

#define WDG_VARIANT_POST_BUILD        (STD_ON)

#define WDG_VARIANT_LINK_TIME         (STD_OFF)


/** \brief WDG configuration index*/ 
#define WDG_CFG_ID          (0x1U)

/*******************************************************************************
 * Exported Preprocessor #define Constants
 ******************************************************************************/
/** \brief Enable/Disable Development Error Detection */
#define WDG_DEV_ERROR_DETECT       (STD_ON)

/** \brief Enable/Disable Version Info API */
#define WDG_GET_VERSION_INFO_API   (STD_ON)

/** \brief Enable/Disable Register Readback API */
#define WDG_REGISTER_READBACK_API  (STD_ON)

/** \brief Watchdog Initial Timeout */
#define WDG_INITIAL_TIMEOUT        (1 * 1000)

/** \brief Watchdog Maximum Timeout */
#define WDG_MAX_TIMEOUT            (65 * 1000)


/** \brief Watchdog Maximum preload value */
#define WDG_MAX_PRELOAD_VALUE       (0xFFFU)

/** \brief RTI Clock Frequency */
#define WDG_RTI_FREQUENCY          ((uint32)200)

/** \brief Interrupt Type */
#define WDG_ISR_TYPE           (WDG_ISR_CAT1)

/** \brief Watchdog Disable Allowed*/
#define WDG_DISABLE_ALLOWED        (STD_OFF)

/** \brief DEM Error Definitions */
/** \brief DEM Error Codes */
#define DemConf_DemEventParameter_WDG_DEM_NO_EVENT ((Dem_EventIdType)0xFFFFU)
#define WDG_DEM_NO_EVENT DemConf_DemEventParameter_WDG_DEM_NO_EVENT

/** \brief  WDG failed */
#ifndef WDG_E_MODE_FAILED
#define WDG_E_MODE_FAILED           (DemConf_DemEventParameter_WDG_E_MODE_FAILED)
#endif

/** \brief  WDG disable rejected */
#ifndef WDG_E_DISABLE_REJECTED
#define WDG_E_DISABLE_REJECTED     (DemConf_DemEventParameter_WDG_E_DISABLE_REJECTED)
#endif

/*******************************************************************************
 * Exported Preprocessor #define Macros
 ******************************************************************************/

/** \brief WDG Configuration struct declaration */
extern const struct Wdg_ConfigType_s WdgSettingsConfig; 

#ifdef __cplusplus
}
#endif

#endif  /* WDG_CFG_H */
/*******************************************************************************
 *  End of File: Wdg_Cfg.h
 ******************************************************************************/
