
/* ======================================================================
 *   Copyright (c) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Wdg_PBcfg.c
 *
 *  \brief    This file contains generated post build configuration file
 *            for WDG MCAL driver
 *
 */

/*******************************************************************************
    Project: AM263x
	Date   : 2023-05-05 22:44:32 
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
*******************************************************************************/

/* Module switch */
#define WDG_PBCFG_SOURCE

/*******************************************************************************
 * Standard Header Files
 ******************************************************************************/

/*******************************************************************************
 * Other Header Files
 ******************************************************************************/
#include "Wdg.h"

/*******************************************************************************
 *  Version Check
 ******************************************************************************/

/*  Version checking  */
 #if (   (WDG_SW_MAJOR_VERSION != (8U))||(WDG_SW_MINOR_VERSION != (6U)))
  #error "Version numbers of Wdg_PBcfg.c and Wdg.h are inconsistent!"
#endif

#if (   (WDG_CFG_MAJOR_VERSION != (8U)) || (WDG_CFG_MINOR_VERSION != (6U)))
  #error "Version numbers of Wdg_PBcfg.c and Wdg_Cfg.h are inconsistent!"
#endif

/*******************************************************************************
 * Local Preprocessor #define Constants
 ******************************************************************************/

/*******************************************************************************
 * Local Preprocessor #define Macros
 ******************************************************************************/

/*******************************************************************************
 * Local Data Types and Structures
 ******************************************************************************/

/*******************************************************************************
 * Constants for Post-Build Configuration
 ******************************************************************************/
#define  WDG_START_SEC_CONFIG_DATA

#include "Wdg_MemMap.h"

/*<WDG_CFG_CONFIG>*/
/* SourceId : WDG_SourceId_016 */
/* DesignId : WDG_DesignId_007 */
/* Requirements : AR_WDG_SR56 */

CONST(Wdg_ConfigType, WDG_PBCFG) WdgSettingsConfig =
{
   .defaultMode = WDGIF_FAST_MODE,
   .instanceId = 0,
   .initialTimeOut = (1000U),
   .fastModeCfg =
   {
       .reaction = WDG_GENERATE_NMI,
       .windowSize = WDG_WINDOW_SIZE_100_PERCENT, 
	   .preloadValue = (1830U), 
   },
   .slowModeCfg =
   {
       .reaction = WDG_GENERATE_NMI,
       .windowSize = WDG_WINDOW_SIZE_100_PERCENT, 
	   .preloadValue = (1830U), 
   },
};

/*</WDG_CFG_CONFIG>*/
#define  WDG_STOP_SEC_CONFIG_DATA

#include "Wdg_MemMap.h"
/*******************************************************************************
 *  End of File: Wdg_PBcfg.c
 ******************************************************************************/

