/********************************************************************
 * *
 * * SOC memory map header file
 * *
 * * Copyright (C) 2020 Texas Instruments Incorporated.
 * *
 * *  Redistribution and use in source and binary forms, with or without
 * *  modification, are permitted provided that the following conditions
 * *  are met:
 * *
 * *    Redistributions of source code must retain the above copyright
 * *    notice, this list of conditions and the following disclaimer.
 * *
 * *    Redistributions in binary form must reproduce the above copyright
 * *    notice, this list of conditions and the following disclaimer in the
 * *    documentation and/or other materials provided with the
 * *    distribution.
 * *
 * *    Neither the name of Texas Instruments Incorporated nor the names of
 * *    its contributors may be used to endorse or promote products derived
 * *    from this software without specific prior written permission.
 * *
 * *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * *
 * */
#ifndef MCAL_HW_SOC_BASEADDRESS_H
#define MCAL_HW_SOC_BASEADDRESS_H

#ifdef __cplusplus

extern "C"
{
#endif

/* Global addresses in unified address space */


#define MCAL_CSL_HSM_ROM_U_BASE                  (0x20000000ul)
#define MCAL_CSL_HSM_SEC_ROM_U_BASE                  (0x20010000ul)
#define MCAL_CSL_HSM_RAM_U_BASE                  (0x20020000ul)
#define MCAL_CSL_MCRC0_U_BASE                  (0x35000000ul)
#define MCAL_CSL_STM_STIM_U_BASE                  (0x39000000ul)
#define MCAL_CSL_HSM_SOC_CTRL_U_BASE                  (0x40000000ul)
#define MCAL_CSL_MPU_L2OCRAM_BANK0_U_BASE                  (0x40020000ul)
#define MCAL_CSL_MPU_L2OCRAM_BANK1_U_BASE                  (0x40040000ul)
#define MCAL_CSL_MPU_L2OCRAM_BANK2_U_BASE                  (0x40060000ul)
#define MCAL_CSL_MPU_L2OCRAM_BANK3_U_BASE                  (0x40080000ul)
#define MCAL_CSL_MPU_R5SS0_CORE0_AXIS_U_BASE                  (0x400A0000ul)
#define MCAL_CSL_MPU_R5SS0_CORE1_AXIS_U_BASE                  (0x400C0000ul)
#define MCAL_CSL_MPU_R5SS1_CORE0_AXIS_U_BASE                  (0x400E0000ul)
#define MCAL_CSL_MPU_R5SS1_CORE1_AXIS_U_BASE                  (0x40100000ul)
#define MCAL_CSL_MPU_HSM_DTHE_U_BASE                  (0x40120000ul)
#define MCAL_CSL_MPU_MBOX_SRAM_U_BASE                  (0x40140000ul)
#define MCAL_CSL_MPU_QSPI0_U_BASE                  (0x40160000ul)
#define MCAL_CSL_MPU_SCRM2SCRP0_U_BASE                  (0x40180000ul)
#define MCAL_CSL_MPU_SCRM2SCRP1_U_BASE                  (0x401A0000ul)
#define MCAL_CSL_MPU_R5SS0_CORE0_AHB_U_BASE                  (0x401C0000ul)
#define MCAL_CSL_MPU_R5SS0_CORE1_AHB_U_BASE                  (0x401E0000ul)
#define MCAL_CSL_MPU_R5SS1_CORE0_AHB_U_BASE                  (0x40200000ul)
#define MCAL_CSL_MPU_R5SS1_CORE1_AHB_U_BASE                  (0x40220000ul)
#define MCAL_CSL_MPU_HSM_U_BASE                  (0x40240000ul)
#define MCAL_CSL_HSM_SOC_PCR_U_BASE                  (0x40F78000ul)
#define MCAL_CSL_HSM_STC_U_BASE                  (0x40F78C00ul)
#define MCAL_CSL_HSM_PBIST_U_BASE                  (0x40F79000ul)
#define MCAL_CSL_HSM_ECC_AGGR_U_BASE                  (0x40F79400ul)
#define MCAL_CSL_HSM_MBOX_SRAM_U_BASE                  (0x44000000ul)
#define MCAL_CSL_HSM_SEC_MGR_U_BASE                  (0x46000000ul)
#define MCAL_CSL_HSM_SEC_RAM_U_BASE                  (0x46050000ul)
#define MCAL_CSL_HSM_CTRL_U_BASE                  (0x47000000ul)
#define MCAL_CSL_HSM_TPCC0_U_BASE                  (0x47020000ul)
#define MCAL_CSL_HSM_TPTC00_U_BASE                  (0x47040000ul)
#define MCAL_CSL_HSM_TPTC01_U_BASE                  (0x47060000ul)
#define MCAL_CSL_HSM_PCR_U_BASE                  (0x47F78000ul)
#define MCAL_CSL_HSM_RTI0_U_BASE                  (0x47F78C00ul)
#define MCAL_CSL_HSM_WDT0_U_BASE                  (0x47F78D00ul)
#define MCAL_CSL_HSM_DCC0_U_BASE                  (0x47F79000ul)
#define MCAL_CSL_HSM_ESM_U_BASE                  (0x47F79400ul)
#define MCAL_CSL_HSM_DMT0_U_BASE                  (0x47F79800ul)
#define MCAL_CSL_HSM_DMT1_U_BASE                  (0x47F79900ul)
#define MCAL_CSL_ICSSM0_INTERNAL_U_BASE                  (0x48000000ul)
#define MCAL_CSL_ICSSM0_ECC_U_BASE                  (0x48100000ul)
#define MCAL_CSL_QSPI0_U_BASE                  (0x48200000ul)
#define MCAL_CSL_MMC0_U_BASE                  (0x48300000ul)
#define MCAL_CSL_GPMC0_CFG_U_BASE                  (0x48400000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM0_U_BASE                  (0x50000000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM1_U_BASE                  (0x50001000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM2_U_BASE                  (0x50002000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM3_U_BASE                  (0x50003000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM4_U_BASE                  (0x50004000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM5_U_BASE                  (0x50005000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM6_U_BASE                  (0x50006000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM7_U_BASE                  (0x50007000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM8_U_BASE                  (0x50008000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM9_U_BASE                  (0x50009000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM10_U_BASE                  (0x5000A000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM11_U_BASE                  (0x5000B000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM12_U_BASE                  (0x5000C000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM13_U_BASE                  (0x5000D000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM14_U_BASE                  (0x5000E000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM15_U_BASE                  (0x5000F000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM16_U_BASE                  (0x50010000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM17_U_BASE                  (0x50011000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM18_U_BASE                  (0x50012000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM19_U_BASE                  (0x50013000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM20_U_BASE                  (0x50014000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM21_U_BASE                  (0x50015000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM22_U_BASE                  (0x50016000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM23_U_BASE                  (0x50017000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM24_U_BASE                  (0x50018000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM25_U_BASE                  (0x50019000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM26_U_BASE                  (0x5001A000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM27_U_BASE                  (0x5001B000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM28_U_BASE                  (0x5001C000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM29_U_BASE                  (0x5001D000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM30_U_BASE                  (0x5001E000ul)
#define MCAL_CSL_CONTROLSS_G0_EPWM31_U_BASE                  (0x5001F000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM0_U_BASE                  (0x50040000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM1_U_BASE                  (0x50041000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM2_U_BASE                  (0x50042000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM3_U_BASE                  (0x50043000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM4_U_BASE                  (0x50044000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM5_U_BASE                  (0x50045000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM6_U_BASE                  (0x50046000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM7_U_BASE                  (0x50047000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM8_U_BASE                  (0x50048000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM9_U_BASE                  (0x50049000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM10_U_BASE                  (0x5004A000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM11_U_BASE                  (0x5004B000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM12_U_BASE                  (0x5004C000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM13_U_BASE                  (0x5004D000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM14_U_BASE                  (0x5004E000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM15_U_BASE                  (0x5004F000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM16_U_BASE                  (0x50050000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM17_U_BASE                  (0x50051000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM18_U_BASE                  (0x50052000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM19_U_BASE                  (0x50053000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM20_U_BASE                  (0x50054000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM21_U_BASE                  (0x50055000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM22_U_BASE                  (0x50056000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM23_U_BASE                  (0x50057000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM24_U_BASE                  (0x50058000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM25_U_BASE                  (0x50059000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM26_U_BASE                  (0x5005A000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM27_U_BASE                  (0x5005B000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM28_U_BASE                  (0x5005C000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM29_U_BASE                  (0x5005D000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM30_U_BASE                  (0x5005E000ul)
#define MCAL_CSL_CONTROLSS_G1_EPWM31_U_BASE                  (0x5005F000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM0_U_BASE                  (0x50080000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM1_U_BASE                  (0x50081000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM2_U_BASE                  (0x50082000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM3_U_BASE                  (0x50083000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM4_U_BASE                  (0x50084000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM5_U_BASE                  (0x50085000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM6_U_BASE                  (0x50086000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM7_U_BASE                  (0x50087000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM8_U_BASE                  (0x50088000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM9_U_BASE                  (0x50089000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM10_U_BASE                  (0x5008A000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM11_U_BASE                  (0x5008B000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM12_U_BASE                  (0x5008C000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM13_U_BASE                  (0x5008D000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM14_U_BASE                  (0x5008E000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM15_U_BASE                  (0x5008F000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM16_U_BASE                  (0x50090000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM17_U_BASE                  (0x50091000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM18_U_BASE                  (0x50092000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM19_U_BASE                  (0x50093000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM20_U_BASE                  (0x50094000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM21_U_BASE                  (0x50095000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM22_U_BASE                  (0x50096000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM23_U_BASE                  (0x50097000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM24_U_BASE                  (0x50098000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM25_U_BASE                  (0x50099000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM26_U_BASE                  (0x5009A000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM27_U_BASE                  (0x5009B000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM28_U_BASE                  (0x5009C000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM29_U_BASE                  (0x5009D000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM30_U_BASE                  (0x5009E000ul)
#define MCAL_CSL_CONTROLSS_G2_EPWM31_U_BASE                  (0x5009F000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM0_U_BASE                  (0x500C0000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM1_U_BASE                  (0x500C1000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM2_U_BASE                  (0x500C2000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM3_U_BASE                  (0x500C3000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM4_U_BASE                  (0x500C4000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM5_U_BASE                  (0x500C5000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM6_U_BASE                  (0x500C6000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM7_U_BASE                  (0x500C7000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM8_U_BASE                  (0x500C8000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM9_U_BASE                  (0x500C9000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM10_U_BASE                  (0x500CA000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM11_U_BASE                  (0x500CB000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM12_U_BASE                  (0x500CC000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM13_U_BASE                  (0x500CD000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM14_U_BASE                  (0x500CE000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM15_U_BASE                  (0x500CF000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM16_U_BASE                  (0x500D0000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM17_U_BASE                  (0x500D1000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM18_U_BASE                  (0x500D2000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM19_U_BASE                  (0x500D3000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM20_U_BASE                  (0x500D4000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM21_U_BASE                  (0x500D5000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM22_U_BASE                  (0x500D6000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM23_U_BASE                  (0x500D7000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM24_U_BASE                  (0x500D8000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM25_U_BASE                  (0x500D9000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM26_U_BASE                  (0x500DA000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM27_U_BASE                  (0x500DB000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM28_U_BASE                  (0x500DC000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM29_U_BASE                  (0x500DD000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM30_U_BASE                  (0x500DE000ul)
#define MCAL_CSL_CONTROLSS_G3_EPWM31_U_BASE                  (0x500DF000ul)
#define MCAL_CSL_CONTROLSS_ADC0_RESULT_U_BASE                  (0x50100000ul)
#define MCAL_CSL_CONTROLSS_ADC1_RESULT_U_BASE                  (0x50101000ul)
#define MCAL_CSL_CONTROLSS_ADC2_RESULT_U_BASE                  (0x50102000ul)
#define MCAL_CSL_CONTROLSS_ADC3_RESULT_U_BASE                  (0x50103000ul)
#define MCAL_CSL_CONTROLSS_ADC4_RESULT_U_BASE                  (0x50104000ul)
#define MCAL_CSL_CONTROLSS_CMPSSA0_U_BASE                  (0x50200000ul)
#define MCAL_CSL_CONTROLSS_CMPSSA1_U_BASE                  (0x50201000ul)
#define MCAL_CSL_CONTROLSS_CMPSSA2_U_BASE                  (0x50202000ul)
#define MCAL_CSL_CONTROLSS_CMPSSA3_U_BASE                  (0x50203000ul)
#define MCAL_CSL_CONTROLSS_CMPSSA4_U_BASE                  (0x50204000ul)
#define MCAL_CSL_CONTROLSS_CMPSSA5_U_BASE                  (0x50205000ul)
#define MCAL_CSL_CONTROLSS_CMPSSA6_U_BASE                  (0x50206000ul)
#define MCAL_CSL_CONTROLSS_CMPSSA7_U_BASE                  (0x50207000ul)
#define MCAL_CSL_CONTROLSS_CMPSSA8_U_BASE                  (0x50208000ul)
#define MCAL_CSL_CONTROLSS_CMPSSA9_U_BASE                  (0x50209000ul)
#define MCAL_CSL_CONTROLSS_CMPSSB0_U_BASE                  (0x50220000ul)
#define MCAL_CSL_CONTROLSS_CMPSSB1_U_BASE                  (0x50221000ul)
#define MCAL_CSL_CONTROLSS_CMPSSB2_U_BASE                  (0x50222000ul)
#define MCAL_CSL_CONTROLSS_CMPSSB3_U_BASE                  (0x50223000ul)
#define MCAL_CSL_CONTROLSS_CMPSSB4_U_BASE                  (0x50224000ul)
#define MCAL_CSL_CONTROLSS_CMPSSB5_U_BASE                  (0x50225000ul)
#define MCAL_CSL_CONTROLSS_CMPSSB6_U_BASE                  (0x50226000ul)
#define MCAL_CSL_CONTROLSS_CMPSSB7_U_BASE                  (0x50227000ul)
#define MCAL_CSL_CONTROLSS_CMPSSB8_U_BASE                  (0x50228000ul)
#define MCAL_CSL_CONTROLSS_CMPSSB9_U_BASE                  (0x50229000ul)
#define MCAL_CSL_CONTROLSS_ECAP0_U_BASE                  (0x50240000ul)
#define MCAL_CSL_CONTROLSS_ECAP1_U_BASE                  (0x50241000ul)
#define MCAL_CSL_CONTROLSS_ECAP2_U_BASE                  (0x50242000ul)
#define MCAL_CSL_CONTROLSS_ECAP3_U_BASE                  (0x50243000ul)
#define MCAL_CSL_CONTROLSS_ECAP4_U_BASE                  (0x50244000ul)
#define MCAL_CSL_CONTROLSS_ECAP5_U_BASE                  (0x50245000ul)
#define MCAL_CSL_CONTROLSS_ECAP6_U_BASE                  (0x50246000ul)
#define MCAL_CSL_CONTROLSS_ECAP7_U_BASE                  (0x50247000ul)
#define MCAL_CSL_CONTROLSS_ECAP8_U_BASE                  (0x50248000ul)
#define MCAL_CSL_CONTROLSS_ECAP9_U_BASE                  (0x50249000ul)
#define MCAL_CSL_CONTROLSS_DAC0_U_BASE                  (0x50260000ul)
#define MCAL_CSL_CONTROLSS_SDFM0_U_BASE                  (0x50268000ul)
#define MCAL_CSL_CONTROLSS_SDFM1_U_BASE                  (0x50269000ul)
#define MCAL_CSL_CONTROLSS_EQEP0_U_BASE                  (0x50270000ul)
#define MCAL_CSL_CONTROLSS_EQEP1_U_BASE                  (0x50271000ul)
#define MCAL_CSL_CONTROLSS_EQEP2_U_BASE                  (0x50272000ul)
#define MCAL_CSL_CONTROLSS_FSI_TX0_U_BASE                  (0x50280000ul)
#define MCAL_CSL_CONTROLSS_FSI_TX1_U_BASE                  (0x50281000ul)
#define MCAL_CSL_CONTROLSS_FSI_RX0_U_BASE                  (0x50290000ul)
#define MCAL_CSL_CONTROLSS_FSI_RX1_U_BASE                  (0x50291000ul)
#define MCAL_CSL_CONTROLSS_FSI_TX2_U_BASE                  (0x502A0000ul)
#define MCAL_CSL_CONTROLSS_FSI_TX3_U_BASE                  (0x502A1000ul)
#define MCAL_CSL_CONTROLSS_FSI_RX2_U_BASE                  (0x502B0000ul)
#define MCAL_CSL_CONTROLSS_FSI_RX3_U_BASE                  (0x502B1000ul)
#define MCAL_CSL_CONTROLSS_ADC0_U_BASE                  (0x502C0000ul)
#define MCAL_CSL_CONTROLSS_ADC1_U_BASE                  (0x502C1000ul)
#define MCAL_CSL_CONTROLSS_ADC2_U_BASE                  (0x502C2000ul)
#define MCAL_CSL_CONTROLSS_ADC3_U_BASE                  (0x502C3000ul)
#define MCAL_CSL_CONTROLSS_ADC4_U_BASE                  (0x502C4000ul)
#define MCAL_CSL_CONTROLSS_INPUTXBAR_U_BASE                  (0x502D0000ul)
#define MCAL_CSL_CONTROLSS_PWMXBAR_U_BASE                  (0x502D1000ul)
#define MCAL_CSL_CONTROLSS_PWMSYNCOUTXBAR_U_BASE                  (0x502D2000ul)
#define MCAL_CSL_CONTROLSS_MDLXBAR_U_BASE                  (0x502D3000ul)
#define MCAL_CSL_CONTROLSS_ICLXBAR_U_BASE                  (0x502D4000ul)
#define MCAL_CSL_CONTROLSS_INTXBAR_U_BASE                  (0x502D5000ul)
#define MCAL_CSL_CONTROLSS_DMAXBAR_U_BASE                  (0x502D6000ul)
#define MCAL_CSL_CONTROLSS_OUTPUTXBAR_U_BASE                  (0x502D8000ul)
#define MCAL_CSL_CONTROLSS_OTTOCAL0_U_BASE                  (0x502E0000ul)
#define MCAL_CSL_CONTROLSS_OTTOCAL1_U_BASE                  (0x502E1000ul)
#define MCAL_CSL_CONTROLSS_OTTOCAL2_U_BASE                  (0x502E2000ul)
#define MCAL_CSL_CONTROLSS_OTTOCAL3_U_BASE                  (0x502E3000ul)
#define MCAL_CSL_CONTROLSS_CTRL_U_BASE                  (0x502F0000ul)
#define MCAL_CSL_DEBUGSS_U_BASE                  (0x50800000ul)
#define MCAL_CSL_MSS_CTRL_U_BASE                  (0x50D00000ul)
#define MCAL_CSL_TOP_CTRL_U_BASE                  (0x50D80000ul)
#define MCAL_CSL_SPINLOCK0_BASE                  (0x50E00000ul)
#define MCAL_CSL_VIM_U_BASE                  (0x50F00000ul)
#define MCAL_CSL_GPIO0_U_BASE                  (0x52000000ul)
#define MCAL_CSL_GPIO1_U_BASE                  (0x52001000ul)
#define MCAL_CSL_GPIO2_U_BASE                  (0x52002000ul)
#define MCAL_CSL_GPIO3_U_BASE                  (0x52003000ul)
#define MCAL_CSL_WDT0_U_BASE                  (0x52100000ul)
#define MCAL_CSL_WDT1_U_BASE                  (0x52101000ul)
#define MCAL_CSL_WDT2_U_BASE                  (0x52102000ul)
#define MCAL_CSL_WDT3_U_BASE                  (0x52103000ul)
#define MCAL_CSL_RTI0_U_BASE                  (0x52180000ul)
#define MCAL_CSL_RTI1_U_BASE                  (0x52181000ul)
#define MCAL_CSL_RTI2_U_BASE                  (0x52182000ul)
#define MCAL_CSL_RTI3_U_BASE                  (0x52183000ul)
#define MCAL_CSL_MCSPI0_U_BASE                  (0x52200000ul)
#define MCAL_CSL_MCSPI1_U_BASE                  (0x52201000ul)
#define MCAL_CSL_MCSPI2_U_BASE                  (0x52202000ul)
#define MCAL_CSL_MCSPI3_U_BASE                  (0x52203000ul)
#define MCAL_CSL_MCSPI4_U_BASE                  (0x52204000ul)
#define MCAL_CSL_UART0_U_BASE                  (0x52300000ul)
#define MCAL_CSL_UART1_U_BASE                  (0x52301000ul)
#define MCAL_CSL_UART2_U_BASE                  (0x52302000ul)
#define MCAL_CSL_UART3_U_BASE                  (0x52303000ul)
#define MCAL_CSL_UART4_U_BASE                  (0x52304000ul)
#define MCAL_CSL_UART5_U_BASE                  (0x52305000ul)
#define MCAL_CSL_LIN0_U_BASE                  (0x52400000ul)
#define MCAL_CSL_LIN1_U_BASE                  (0x52401000ul)
#define MCAL_CSL_LIN2_U_BASE                  (0x52402000ul)
#define MCAL_CSL_LIN3_U_BASE                  (0x52403000ul)
#define MCAL_CSL_LIN4_U_BASE                  (0x52404000ul)
#define MCAL_CSL_I2C0_U_BASE                  (0x52500000ul)
#define MCAL_CSL_I2C1_U_BASE                  (0x52501000ul)
#define MCAL_CSL_I2C2_U_BASE                  (0x52502000ul)
#define MCAL_CSL_I2C3_U_BASE                  (0x52503000ul)
#define MCAL_CSL_MCAN0_MSG_RAM_U_BASE                  (0x52600000ul)
#define MCAL_CSL_MCAN0_CFG_U_BASE                  (0x52608000ul)
#define MCAL_CSL_MCAN1_MSG_RAM_U_BASE                  (0x52610000ul)
#define MCAL_CSL_MCAN1_CFG_U_BASE                  (0x52618000ul)
#define MCAL_CSL_MCAN2_MSG_RAM_U_BASE                  (0x52620000ul)
#define MCAL_CSL_MCAN2_CFG_U_BASE                  (0x52628000ul)
#define MCAL_CSL_MCAN3_MSG_RAM_U_BASE                  (0x52630000ul)
#define MCAL_CSL_MCAN3_CFG_U_BASE                  (0x52638000ul)
#define MCAL_CSL_MCAN0_ECC_U_BASE                  (0x52700000ul)
#define MCAL_CSL_MCAN1_ECC_U_BASE                  (0x52701000ul)
#define MCAL_CSL_MCAN2_ECC_U_BASE                  (0x52702000ul)
#define MCAL_CSL_MCAN3_ECC_U_BASE                  (0x52703000ul)
#define MCAL_CSL_CPSW0_U_BASE                  (0x52800000ul)
#define MCAL_CSL_TPCC0_U_BASE                  (0x52A00000ul)
#define MCAL_CSL_TPTC00_U_BASE                  (0x52A40000ul)
#define MCAL_CSL_TPTC01_U_BASE                  (0x52A60000ul)
#define MCAL_CSL_DCC0_U_BASE                  (0x52B00000ul)
#define MCAL_CSL_DCC1_U_BASE                  (0x52B01000ul)
#define MCAL_CSL_DCC2_U_BASE                  (0x52B02000ul)
#define MCAL_CSL_DCC3_U_BASE                  (0x52B03000ul)
#define MCAL_CSL_TOP_ESM_U_BASE                  (0x52D00000ul)
#define MCAL_CSL_SOC_TIMESYNC_XBAR0_U_BASE                  (0x52E00000ul)
#define MCAL_CSL_EDMA_TRIG_XBAR_U_BASE                  (0x52E01000ul)
#define MCAL_CSL_GPIO_INTR_XBAR_U_BASE                  (0x52E02000ul)
#define MCAL_CSL_ICSSM_INTR_XBAR_U_BASE                  (0x52E03000ul)
#define MCAL_CSL_SOC_TIMESYNC_XBAR1_U_BASE                  (0x52E04000ul)
#define MCAL_CSL_ECC_AGG_R5SS0_CORE0_U_BASE                  (0x53000000ul)
#define MCAL_CSL_ECC_AGG_R5SS0_CORE1_U_BASE                  (0x53003000ul)
#define MCAL_CSL_ECC_AGG_R5SS1_CORE0_U_BASE                  (0x53004000ul)
#define MCAL_CSL_ECC_AGG_R5SS1_CORE1_U_BASE                  (0x53007000ul)
#define MCAL_CSL_ECC_AGG_TOP_U_BASE                  (0x53010000ul)
#define MCAL_CSL_IOMUX_U_BASE                  (0x53100000ul)
#define MCAL_CSL_TOP_RCM_U_BASE                  (0x53200000ul)
#define MCAL_CSL_MSS_RCM_U_BASE                  (0x53208000ul)
#define MCAL_CSL_R5SS0_CCMR_U_BASE                  (0x53210000ul)
#define MCAL_CSL_R5SS1_CCMR_U_BASE                  (0x53211000ul)
#define MCAL_CSL_TOP_PBIST_U_BASE                  (0x53300000ul)
#define MCAL_CSL_R5SS0_STC_U_BASE                  (0x53500000ul)
#define MCAL_CSL_R5SS1_STC_U_BASE                  (0x53510000ul)
#define MCAL_CSL_TOP_EFUSE_FARM_U_BASE                  (0x53600000ul)
#define MCAL_CSL_EXT_FLASH0_U_BASE                  (0x60000000ul)
#define MCAL_CSL_EXT_FLASH1_U_BASE                  (0x62000000ul)
#define MCAL_CSL_GPMC0_MEM_U_BASE                  (0x68000000ul)
#define MCAL_CSL_L2OCRAM_U_BASE                  (0x70000000ul)
#define MCAL_CSL_MBOX_SRAM_U_BASE                  (0x72000000ul)
#define MCAL_CSL_R5SS0_CORE0_ICACHE_U_BASE                  (0x74000000ul)
#define MCAL_CSL_R5SS0_CORE0_DCACHE_U_BASE                  (0x74800000ul)
#define MCAL_CSL_R5SS0_CORE1_ICACHE_U_BASE                  (0x75000000ul)
#define MCAL_CSL_R5SS0_CORE1_DCACHE_U_BASE                  (0x75800000ul)
#define MCAL_CSL_R5SS1_CORE0_ICACHE_U_BASE                  (0x76000000ul)
#define MCAL_CSL_R5SS1_CORE0_DCACHE_U_BASE                  (0x76800000ul)
#define MCAL_CSL_R5SS1_CORE1_ICACHE_U_BASE                  (0x77000000ul)
#define MCAL_CSL_R5SS1_CORE1_DCACHE_U_BASE                  (0x77800000ul)
#define MCAL_CSL_R5SS0_CORE0_TCMA_U_BASE                  (0x78000000ul)
#define MCAL_CSL_R5SS0_CORE0_TCMB_U_BASE                  (0x78100000ul)
#define MCAL_CSL_R5SS0_CORE1_TCMA_U_BASE                  (0x78200000ul)
#define MCAL_CSL_R5SS0_CORE1_TCMB_U_BASE                  (0x78300000ul)
#define MCAL_CSL_R5SS1_CORE0_TCMA_U_BASE                  (0x78400000ul)
#define MCAL_CSL_R5SS1_CORE0_TCMB_U_BASE                  (0x78500000ul)
#define MCAL_CSL_R5SS1_CORE1_TCMA_U_BASE                  (0x78600000ul)
#define MCAL_CSL_R5SS1_CORE1_TCMB_U_BASE                  (0x78700000ul)
#define MCAL_CSL_HSM_DTHE_U_BASE                  (0xCE000000ul)
#define MCAL_CSL_HSM_SHA_U_BASE                  (0xCE004000ul)
#define MCAL_CSL_HSM_AES_U_BASE                  (0xCE006000ul)
#define MCAL_CSL_HSM_TRNG_U_BASE                  (0xCE00A000ul)
#define MCAL_CSL_HSM_PKA_U_BASE                  (0xCE010000ul)
#define MCAL_CSL_HSM_PKA_RAM_U_BASE                  (0xCE014000ul)


#ifdef __cplusplus
}
#endif
#endif /* CSLR_SOC_BASEADDRESS_H_ */
