/*
 *  Copyright (c) Texas Instruments Incorporated 2021
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
 *
 *  \file hw_adc.h
 *
 *  \brief
 *     The file contains the register layer definitons for the
 *     GPADC Module.
 *
 *
 */

/****************************************************************************************
 * FILE INCLUSION PROTECTION
 ****************************************************************************************
 */
#ifndef HW_ADC_H
#define HW_ADC_H

/****************************************************************************************
 * INCLUDE FILES
 ****************************************************************************************
 */
#include "Std_Types.h"
/****************************************************************************************
 * MACROS
 ****************************************************************************************
 */

/* Base Address*/

#define MSS_RCM_BASE_ADDRESS                   (0x02100000U)
#define MSS_GPADC_REG_BASE_ADDRESS             (0x03F79800U)
#define MSS_TOPRCM_BASE_ADDRESS                (0x02140000U)
#define MSS_TOP_CTRL_BASE_ADDRESS              (0x030E0000U)

/*MSS_RCM_REG_ADDR_OFFSET*/

#define MSS_GPADC_CLK_DIV_VAL_ADDR_OFFSET         (0x00000098U)
#define MSS_GPADC_CLK_GATE_ADDR_OFFSET            (0x000000E0U)
#define MSS_GPADC_RST_CTRL_ADDR_OFFSET            (0x000001ACU)

/*MSS_TOPRCM_REG_ADDR_OFFSET*/

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ADDR_OFFSET             (0x00000C34U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_ADDR_OFFSET             (0x00000C24U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADDR_OFFSET                  (0x00000C30U)

/*MSS_GPADC_REG_OFFSET*/

#define R_REG0_ADDR_OFFSET                        (0x00000000U)
#define R_REG1_ADDR_OFFSET                        (0x00000004U)
#define R_REG2_ADDR_OFFSET                        (0x00000008U)
#define R_REG3_ADDR_OFFSET                        (0x0000000CU)
#define R_REG4_ADDR_OFFSET                        (0x00000010U)
#define R_REG5_ADDR_OFFSET                        (0x00000014U)
#define R_REG6_ADDR_OFFSET                        (0x00000018U)
#define R_REG7_ADDR_OFFSET                        (0x0000001CU)
#define R_REG8_ADDR_OFFSET                        (0x00000020U)
#define R_REG14_ADDR_OFFSET                       (0x00000038U)
#define R_REG15_ADDR_OFFSET                       (0x0000003CU)
#define R_REG17_ADDR_OFFSET                       (0x00000044U)
#define R_REG18_ADDR_OFFSET                       (0x00000048U)

/*TOP_CTRL_REG_ADDR_OFFSET*/

#define EFUSE1_ROW_14_ADDR_OFFSET                 (0x00000430U)
#define EFUSE1_ROW_33_ADDR_OFFSET                 (0x0000047CU)
#define EFUSE1_ROW_34_ADDR_OFFSET                 (0x00000480U)
#define EFUSE1_ROW_35_ADDR_OFFSET                 (0x00000484U)
#define EFUSE1_ROW_36_ADDR_OFFSET                 (0x00000488U)
#define EFUSE1_ROW_37_ADDR_OFFSET                 (0x0000048CU)
#define EFUSE1_ROW_38_ADDR_OFFSET                 (0x00000490U)



/* MSS_GPADC_CLK_DIV_VAL */

#define MSS_GPADC_CLK_DIV_VAL_CLKDIVR_MASK   (0x00FFFFFFU)
#define MSS_GPADC_CLK_DIV_VAL_CLKDIVR_SHIFT  (0x00000000U)
#define MSS_GPADC_CLK_DIV_VAL_CLKDIVR_RESETVAL (0x00000000U)
#define MSS_GPADC_CLK_DIV_VAL_CLKDIVR_MAX    (0x00FFFFFFU)

#define MSS_GPADC_CLK_DIV_VAL_RESETVAL                             (0x00000000U)

/* MSS_GPADC_CLK_GATE */

#define MSS_GPADC_CLK_GATE_GATED_MASK           (0x00000007U)
#define MSS_GPADC_CLK_GATE_GATED_SHIFT          (0x00000000U)
#define MSS_GPADC_CLK_GATE_GATED_RESETVAL       (0x00000000U)
#define MSS_GPADC_CLK_GATE_GATED_MAX            (0x00000007U)

#define MSS_GPADC_CLK_GATE_RESETVAL                                (0x00000000U)

/* MSS_GPADC_CLK_STATUS */

#define MSS_GPADC_CLK_STATUS_CURRDIVIDER_MASK (0x0000FF00U)
#define MSS_GPADC_CLK_STATUS_CURRDIVIDER_SHIFT (0x00000008U)
#define MSS_GPADC_CLK_STATUS_CURRDIVIDER_RESETVAL (0x00000000U)
#define MSS_GPADC_CLK_STATUS_CURRDIVIDER_MAX  (0x000000FFU)

#define MSS_GPADC_CLK_STATUS_RESETVAL                              (0x00000000U)

/* MSS_GPADC_RST_CTRL */

#define MSS_GPADC_RST_CTRL_ASSERT_MASK          (0x00000007U)
#define MSS_GPADC_RST_CTRL_ASSERT_SHIFT         (0x00000000U)
#define MSS_GPADC_RST_CTRL_ASSERT_RESETVAL      (0x00000000U)
#define MSS_GPADC_RST_CTRL_ASSERT_MAX           (0x00000007U)

#define MSS_GPADC_RST_CTRL_RESETVAL                                (0x00000000U)

/* GPADC_CTRL */

#define GPADC_CTRL_GPADC_SW_TRIG_MASK                  (0x00000001U)
#define GPADC_CTRL_GPADC_SW_TRIG_SHIFT                 (0x00000000U)
#define GPADC_CTRL_GPADC_SW_TRIG_RESETVAL              (0x00000000U)
#define GPADC_CTRL_GPADC_SW_TRIG_MAX                   (0x00000001U)

#define GPADC_CTRL_GPADC_TRIGIN_SEL_MASK               (0x00001F00U)
#define GPADC_CTRL_GPADC_TRIGIN_SEL_SHIFT              (0x00000008U)
#define GPADC_CTRL_GPADC_TRIGIN_SEL_RESETVAL           (0x0000000FU)
#define GPADC_CTRL_GPADC_TRIGIN_SEL_MAX                (0x0000001FU)

#define GPADC_CTRL_RESETVAL                                       (0x00000F00U)

/* MSS_GPADC_MEM_INIT */

#define MSS_GPADC_MEM_INIT_MEM0_INIT_MASK      (0x00000001U)
#define MSS_GPADC_MEM_INIT_MEM0_INIT_SHIFT     (0x00000000U)
#define MSS_GPADC_MEM_INIT_MEM0_INIT_RESETVAL  (0x00000000U)
#define MSS_GPADC_MEM_INIT_MEM0_INIT_MAX       (0x00000001U)

#define MSS_GPADC_MEM_INIT_RESETVAL                               (0x00000000U)

/* MSS_GPADC_MEM_INIT_DONE */

#define MSS_GPADC_MEM_INIT_DONE_MEM0_DONE_MASK (0x00000001U)
#define MSS_GPADC_MEM_INIT_DONE_MEM0_DONE_SHIFT (0x00000000U)
#define MSS_GPADC_MEM_INIT_DONE_MEM0_DONE_RESETVAL (0x00000000U)
#define MSS_GPADC_MEM_INIT_DONE_MEM0_DONE_MAX (0x00000001U)

#define MSS_GPADC_MEM_INIT_DONE_RESETVAL                          (0x00000000U)

/* MSS_GPADC_MEM_INIT_STATUS */

#define MSS_GPADC_MEM_INIT_STATUS_MEM0_STATUS_MASK (0x00000001U)
#define MSS_GPADC_MEM_INIT_STATUS_MEM0_STATUS_SHIFT (0x00000000U)
#define MSS_GPADC_MEM_INIT_STATUS_MEM0_STATUS_RESETVAL (0x00000000U)
#define MSS_GPADC_MEM_INIT_STATUS_MEM0_STATUS_MAX (0x00000001U)

#define MSS_GPADC_MEM_INIT_STATUS_RESETVAL                        (0x00000000U)

/* ANA_REG_TW_CTRL_REG_LOWV */

#define ANA_REG_TW_CTRL_REG_LOWV_ADC_EN_MASK                    (0x00000001U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_EN_SHIFT                   (0x00000000U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_EN_RESETVAL                (0x00000000U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_EN_MAX                     (0x00000001U)

#define ANA_REG_TW_CTRL_REG_LOWV_ADC_START_CONV_MASK            (0x00000002U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_START_CONV_SHIFT           (0x00000001U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_START_CONV_RESETVAL        (0x00000000U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_START_CONV_MAX             (0x00000001U)

#define ANA_REG_TW_CTRL_REG_LOWV_ADC_RESET_MASK                 (0x00000004U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_RESET_SHIFT                (0x00000002U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_RESET_RESETVAL             (0x00000000U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_RESET_MAX                  (0x00000001U)

#define ANA_REG_TW_CTRL_REG_LOWV_ADC_INP_BUF_EN_MASK            (0x00000008U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_INP_BUF_EN_SHIFT           (0x00000003U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_INP_BUF_EN_RESETVAL        (0x00000000U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_INP_BUF_EN_MAX             (0x00000001U)

#define ANA_REG_TW_CTRL_REG_LOWV_ADC_REF_BUF_EN_MASK            (0x00000010U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_REF_BUF_EN_SHIFT           (0x00000004U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_REF_BUF_EN_RESETVAL        (0x00000000U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_REF_BUF_EN_MAX             (0x00000001U)

#define ANA_REG_TW_CTRL_REG_LOWV_ADC_REF_SEL_2_0_MASK           (0x000000E0U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_REF_SEL_2_0_SHIFT          (0x00000005U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_REF_SEL_2_0_RESETVAL       (0x00000000U)
#define ANA_REG_TW_CTRL_REG_LOWV_ADC_REF_SEL_2_0_MAX            (0x00000007U)

#define ANA_REG_TW_CTRL_REG_LOWV_TS_DIFF_INP_BUF_EN_MASK        (0x00000100U)
#define ANA_REG_TW_CTRL_REG_LOWV_TS_DIFF_INP_BUF_EN_SHIFT       (0x00000008U)
#define ANA_REG_TW_CTRL_REG_LOWV_TS_DIFF_INP_BUF_EN_RESETVAL    (0x00000000U)
#define ANA_REG_TW_CTRL_REG_LOWV_TS_DIFF_INP_BUF_EN_MAX         (0x00000001U)

#define ANA_REG_TW_CTRL_REG_LOWV_TS_SE_INP_BUF_EN_MASK          (0x00000200U)
#define ANA_REG_TW_CTRL_REG_LOWV_TS_SE_INP_BUF_EN_SHIFT         (0x00000009U)
#define ANA_REG_TW_CTRL_REG_LOWV_TS_SE_INP_BUF_EN_RESETVAL      (0x00000000U)
#define ANA_REG_TW_CTRL_REG_LOWV_TS_SE_INP_BUF_EN_MAX           (0x00000001U)

#define ANA_REG_TW_CTRL_REG_LOWV_IFORCE_EXT_CTRL_MASK           (0x00000400U)
#define ANA_REG_TW_CTRL_REG_LOWV_IFORCE_EXT_CTRL_SHIFT          (0x0000000AU)
#define ANA_REG_TW_CTRL_REG_LOWV_IFORCE_EXT_CTRL_RESETVAL       (0x00000000U)
#define ANA_REG_TW_CTRL_REG_LOWV_IFORCE_EXT_CTRL_MAX            (0x00000001U)

#define ANA_REG_TW_CTRL_REG_LOWV_VREF_EXT_CTRL_MASK             (0x00000800U)
#define ANA_REG_TW_CTRL_REG_LOWV_VREF_EXT_CTRL_SHIFT            (0x0000000BU)
#define ANA_REG_TW_CTRL_REG_LOWV_VREF_EXT_CTRL_RESETVAL         (0x00000000U)
#define ANA_REG_TW_CTRL_REG_LOWV_VREF_EXT_CTRL_MAX              (0x00000001U)

#define ANA_REG_TW_CTRL_REG_LOWV_VIN_EXT_CTRL_MASK              (0x00001000U)
#define ANA_REG_TW_CTRL_REG_LOWV_VIN_EXT_CTRL_SHIFT             (0x0000000CU)
#define ANA_REG_TW_CTRL_REG_LOWV_VIN_EXT_CTRL_RESETVAL          (0x00000000U)
#define ANA_REG_TW_CTRL_REG_LOWV_VIN_EXT_CTRL_MAX               (0x00000001U)

#define ANA_REG_TW_CTRL_REG_LOWV_ANA_TMUX_BUF_BYPASS_MASK       (0x00002000U)
#define ANA_REG_TW_CTRL_REG_LOWV_ANA_TMUX_BUF_BYPASS_SHIFT      (0x0000000DU)
#define ANA_REG_TW_CTRL_REG_LOWV_ANA_TMUX_BUF_BYPASS_RESETVAL   (0x00000000U)
#define ANA_REG_TW_CTRL_REG_LOWV_ANA_TMUX_BUF_BYPASS_MAX        (0x00000001U)

#define ANA_REG_TW_CTRL_REG_LOWV_ANA_TMUX_BUF_EN_MASK           (0x00004000U)
#define ANA_REG_TW_CTRL_REG_LOWV_ANA_TMUX_BUF_EN_SHIFT          (0x0000000EU)
#define ANA_REG_TW_CTRL_REG_LOWV_ANA_TMUX_BUF_EN_RESETVAL       (0x00000000U)
#define ANA_REG_TW_CTRL_REG_LOWV_ANA_TMUX_BUF_EN_MAX            (0x00000001U)

#define ANA_REG_TW_CTRL_REG_LOWV_RTRIM_TW_4_0_MASK              (0x000F8000U)
#define ANA_REG_TW_CTRL_REG_LOWV_RTRIM_TW_4_0_SHIFT             (0x0000000FU)
#define ANA_REG_TW_CTRL_REG_LOWV_RTRIM_TW_4_0_RESETVAL          (0x00000000U)
#define ANA_REG_TW_CTRL_REG_LOWV_RTRIM_TW_4_0_MAX               (0x0000001FU)

#define ANA_REG_TW_CTRL_REG_LOWV_RESERVED1_MASK                 (0xFFF00000U)
#define ANA_REG_TW_CTRL_REG_LOWV_RESERVED1_SHIFT                (0x00000014U)
#define ANA_REG_TW_CTRL_REG_LOWV_RESERVED1_RESETVAL             (0x00000000U)
#define ANA_REG_TW_CTRL_REG_LOWV_RESERVED1_MAX                  (0x00000FFFU)

#define ANA_REG_TW_CTRL_REG_LOWV_RESETVAL                       (0x00000000U)

/* ANA_REG_TW_ANA_TMUX_CTRL_LOWV */

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_WU_ANA_TEST_OUT_1P8V_MASK (0x00000001U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_WU_ANA_TEST_OUT_1P8V_SHIFT (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_WU_ANA_TEST_OUT_1P8V_RESETVAL (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_WU_ANA_TEST_OUT_1P8V_MAX  (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_REFSYS_TEST_OUT_1P8V_MASK (0x00000002U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_REFSYS_TEST_OUT_1P8V_SHIFT (0x00000001U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_REFSYS_TEST_OUT_1P8V_RESETVAL (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_REFSYS_TEST_OUT_1P8V_MAX  (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_PM_ANA_INP_2_MASK         (0x00000004U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_PM_ANA_INP_2_SHIFT        (0x00000002U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_PM_ANA_INP_2_RESETVAL     (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_PM_ANA_INP_2_MAX          (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_PM_ANA_INP_3_MASK         (0x00000008U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_PM_ANA_INP_3_SHIFT        (0x00000003U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_PM_ANA_INP_3_RESETVAL     (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_PM_ANA_INP_3_MAX          (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_PM_ANA_INP_4_MASK         (0x00000010U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_PM_ANA_INP_4_SHIFT        (0x00000004U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_PM_ANA_INP_4_RESETVAL     (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_PM_ANA_INP_4_MAX          (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_PM_ANA_INP_5_MASK         (0x00000020U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_PM_ANA_INP_5_SHIFT        (0x00000005U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_PM_ANA_INP_5_RESETVAL     (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_PM_ANA_INP_5_MAX          (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_VBE_S_BUFF_MASK           (0x00000040U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_VBE_S_BUFF_SHIFT          (0x00000006U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_VBE_S_BUFF_RESETVAL       (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_VBE_S_BUFF_MAX            (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_VBE_W_BUFF_MASK           (0x00000080U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_VBE_W_BUFF_SHIFT          (0x00000007U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_VBE_W_BUFF_RESETVAL       (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_VBE_W_BUFF_MAX            (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_DC_BIST_BUF_INP_1P8V_MASK (0x00000100U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_DC_BIST_BUF_INP_1P8V_SHIFT (0x00000008U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_DC_BIST_BUF_INP_1P8V_RESETVAL (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_DC_BIST_BUF_INP_1P8V_MAX  (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ADC_BUF_OUT_1P8V_MASK     (0x00000200U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ADC_BUF_OUT_1P8V_SHIFT    (0x00000009U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ADC_BUF_OUT_1P8V_RESETVAL (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ADC_BUF_OUT_1P8V_MAX      (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ADC_REF_BUF_OUT_MASK      (0x00000400U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ADC_REF_BUF_OUT_SHIFT     (0x0000000AU)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ADC_REF_BUF_OUT_RESETVAL  (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ADC_REF_BUF_OUT_MAX       (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_DELVBE_BUFF_OUT_MASK      (0x00000800U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_DELVBE_BUFF_OUT_SHIFT     (0x0000000BU)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_DELVBE_BUFF_OUT_RESETVAL  (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_DELVBE_BUFF_OUT_MAX       (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_VBE_TS_STRONG_MASK        (0x00001000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_VBE_TS_STRONG_SHIFT       (0x0000000CU)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_VBE_TS_STRONG_RESETVAL    (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_VBE_TS_STRONG_MAX         (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_VBE_TS_WEAK_MASK          (0x00002000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_VBE_TS_WEAK_SHIFT         (0x0000000DU)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_VBE_TS_WEAK_RESETVAL      (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_VBE_TS_WEAK_MAX           (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ODP_MASK                  (0x00004000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ODP_SHIFT                 (0x0000000EU)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ODP_RESETVAL              (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ODP_MAX                   (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_BIST_MUX_OUT_1P8V_MASK    (0x00008000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_BIST_MUX_OUT_1P8V_SHIFT   (0x0000000FU)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_BIST_MUX_OUT_1P8V_RESETVAL (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_BIST_MUX_OUT_1P8V_MAX     (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_I2V_SENSE_MASK            (0x00010000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_I2V_SENSE_SHIFT           (0x00000010U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_I2V_SENSE_RESETVAL        (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_I2V_SENSE_MAX             (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_TMUX_BUF_OUT_EN_MASK      (0x00020000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_TMUX_BUF_OUT_EN_SHIFT     (0x00000011U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_TMUX_BUF_OUT_EN_RESETVAL  (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_TMUX_BUF_OUT_EN_MAX       (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ATESTV_VSLDO_MASK         (0x00040000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ATESTV_VSLDO_SHIFT        (0x00000012U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ATESTV_VSLDO_RESETVAL     (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ATESTV_VSLDO_MAX          (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_RESERVED0_MASK            (0x3FF80000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_RESERVED0_SHIFT           (0x00000013U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_RESERVED0_RESETVAL        (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_RESERVED0_MAX             (0x000007FFU)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_CLK_TMUX_ESD_CTRL_MASK    (0x40000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_CLK_TMUX_ESD_CTRL_SHIFT   (0x0000001EU)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_CLK_TMUX_ESD_CTRL_RESETVAL (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_CLK_TMUX_ESD_CTRL_MAX     (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ANA_TEST_EN_MASK          (0x80000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ANA_TEST_EN_SHIFT         (0x0000001FU)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ANA_TEST_EN_RESETVAL      (0x00000000U)
#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_ANA_TEST_EN_MAX           (0x00000001U)

#define ANA_REG_TW_ANA_TMUX_CTRL_LOWV_RESETVAL                  (0x00000000U)


/* ANA_REG_REFSYS_SPARE_REG_LOWV */

#define ANA_REG_REFSYS_SPARE_REG_LOWV_POR_DIG_SEQ_ECO_DIS_MASK  (0x00000001U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_POR_DIG_SEQ_ECO_DIS_SHIFT (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_POR_DIG_SEQ_ECO_DIS_RESETVAL (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_POR_DIG_SEQ_ECO_DIS_MAX   (0x00000001U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_RESERVED_0_MASK           (0x0000003EU)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_RESERVED_0_SHIFT          (0x00000001U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_RESERVED_0_RESETVAL       (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_RESERVED_0_MAX            (0x0000001FU)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_SR_SEL_MASK           (0x000000C0U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_SR_SEL_SHIFT          (0x00000006U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_SR_SEL_RESETVAL       (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_SR_SEL_MAX            (0x00000003U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_UV_SELF_TEST_SEL_MASK (0x00000100U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_UV_SELF_TEST_SEL_SHIFT (0x00000008U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_UV_SELF_TEST_SEL_RESETVAL (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_UV_SELF_TEST_SEL_MAX  (0x00000001U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_OV_SELF_TEST_SEL_MASK (0x00000200U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_OV_SELF_TEST_SEL_SHIFT (0x00000009U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_OV_SELF_TEST_SEL_RESETVAL (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_OV_SELF_TEST_SEL_MAX  (0x00000001U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDA_OSC_UV_SELF_TEST_SEL_MASK (0x00000400U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDA_OSC_UV_SELF_TEST_SEL_SHIFT (0x0000000AU)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDA_OSC_UV_SELF_TEST_SEL_RESETVAL (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDA_OSC_UV_SELF_TEST_SEL_MAX (0x00000001U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_RESERVED0_MASK            (0x00000800U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_RESERVED0_SHIFT           (0x0000000BU)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_RESERVED0_RESETVAL        (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_RESERVED0_MAX             (0x00000001U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDS_3P3V_UV_SELF_TEST_SEL_MASK (0x00001000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDS_3P3V_UV_SELF_TEST_SEL_SHIFT (0x0000000CU)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDS_3P3V_UV_SELF_TEST_SEL_RESETVAL (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDS_3P3V_UV_SELF_TEST_SEL_MAX (0x00000001U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_RESERVED1_MASK            (0x00002000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_RESERVED1_SHIFT           (0x0000000DU)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_RESERVED1_RESETVAL        (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_RESERVED1_MAX             (0x00000001U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_OV_IR_DROP_COMP_SEL_MASK (0x0000C000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_OV_IR_DROP_COMP_SEL_SHIFT (0x0000000EU)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_OV_IR_DROP_COMP_SEL_RESETVAL (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_OV_IR_DROP_COMP_SEL_MAX (0x00000003U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_OV_SR_SEL_MASK        (0x00030000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_OV_SR_SEL_SHIFT       (0x00000010U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_OV_SR_SEL_RESETVAL    (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_OV_SR_SEL_MAX         (0x00000003U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_VIOIN_UV_RSET_MASK_MASK   (0x00040000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VIOIN_UV_RSET_MASK_SHIFT  (0x00000012U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VIOIN_UV_RSET_MASK_RESETVAL (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VIOIN_UV_RSET_MASK_MAX    (0x00000001U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDA_OSC_UV_RSET_MASK_MASK (0x00080000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDA_OSC_UV_RSET_MASK_SHIFT (0x00000013U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDA_OSC_UV_RSET_MASK_RESETVAL (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDA_OSC_UV_RSET_MASK_MAX (0x00000001U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_UV_RSET_MASK_MASK     (0x00100000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_UV_RSET_MASK_SHIFT    (0x00000014U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_UV_RSET_MASK_RESETVAL (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_UV_RSET_MASK_MAX      (0x00000001U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_OV_RSET_MASK_MASK     (0x00200000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_OV_RSET_MASK_SHIFT    (0x00000015U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_OV_RSET_MASK_RESETVAL (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_OV_RSET_MASK_MAX      (0x00000001U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_IR_DROP_COMP_SEL_MASK (0x00C00000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_IR_DROP_COMP_SEL_SHIFT (0x00000016U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_IR_DROP_COMP_SEL_RESETVAL (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDD_IR_DROP_COMP_SEL_MAX  (0x00000003U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDS_3P3V_IR_DROP_COMP_SEL_MASK (0x03000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDS_3P3V_IR_DROP_COMP_SEL_SHIFT (0x00000018U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDS_3P3V_IR_DROP_COMP_SEL_RESETVAL (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDS_3P3V_IR_DROP_COMP_SEL_MAX (0x00000003U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDA_OSC_IR_DROP_COMP_SEL_MASK (0x0C000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDA_OSC_IR_DROP_COMP_SEL_SHIFT (0x0000001AU)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDA_OSC_IR_DROP_COMP_SEL_RESETVAL (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_VDDA_OSC_IR_DROP_COMP_SEL_MAX (0x00000003U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_REFSYS_SPARE_30_28_MASK   (0x70000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_REFSYS_SPARE_30_28_SHIFT  (0x0000001CU)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_REFSYS_SPARE_30_28_RESETVAL (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_REFSYS_SPARE_30_28_MAX    (0x00000007U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_ANALOGTEST_TMUX_ESD_CTRL_MASK (0x80000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_ANALOGTEST_TMUX_ESD_CTRL_SHIFT (0x0000001FU)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_ANALOGTEST_TMUX_ESD_CTRL_RESETVAL (0x00000000U)
#define ANA_REG_REFSYS_SPARE_REG_LOWV_ANALOGTEST_TMUX_ESD_CTRL_MAX (0x00000001U)

#define ANA_REG_REFSYS_SPARE_REG_LOWV_RESETVAL                  (0x00000000U)

/* GPADC_REG_R_REG0 */

#define GPADC_REG_R_REG0_DCBIST_MODE_MASK   (0x00000003U)
#define GPADC_REG_R_REG0_DCBIST_MODE_SHIFT  (0x00000000U)
#define GPADC_REG_R_REG0_DCBIST_MODE_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG0_DCBIST_MODE_MAX    (0x00000003U)

#define GPADC_REG_R_REG0_GPADC_FSM_CLK_ENABLE_MASK   (0x00000100U)
#define GPADC_REG_R_REG0_GPADC_FSM_CLK_ENABLE_SHIFT  (0x00000008U)
#define GPADC_REG_R_REG0_GPADC_FSM_CLK_ENABLE_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG0_GPADC_FSM_CLK_ENABLE_MAX    (0x00000001U)

#define GPADC_REG_R_REG0_GPADC2ADCBUF_PATH_EN_MASK   (0x00000E00U)
#define GPADC_REG_R_REG0_GPADC2ADCBUF_PATH_EN_SHIFT  (0x00000009U)
#define GPADC_REG_R_REG0_GPADC2ADCBUF_PATH_EN_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG0_GPADC2ADCBUF_PATH_EN_MAX    (0x00000007U)

#define GPADC_REG_R_REG0_GPADC_DEBUG_MODE_ENABLE_MASK   (0x00010000U)
#define GPADC_REG_R_REG0_GPADC_DEBUG_MODE_ENABLE_SHIFT  (0x00000010U)
#define GPADC_REG_R_REG0_GPADC_DEBUG_MODE_ENABLE_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG0_GPADC_DEBUG_MODE_ENABLE_MAX    (0x00000001U)

#define GPADC_REG_R_REG0_RESETVAL                          (0x00000000U)

/* GPADC_REG_R_REG1 */

#define GPADC_REG_R_REG1_GPADC_TRIGGER_MASK   (0x00000001U)
#define GPADC_REG_R_REG1_GPADC_TRIGGER_SHIFT  (0x00000000U)
#define GPADC_REG_R_REG1_GPADC_TRIGGER_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG1_GPADC_TRIGGER_MAX    (0x00000001U)

#define GPADC_REG_R_REG1_GPADC_INIT_MASK   (0x00000100U)
#define GPADC_REG_R_REG1_GPADC_INIT_SHIFT  (0x00000008U)
#define GPADC_REG_R_REG1_GPADC_INIT_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG1_GPADC_INIT_MAX    (0x00000001U)

#define GPADC_REG_R_REG1_GPADC_FSM_BYPASS_MASK   (0x00010000U)
#define GPADC_REG_R_REG1_GPADC_FSM_BYPASS_SHIFT  (0x00000010U)
#define GPADC_REG_R_REG1_GPADC_FSM_BYPASS_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG1_GPADC_FSM_BYPASS_MAX    (0x00000001U)

#define GPADC_REG_R_REG1_GPADC_START_BYP_VAL_MASK   (0x01000000U)
#define GPADC_REG_R_REG1_GPADC_START_BYP_VAL_SHIFT  (0x00000018U)
#define GPADC_REG_R_REG1_GPADC_START_BYP_VAL_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG1_GPADC_START_BYP_VAL_MAX    (0x00000001U)

#define GPADC_REG_R_REG1_RESETVAL                          (0x00000000U)

/* GPADC_REG_R_REG2 */

#define GPADC_REG_R_REG2_CONFIG_VALUE_IFM_MASK   (0xFFFFFFFFU)
#define GPADC_REG_R_REG2_CONFIG_VALUE_IFM_SHIFT  (0x00000000U)
#define GPADC_REG_R_REG2_CONFIG_VALUE_IFM_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG2_CONFIG_VALUE_IFM_MAX    (0xFFFFFFFFU)

#define GPADC_REG_R_REG2_RESETVAL                          (0x00000000U)


/* GPADC_REG_R_REG3 */

#define GPADC_REG_R_REG3_PARAM_VAL_IFM_MASK   (0x000000FFU)
#define GPADC_REG_R_REG3_PARAM_VAL_IFM_SHIFT  (0x00000000U)
#define GPADC_REG_R_REG3_PARAM_VAL_IFM_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG3_PARAM_VAL_IFM_MAX    (0x000000FFU)

#define GPADC_REG_R_REG3_COLLECT_SAMPLES_IFM_MASK   (0x0000FF00U)
#define GPADC_REG_R_REG3_COLLECT_SAMPLES_IFM_SHIFT  (0x00000008U)
#define GPADC_REG_R_REG3_COLLECT_SAMPLES_IFM_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG3_COLLECT_SAMPLES_IFM_MAX    (0x000000FFU)

#define GPADC_REG_R_REG3_SKIP_SAMPLES_IFM_MASK   (0x007F0000U)
#define GPADC_REG_R_REG3_SKIP_SAMPLES_IFM_SHIFT  (0x00000010U)
#define GPADC_REG_R_REG3_SKIP_SAMPLES_IFM_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG3_SKIP_SAMPLES_IFM_MAX    (0x0000007FU)

#define GPADC_REG_R_REG3_PARAM_IFM_MASK   (0x007FFFFFU)
#define GPADC_REG_R_REG3_PARAM_IFM_SHIFT  (0x00000000U)
#define GPADC_REG_R_REG3_PARAM_IFM_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG3_PARAM_IFM_MAX    (0x007FFFFFU)

#define GPADC_REG_R_REG3_RESETVAL                          (0x00000000U)

/* GPADC_REG_R_REG8 */

#define GPADC_REG_R_REG8_GPADC_CLK_DIV_MASK   (0x000000FFU)
#define GPADC_REG_R_REG8_GPADC_CLK_DIV_SHIFT  (0x00000000U)
#define GPADC_REG_R_REG8_GPADC_CLK_DIV_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG8_GPADC_CLK_DIV_MAX    (0x000000FFU)

#define GPADC_REG_R_REG8_GPADC_CLK_ENABLE_MASK   (0x00000100U)
#define GPADC_REG_R_REG8_GPADC_CLK_ENABLE_SHIFT  (0x00000008U)
#define GPADC_REG_R_REG8_GPADC_CLK_ENABLE_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG8_GPADC_CLK_ENABLE_MAX    (0x00000001U)

#define GPADC_REG_R_REG8_RESETVAL                          (0x00000000U)

/* GPADC_REG_R_REG14 */

#define GPADC_REG_R_REG14_SUM_IFM_MASK   (0x000FFFFFU)
#define GPADC_REG_R_REG14_SUM_IFM_SHIFT  (0x00000000U)
#define GPADC_REG_R_REG14_SUM_IFM_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG14_SUM_IFM_MAX    (0x000FFFFFU)

#define GPADC_REG_R_REG14_RESETVAL                          (0x00000000U)

/* GPADC_REG_R_REG15 */

#define GPADC_REG_R_REG15_MIN_GPADC_MASK   (0x000003FFU)
#define GPADC_REG_R_REG15_MIN_GPADC_SHIFT  (0x00000000U)
#define GPADC_REG_R_REG15_MIN_GPADC_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG15_MIN_GPADC_MAX    (0x000003FFU)

#define GPADC_REG_R_REG15_MAX_GPADC_MASK   (0x03FF0000U)
#define GPADC_REG_R_REG15_MAX_GPADC_SHIFT  (0x00000010U)
#define GPADC_REG_R_REG15_MAX_GPADC_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG15_MAX_GPADC_MAX    (0x000003FFU)

#define GPADC_REG_R_REG15_RESETVAL                          (0x00000000U)

/* GPADC_REG_R_REG17 */

#define GPADC_REG_R_REG17_GPADC_IFM_DONE_STATUS_MASK   (0x00000001U)
#define GPADC_REG_R_REG17_GPADC_IFM_DONE_STATUS_SHIFT  (0x00000000U)
#define GPADC_REG_R_REG17_GPADC_IFM_DONE_STATUS_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG17_GPADC_IFM_DONE_STATUS_MAX    (0x00000001U)

#define GPADC_REG_R_REG17_RESETVAL                          (0x00000000U)

/* GPADC_REG_R_REG18 */

#define GPADC_REG_R_REG18_GPADC_IFM_DONE_CLR_MASK   (0x00000001U)
#define GPADC_REG_R_REG18_GPADC_IFM_DONE_CLR_SHIFT  (0x00000000U)
#define GPADC_REG_R_REG18_GPADC_IFM_DONE_CLR_RESETVAL (0x00000000U)
#define GPADC_REG_R_REG18_GPADC_IFM_DONE_CLR_MAX    (0x00000001U)

#define GPADC_REG_R_REG18_RESETVAL                          (0x00000000U)

#endif
/*
 * END OF HW_ADC_H
 */

