#*******************************************************************************
#                                                                              *
# Copyright (c) 2022 Texas Instruments Incorporated - http://www.ti.com/       *
#                        ALL RIGHTS RESERVED                                   *
#                                                                              *
#*******************************************************************************

# File: mcal_component.mk
#       This file is component include make file of MCAL.
# List of variables set in this file and their purpose:
# <mod>_RELPATH        - This is the relative path of the module, typically from
#                        top-level directory of the package
# <mod>_PATH           - This is the absolute path of the module. It derives from
#                        absolute path of the top-level directory (set in env.mk)
#                        and relative path set above
# <mod>_INCLUDE        - This is the path that has interface header files of the
#                        module. This can be multiple directories (space separated)
# <mod>_PKG_LIST       - Names of the modules (and sub-modules) that are a part
#                        part of this module, including itself.
# <mod>_PLATFORM_DEPENDENCY - "yes": means the code for this module depends on
#                             platform and the compiled obj/lib has to be kept
#                             under <platform> directory
#                             "no" or "" or if this variable is not defined: means
#                             this module has no platform dependent code and hence
#                             the obj/libs are not kept under <platform> dir.
# <mod>_CORE_DEPENDENCY     - "yes": means the code for this module depends on
#                             core and the compiled obj/lib has to be kept
#                             under <core> directory
#                             "no" or "" or if this variable is not defined: means
#                             this module has no core dependent code and hence
#                             the obj/libs are not kept under <core> dir.
# <mod>_APP_STAGE_FILES     - List of source files that belongs to the module
#                             <mod>, but that needs to be compiled at application
#                             build stage (in the context of the app). This is
#                             primarily for link time configurations or if the
#                             source file is dependent on options/defines that are
#                             application dependent. This can be left blank or
#                             not defined at all, in which case, it means there
#                             no source files in the module <mod> that are required
#                             to be compiled in the application build stage.
#
ifeq ($(mcal_component_make_include), )

ifeq ($(PLATFORM),$(filter $(PLATFORM), am263))
DEFAULT_SOCLIST = am263
endif

############################
# device mcal package
# List of components included under mcal lib
# The components included here are built and will be part of mcal lib
# mcal HW files will be included in this order :
# 1. SOC specific HW file - $(mcal_PATH)/include/$(SOCFAMILY)/$(SOC)/hw
# 2. SOC Family specific HW file - $(mcal_PATH)/include/$(SOCFAMILY)/hw
# 3. Common HW file - $(mcal_PATH)/include/hw
############################

############################
# device mcal package
# List of components included under mcal lib
# The components included here are built and will be part of mcal lib
############################
mcal_mcal_LIB_LIST =

############################
# device mcal application utility packages
# List of application utilities under mcal
# The components included here are built and will be part of mcal app_lib
############################
mcal_mcal_APP_LIB_LIST =

############################
# device mcal examples
# List of examples under mcal
# All the tests mentioned in list are built when test target is called
# List below all examples for allowed values
############################
mcal_mcal_EXAMPLE_LIST =

############################
# Duplicate example list which should not be built with "all" (since this is
# duplicate -j option will build both and result in .obj correuption) but needs
# to be still exposed to top level makefile so that user can individually call
# them. Also these duplicate targets doesn't support package option and hence
# should not be included when packaging
############################
mcal_mcal_DUP_EXAMPLE_LIST =
mcal_mcal_LIB_LIST = mcu port gpt spi can wdg fls adc pwm icu ipc dma eth i2c uart

############################
# cdddma mcal lib
############################
dma_COMP_LIST = dma
dma_RELPATH = Dma
dma_PATH = $(mcal_PATH)/$(dma_RELPATH)
dma_PLATFORM_DEPENDENCY = yes
export dma_COMP_LIST
export dma_PLATFORM_DEPENDENCY
dma_PKG_LIST = dma
dma_INCLUDE = $(dma_PATH)/include
dma_SOCLIST = $(DEFAULT_SOCLIST)
export dma_SOCLIST

############################
# mcu mcal lib
############################
mcu_COMP_LIST = mcu
mcu_RELPATH = Mcu
mcu_PATH = $(mcal_PATH)/$(mcu_RELPATH)
mcu_PLATFORM_DEPENDENCY = yes
export mcu_COMP_LIST
export mcu_PLATFORM_DEPENDENCY
mcu_PKG_LIST = mcu
mcu_INCLUDE = $(mcu_PATH)/include
mcu_SOCLIST = $(DEFAULT_SOCLIST)
export mcu_SOCLIST

############################
# Dio mcal lib
############################
dio_COMP_LIST = dio
dio_RELPATH = dio
dio_PATH = $(mcal_PATH)/$(dio_RELPATH)
dio_PLATFORM_DEPENDENCY = yes
export dio_COMP_LIST
export dio_PLATFORM_DEPENDENCY
dio_PKG_LIST = dio
dio_INCLUDE = $(dio_PATH)/include
dio_SOCLIST = $(DEFAULT_SOCLIST)
export dio_SOCLIST

############################
# i2c mcal lib
############################
i2c_COMP_LIST = i2c
i2c_RELPATH = I2c
i2c_PATH = $(mcal_PATH)/$(i2c_RELPATH)
i2c_PLATFORM_DEPENDENCY = yes
export i2c_COMP_LIST
export i2c_PLATFORM_DEPENDENCY
i2c_PKG_LIST = i2c
i2c_INCLUDE = $(i2c_PATH)/include
i2c_SOCLIST = $(DEFAULT_SOCLIST)
export i2c_SOCLIST

############################
# port mcal lib
############################
port_COMP_LIST = port
port_RELPATH = Port
port_PATH = $(mcal_PATH)/$(port_RELPATH)
port_PLATFORM_DEPENDENCY = yes
export port_COMP_LIST
export port_PLATFORM_DEPENDENCY
port_PKG_LIST = port
port_INCLUDE = $(port_PATH)/include
port_SOCLIST = $(DEFAULT_SOCLIST)
export port_SOCLIST

############################
# gpt mcal lib
############################
gpt_COMP_LIST = gpt
gpt_RELPATH = Gpt
gpt_PATH = $(mcal_PATH)/$(gpt_RELPATH)
gpt_PLATFORM_DEPENDENCY = yes
export gpt_COMP_LIST
export gpt_PLATFORM_DEPENDENCY
gpt_PKG_LIST = gpt
gpt_INCLUDE = $(gpt_PATH)/include
gpt_SOCLIST = $(DEFAULT_SOCLIST)
export gpt_SOCLIST

############################
# dio mcal lib
############################
dio_COMP_LIST = dio
dio_RELPATH = Dio
dio_PATH = $(mcal_PATH)/$(dio_RELPATH)
dio_PLATFORM_DEPENDENCY = yes
export dio_COMP_LIST
export dio_PLATFORM_DEPENDENCY
dio_PKG_LIST = dio
dio_INCLUDE = $(dio_PATH)/include
dio_SOCLIST = $(DEFAULT_SOCLIST)
export dio_SOCLIST

############################
# wdg mcal lib
############################
wdg_COMP_LIST = wdg
wdg_RELPATH = Wdg
wdg_PATH = $(mcal_PATH)/$(wdg_RELPATH)
wdg_PLATFORM_DEPENDENCY = yes
export wdg_COMP_LIST
export wdg_PLATFORM_DEPENDENCY
wdg_PKG_LIST = wdg
wdg_INCLUDE = $(wdg_PATH)/include
wdg_SOCLIST = $(DEFAULT_SOCLIST)
export wdg_SOCLIST

############################
# spi mcal lib
############################
spi_COMP_LIST = spi
spi_RELPATH = Spi
spi_PATH = $(mcal_PATH)/$(spi_RELPATH)
spi_PLATFORM_DEPENDENCY = yes
export spi_COMP_LIST
export spi_PLATFORM_DEPENDENCY
spi_PKG_LIST = spi
spi_INCLUDE = $(spi_PATH)/include
spi_SOCLIST = $(DEFAULT_SOCLIST)
export spi_SOCLIST

############################
# can mcal lib
############################
can_COMP_LIST = can
can_RELPATH = Can
can_PATH = $(mcal_PATH)/$(can_RELPATH)
can_PLATFORM_DEPENDENCY = yes
export can_COMP_LIST
export can_PLATFORM_DEPENDENCY
can_PKG_LIST = can
can_INCLUDE = $(can_PATH)/include
can_SOCLIST = $(DEFAULT_SOCLIST)
export can_SOCLIST

############################
# fls mcal lib
############################
fls_COMP_LIST = fls
fls_RELPATH = Fls
fls_PATH = $(mcal_PATH)/$(fls_RELPATH)
fls_PLATFORM_DEPENDENCY = yes
export fls_COMP_LIST
export fls_PLATFORM_DEPENDENCY
fls_PKG_LIST = fls
fls_INCLUDE = $(fls_PATH)/include
fls_SOCLIST = $(DEFAULT_SOCLIST)
export fls_SOCLIST

############################
# pwm mcal lib
############################
pwm_COMP_LIST = pwm
pwm_RELPATH = Pwm
pwm_PATH = $(mcal_PATH)/$(pwm_RELPATH)
pwm_PLATFORM_DEPENDENCY = yes
export pwm_COMP_LIST
export pwm_PLATFORM_DEPENDENCY
pwm_PKG_LIST = pwm
pwm_INCLUDE = $(pwm_PATH)/include
pwm_SOCLIST = $(DEFAULT_SOCLIST)
export pwm_SOCLIST

############################
# icu mcal lib
############################
icu_COMP_LIST = icu
icu_RELPATH = Icu
icu_PATH = $(mcal_PATH)/$(icu_RELPATH)
icu_PLATFORM_DEPENDENCY = yes
export icu_COMP_LIST
export icu_PLATFORM_DEPENDENCY
icu_PKG_LIST = icu
icu_INCLUDE = $(icu_PATH)/include
icu_SOCLIST = $(DEFAULT_SOCLIST)
export icu_SOCLIST

############################
# eth mcal lib
############################
eth_COMP_LIST = eth
eth_RELPATH = Eth
eth_PATH = $(mcal_PATH)/$(eth_RELPATH)
eth_PLATFORM_DEPENDENCY = yes
export eth_COMP_LIST
export eth_PLATFORM_DEPENDENCY
eth_PKG_LIST = eth
eth_INCLUDE = $(eth_PATH)/include
eth_SOCLIST = $(DEFAULT_SOCLIST)
export eth_SOCLIST

############################
# ethtrcv mcal lib
############################
ethtrcv_COMP_LIST = ethtrcv
ethtrcv_RELPATH = EthTrcv
ethtrcv_PATH = $(mcal_PATH)/$(ethtrcv_RELPATH)
ethtrcv_PLATFORM_DEPENDENCY = yes
export ethtrcv_COMP_LIST
export ethtrcv_PLATFORM_DEPENDENCY
ethtrcv_PKG_LIST = ethtrcv
ethtrcv_INCLUDE = $(ethtrcv_PATH)/include
ethtrcv_SOCLIST = $(DEFAULT_SOCLIST)
export ethtrcv_SOCLIST

############################
# adc mcal lib
############################
adc_COMP_LIST = adc
adc_RELPATH = Adc
adc_PATH = $(mcal_PATH)/$(adc_RELPATH)
adc_PLATFORM_DEPENDENCY = yes
export adc_COMP_LIST
export adc_PLATFORM_DEPENDENCY
adc_PKG_LIST = adc
adc_INCLUDE = $(adc_PATH)/include
adc_SOCLIST = $(DEFAULT_SOCLIST)
export adc_SOCLIST

############################
# ipc mcal lib
############################
ipc_COMP_LIST = ipc
ipc_RELPATH = Ipc
ipc_PATH = $(mcal_PATH)/$(ipc_RELPATH)
ipc_PLATFORM_DEPENDENCY = yes
export ipc_COMP_LIST
export ipc_PLATFORM_DEPENDENCY
ipc_PKG_LIST = ipc
ipc_INCLUDE = $(ipc_PATH)/include
ipc_SOCLIST = $(DEFAULT_SOCLIST)
export ipc_SOCLIST

############################
# uart mcal lib
############################
uart_COMP_LIST = uart
uart_RELPATH = Uart
uart_PATH = $(mcal_PATH)/$(uart_RELPATH)
uart_PLATFORM_DEPENDENCY = yes
export uart_COMP_LIST
export uart_PLATFORM_DEPENDENCY
uart_PKG_LIST = uart
uart_INCLUDE = $(uart_PATH)/include
uart_SOCLIST = $(DEFAULT_SOCLIST)
export uart_SOCLIST

############################
#device mcal examples
# List of examples under mcal
# All the tests mentioned in list are built when test target is called
# List below all examples for allowed values
############################
mcal_mcal_EXAMPLE_LIST = mcu_app gpt_app mcspi_app can_app app_utils port_app dio_app wdg_app fls_app eth_app adc_app pwm_app icu_app ipc_notify_app ipc_rpmsg_app i2c_app uart_echo_dma_app
##############################
mcu_app_RELPATH = examples/Mcu
mcu_app_PATH = $(mcal_PATH)/$(mcu_app_RELPATH)
mcu_app_PLATFORM_DEPENDENCY = yes
mcu_app_SOCLIST = $(DEFAULT_SOCLIST)
export mcu_app_SOCLIST
export mcu_app_PLATFORM_DEPENDENCY

pwm_app_RELPATH = examples/Pwm
pwm_app_PATH = $(mcal_PATH)/$(pwm_app_RELPATH)
pwm_app_PLATFORM_DEPENDENCY = yes
pwm_app_SOCLIST = $(DEFAULT_SOCLIST)
export pwm_app_SOCLIST
export pwm_app_PLATFORM_DEPENDENCY

gpt_app_RELPATH = examples/Gpt
gpt_app_PATH = $(mcal_PATH)/$(gpt_app_RELPATH)
gpt_app_PLATFORM_DEPENDENCY = yes
gpt_app_SOCLIST = $(DEFAULT_SOCLIST)
export gpt_app_SOCLIST
export gpt_app_PLATFORM_DEPENDENCY

i2c_app_RELPATH = examples/I2c
i2c_app_PATH = $(mcal_PATH)/$(i2c_app_RELPATH)
i2c_app_PLATFORM_DEPENDENCY = yes
i2c_app_SOCLIST = $(DEFAULT_SOCLIST)
export i2c_app_SOCLIST
export i2c_app_PLATFORM_DEPENDENCY

dio_app_RELPATH = examples/Dio
dio_app_PATH = $(mcal_PATH)/$(dio_app_RELPATH)
dio_app_PLATFORM_DEPENDENCY = yes
dio_app_SOCLIST = $(DEFAULT_SOCLIST)
export dio_app_SOCLIST
export dio_app_PLATFORM_DEPENDENCY

wdg_app_RELPATH = examples/Wdg
wdg_app_PATH = $(mcal_PATH)/$(wdg_app_RELPATH)
wdg_app_PLATFORM_DEPENDENCY = yes
wdg_app_SOCLIST = $(DEFAULT_SOCLIST)
export wdg_app_SOCLIST
export wdg_app_PLATFORM_DEPENDENCY

fls_app_RELPATH = examples/Fls
fls_app_PATH = $(mcal_PATH)/$(fls_app_RELPATH)
fls_app_PLATFORM_DEPENDENCY = yes
fls_app_SOCLIST = $(DEFAULT_SOCLIST)
export fls_app_SOCLIST
export fls_app_PLATFORM_DEPENDENCY

mcspi_app_RELPATH = examples/Spi/mcspi_app
mcspi_app_PATH = $(mcal_PATH)/$(mcspi_app_RELPATH)
mcspi_app_PLATFORM_DEPENDENCY = yes
mcspi_app_SOCLIST = $(DEFAULT_SOCLIST)
export mcspi_app_SOCLIST
export mcspi_app_PLATFORM_DEPENDENCY

qspi_flash_app_RELPATH = examples/Spi/qspi_flash_app
qspi_flash_app_PATH = $(mcal_PATH)/$(qspi_flash_app_RELPATH)
qspi_flash_app_PLATFORM_DEPENDENCY = yes
qspi_flash_app_SOCLIST = $(DEFAULT_SOCLIST)
export qspi_flash_app_SOCLIST
export qspi_flash_app_PLATFORM_DEPENDENCY
mibspi_app_RELPATH = examples/Spi/mibspi_app
mibspi_app_PATH = $(mcal_PATH)/$(mibspi_app_RELPATH)
mibspi_app_PLATFORM_DEPENDENCY = yes
mibspi_app_SOCLIST = $(DEFAULT_SOCLIST)
export mibspi_app_SOCLIST
export mibspi_app_PLATFORM_DEPENDENCY

can_app_RELPATH = examples/Can
can_app_PATH = $(mcal_PATH)/$(can_app_RELPATH)
can_app_PLATFORM_DEPENDENCY = yes
can_app_SOCLIST = $(DEFAULT_SOCLIST)
export can_app_SOCLIST
export can_app_PLATFORM_DEPENDENCY

port_app_RELPATH = examples/Port
port_app_PATH = $(mcal_PATH)/$(port_app_RELPATH)
port_app_PLATFORM_DEPENDENCY = yes
port_app_SOCLIST = $(DEFAULT_SOCLIST)
export port_app_SOCLIST
export port_app_PLATFORM_DEPENDENCY

dio_app_RELPATH = examples/Dio
dio_app_PATH = $(mcal_PATH)/$(dio_app_RELPATH)
dio_app_PLATFORM_DEPENDENCY = yes
dio_app_SOCLIST = $(DEFAULT_SOCLIST)
export dio_app_SOCLIST
export dio_app_PLATFORM_DEPENDENCY

icu_app_RELPATH = examples/Icu
icu_app_PATH = $(mcal_PATH)/$(icu_app_RELPATH)
icu_app_PLATFORM_DEPENDENCY = yes
icu_app_SOCLIST = $(DEFAULT_SOCLIST)
export icu_app_SOCLIST
export icu_app_PLATFORM_DEPENDENCY

eth_app_RELPATH = examples/Eth/eth_app
eth_app_PATH = $(mcal_PATH)/$(eth_app_RELPATH)
eth_app_PLATFORM_DEPENDENCY = yes
eth_app_SOCLIST = $(DEFAULT_SOCLIST)
export eth_app_SOCLIST
export eth_app_PLATFORM_DEPENDENCY

adc_app_RELPATH = examples/Adc
adc_app_PATH = $(mcal_PATH)/$(adc_app_RELPATH)
adc_app_PLATFORM_DEPENDENCY = yes
adc_app_SOCLIST = $(DEFAULT_SOCLIST)
export adc_app_SOCLIST
export adc_app_PLATFORM_DEPENDENCY

uart_echo_app_RELPATH = examples/Uart/uart_echo_app
uart_echo_app_PATH = $(mcal_PATH)/$(uart_echo_app_RELPATH)
uart_echo_app_PLATFORM_DEPENDENCY = yes
uart_echo_app_SOCLIST = $(DEFAULT_SOCLIST)
export uart_echo_app_SOCLIST
export uart_echo_app_PLATFORM_DEPENDENCY

uart_echo_dma_app_RELPATH = examples/Uart/uart_echo_dma_app
uart_echo_dma_app_PATH = $(mcal_PATH)/$(uart_echo_dma_app_RELPATH)
uart_echo_dma_app_PLATFORM_DEPENDENCY = yes
uart_echo_dma_app_SOCLIST = $(DEFAULT_SOCLIST)
export uart_echo_dma_app_SOCLIST
export uart_echo_dma_app_PLATFORM_DEPENDENCY

ipc_notify_app_RELPATH = examples/Ipc/Ipc_app_notify
ipc_notify_app_PATH = $(mcal_PATH)/$(ipc_notify_app_RELPATH)
ipc_notify_app_PLATFORM_DEPENDENCY = yes
ipc_notify_app_SOCLIST = $(DEFAULT_SOCLIST)
export ipc_notify_app_SOCLIST
export ipc_notify_app_PLATFORM_DEPENDENCY

ipc_rpmsg_app_RELPATH = examples/Ipc/Ipc_app_rpmsg
ipc_rpmsg_app_PATH = $(mcal_PATH)/$(ipc_rpmsg_app_RELPATH)
ipc_rpmsg_app_PLATFORM_DEPENDENCY = yes
ipc_rpmsg_app_SOCLIST = $(DEFAULT_SOCLIST)
export ipc_rpmsg_app_SOCLIST
export ipc_rpmsg_app_PLATFORM_DEPENDENCY

##################################

app_utils_COMP_LIST = app_utils
app_utils_RELPATH = examples/Utils
app_utils_PATH = $(mcal_PATH)/$(app_utils_RELPATH)
app_utils_PLATFORM_DEPENDENCY = yes
app_utils_SOCLIST = $(DEFAULT_SOCLIST)
export app_utils_SOCLIST
export app_utils_PLATFORM_DEPENDENCY
export app_utils_COMP_LIST
app_utils_PKG_LIST = app_utils
app_utils_INCLUDE = $(app_utils_PATH)
###$(app_utils_PATH)/Intc/$(ARCH)

export mcal_mcal_drv_LIB_LIST
export mcal_mcal_drv_EXAMPLE_LIST
export mcal_mcal_dup_drv_EXAMPLE_LIST

mcal_PKG_LIST_ALL = $(mcal_mcal_EXAMPLE_LIST) $(mcal_mcal_drv_LIB_LIST)

mcal_component_make_include := 1
endif

# Nothing beyond this point