
/* XDCtools Header files */
#include <xdc/std.h>
#include <xdc/runtime/System.h>

/* BIOS Header files */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
#include <stdbool.h>

/* TI-RTOS Header files */
#include <ti/drivers/GPIO.h>
#include <driverlib/gpio.h>
#include <driverlib/uart.h>
#include <driverlib/eeprom.h>
#include <driverlib/sysctl.h>
#include <driverlib/adc.h>
#include <ti/drivers/UART.h>
#include <ti/sysbios/knl/Semaphore.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/knl/Swi.h>

// Example/Board Header files
#include "Board.h"

#include <stdint.h>

#include <inc/hw_memmap.h>

#include "XFlag.h"
#include "Xvariable.h"
#include "string.h"
#include "Macro.h"
#include "Inputs.h"
#include "Outputs.h"


void ADC_init();
void ADC_trigger();
void Read_adc();

unsigned short int min_data = 2800, max_data = 2800;

unsigned short int pulse_switch, sensor_old_val;

void heartBeatFxn(UArg arg0, UArg arg1)
{
    //while (1) {
    //    Task_sleep((unsigned int)arg0);
   //     GPIO_toggle(Board_LED0);
   // }
}

void ADC_init()
{
    SysCtlPeripheralEnable(SYSCTL_PERIPH_ADC0);
    SysCtlDelay(500);
    ADCClockConfigSet(ADC0_BASE, ADC_CLOCK_SRC_PLL | ADC_CLOCK_RATE_FULL, 24);
    GPIOPinTypeADC(GPIO_PORTE_BASE,GPIO_PIN_2);
    GPIOPinTypeADC(GPIO_PORTE_BASE,GPIO_PIN_3);

    ADCSequenceConfigure(ADC0_BASE,0,ADC_TRIGGER_PROCESSOR,0);  //CONFIGURE THE ADC SAMPLE SEQUENCER THAT U WANA USE
    ADCHardwareOversampleConfigure(ADC0_BASE,16);
    ADCSequenceStepConfigure(ADC0_BASE,0,0, ADC_CTL_CH0 | ADC_CTL_IE | ADC_CTL_END);      //CONFIGURE THE STEPS OF SAMPLE SEQUENCER

    //ADCSequenceStepConfigure(ADC0_BASE,0,1, ADC_CTL_CH1 );      //

    //ADCSequenceStepConfigure(ADC0_BASE,0,1, ADC_CTL_CH1| ADC_CTL_IE | ADC_CTL_SHOLD_64 | ADC_CTL_END);

    ADCSequenceEnable(ADC0_BASE, 0);

    ADCProcessorTrigger(ADC0_BASE, ADC_CTL_CH0);

    while(!ADCIntStatus(ADC0_BASE, 0, false))
    {
    }

    ADCIntClear(ADC0_BASE,0);
    ADCSequenceDataGet(ADC0_BASE,0,adc_value);
}

void ADC_trigger()
{
    ADCProcessorTrigger(ADC0_BASE, ADC_CTL_CH0);
    while(!ADCIntStatus(ADC0_BASE, 0, false))
    {
    }

    ADCIntClear(ADC0_BASE,0);
    ADCSequenceDataGet(ADC0_BASE,0,adc_value);

 /*   if(adc_value[0] < min_data && adc_value[0] > 500)
    {
        min_data = adc_value[0];
    }
    if(adc_value[0] > max_data && adc_value[0] < 3100)
    {
        max_data = adc_value[0];
    }
*/
    Sensor_volt_avg[Sensor_volt_avg_count++] = adc_value[0];
    if(Sensor_volt_avg_count > 4)
    {
        sensor_old_val = 0;
        for(pulse_switch = 0; pulse_switch < Sensor_volt_avg_count; pulse_switch++)
        {
            sensor_old_val += Sensor_volt_avg[pulse_switch];
        }
        sensor_old_val /= Sensor_volt_avg_count;
        Sensor_volt_avg_count = 0;
        memset(&Sensor_volt_avg[0], 0, 20);

      //  Sensor_value_count[Motor_pulse_count++] = sensor_old_val;//adc_value[0];
        distance_check = (float)(sensor_old_val * 0.7074627);
    }
}

void Read_adc()
{
    unsigned char data_acq;
    Sensor_volt_avg_count= 0;

    for(data_acq = 0; data_acq < 5; data_acq++)
    {
        ADCProcessorTrigger(ADC0_BASE, ADC_CTL_CH0);
        while(!ADCIntStatus(ADC0_BASE, 0, false))
        {
        }

        ADCIntClear(ADC0_BASE,0);
        ADCSequenceDataGet(ADC0_BASE,0,adc_value);

        Sensor_volt_avg[Sensor_volt_avg_count++] = adc_value[0];
        if(Sensor_volt_avg_count > 4)
        {
            sensor_old_val = 0;
            for(pulse_switch = 0; pulse_switch < Sensor_volt_avg_count; pulse_switch++)
            {
                sensor_old_val += Sensor_volt_avg[pulse_switch];
            }
            sensor_old_val /= Sensor_volt_avg_count;
            Sensor_volt_avg_count = 0;
            memset(&Sensor_volt_avg[0], 0, 20);

          //  Sensor_value_count[Motor_pulse_count++] = sensor_old_val;//adc_value[0];
            distance_check = (float)(sensor_old_val * 0.7074627);
        }
    }
}




