/***********************************************************************************************************************************

    Module name             =   Error_logic.c
    Created By              =   Yuvaraj
    Created On              =   18.05.2023
    Formula used            =
    Interrupts used         =
    Description             =

    Modified By             =
    Modified On             =
    Reason for modification =

    Special function        =
*****************************************************************************************************************************************/

#include <stdbool.h>
#include <stdint.h>
//#include "inc/tm4c123gh6pm.h"

#include "inc/hw_memmap.h"
#include "driverlib/gpio.h"
#include "driverlib/interrupt.h"
#include "driverlib/pin_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/timer.h"
#include "driverlib/uart.h"
#include "driverlib/eeprom.h"


#include "Xvariable.h"
#include "Xflag.h"
#include "string.h"
#include "math.h"
#include "Macro.h"
#include "EEPROM.h"


extern void output_EV_off();

void error_logic(unsigned char);

void error_logic(unsigned char position)
{
    timer.bit.load_seq_start_flag = 0;

    Output_off.disable = 0x0FFF;
    output_EV_off();

    Wafer_record_start_flag = 0;
    Wafer_recording_flag = 0;
    error.status = 0;
    align_seq_no = 32;
    start_align_proc_flag = 0;
    mc_status.Machine_busy_status = '0';
    mc_status.Placement = '0';

    switch(position)
    {
        case 0:
            error.bit.Vaccum_error = 1;
            error.bit.machine_error = 1;
            break;

        case 1:

            error.bit.Motor_pulse_count_error = 1;
            error.bit.machine_error = 1;
            break;

        case 2:

            error.bit.Notch_find_error = 1;
            error.bit.machine_error = 1;
            break;

        case 3:
            error.bit.Align_pulse_count_error = 1;
            error.bit.machine_error = 1;
            break;

        case 4:

            break;

        default:

            break;
    }

    if(error.bit.machine_error)
    {
        error.bit.error_to_com_flag = 1;
    }

}
