
#include <string.h>
#include <stdbool.h>

#include <xdc/std.h>
#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/drivers/GPIO.h>
#include <driverlib/gpio.h>

/* NDK BSD support */
#include <sys/socket.h>
#include <stdint.h>
#include <inc/hw_memmap.h>


#include "Board.h"
#include "XFlag.h"
#include "Xvariable.h"
#include "Macro.h"
#include "Ethernet_data.h"

extern void send_to_client_6000(unsigned char *,unsigned int);

void ethernet_com_port(unsigned int);
void Port_no_check(unsigned char);
void reply_packet_prepare();
int calculate_crc(unsigned short int);
void Response_data();
void reply_error_packet_prepare();
void Transmit_data(unsigned short int);
void error_packet_prepare(unsigned char);

unsigned char valid_data_recvd;
unsigned char CRC_recvd[2];
unsigned char packet_check_count, packet_id, valid_data, packet_data;
unsigned char ET_RX_COMPLETE_FLAG,CRC, REC_CRC;
unsigned short int packet_length,temp,var,inc,crc_match_flag,test_var;
unsigned char server_led;
unsigned char ET_looP_count;

// ETHERNET CRC
int calculate_crc(unsigned short int byte_length)
{
    unsigned int Calc_CRC = 0;
    unsigned char loop_var;

    for(loop_var = 1; loop_var < byte_length ; loop_var++)
    {
       Calc_CRC += ET_TX_6000[loop_var];
    }

    Calc_CRC %= 256;

    dummy.ch_area[1] = (Calc_CRC % 16);

    if(dummy.ch_area[1] > 9)
       dummy.ch_area[1] += 55;
    else
       dummy.ch_area[1] |= 0x30;

    dummy.ch_area[0] = (Calc_CRC / 16);

    if(dummy.ch_area[0] > 9)
       dummy.ch_area[0] += 55;
    else
       dummy.ch_area[0] |= 0x30;

 //   ET_TX_6000[valid_data++] = dummy.ch_area[0];
  //  ET_TX_6000[valid_data++] = dummy.ch_area[1];

    return dummy.int_area[0];

}


void CRC_Tcp()
{
    unsigned int Calc_CRC = 0;
    unsigned char loop_var;

    for(loop_var = 1; loop_var < packet_length; loop_var++)
    {
        Calc_CRC += ET_RX_6000[loop_var];
    }

    Calc_CRC %= 256;

    dummy.ch_area[1] = (Calc_CRC % 16);

    if(dummy.ch_area[1] > 9)
        dummy.ch_area[1] += 55;
    else
        dummy.ch_area[1] |= 0x30;

    dummy.ch_area[0] = (Calc_CRC / 16);

    if(dummy.ch_area[0] > 9)
        dummy.ch_area[0] += 55;
    else
        dummy.ch_area[0] |= 0x30;

    valid_data_recvd = 1;
/*    if((dummy.ch_area[0] == CRC_recvd[0]) && (dummy.ch_area[1] == CRC_recvd[1]))
        valid_data_recvd = 1;
    else
    {
        ET_TX_6000[0] = '<';
        ET_TX_6000[1] = Tx_id[0];
        ET_TX_6000[2] = Tx_id[1];
        ET_TX_6000[3] = Tx_id[2];
        ET_TX_6000[4] = ':';
        ET_TX_6000[5] = 'C';
        ET_TX_6000[6] = 'h';
        ET_TX_6000[7] = 'e';
        ET_TX_6000[8] = 'c';
        ET_TX_6000[9] = 'k';
        ET_TX_6000[10] = 's';
        ET_TX_6000[11] = 'u';
        ET_TX_6000[12] = 'm';
        ET_TX_6000[13] = 'E';
        ET_TX_6000[14] = 'r';
        ET_TX_6000[15] = 'r';
        ET_TX_6000[16] = 'o';
        ET_TX_6000[17] = 'r';
        ET_TX_6000[18] = '>';

        ET_TX_6000[19] = dummy.ch_area[0];
        ET_TX_6000[20] = dummy.ch_area[1];

        ET_TX_6000[21] = 13;
        ET_TX_6000[22] = 10;

        send_to_client_6000(ET_TX_6000,23);
    }*/
}

void check_receievd_packet()
{
    unsigned char check_count;

    valid_data_recvd = 0;

    if(ET_RX_6000[0] == '<' && ET_RX_6000[4] == ':')
    {
        for(check_count = 1; check_count < 100; check_count++)
        {
            if(ET_RX_6000[check_count] == '>' || ET_RX_6000[check_count] == ',')
            {
                packet_length = check_count;
                CRC_recvd[0] = (ET_RX_6000[check_count + 1]);// & 0x0F);
                CRC_recvd[1] = (ET_RX_6000[check_count + 2]);// & 0x0F);

                CRC_Tcp();
                break;
            }

        }
    }
}

//*****************************************************************************
// HTTP Application Callback Function
//*****************************************************************************
void ethernet_com_port(unsigned int Client_id)
{
    if(Wafer_recording_flag)
        return;

    if(ET_RX_6000[0] == '<' && ET_RX_6000[4] == ':')     // 0X3C is <
    {
        Tx_id[0] = ET_RX_6000[1];
        Tx_id[1] = ET_RX_6000[2];
        Tx_id[2] = ET_RX_6000[3];
        check_receievd_packet();

        PLC_port6000_timeout = 0;
        port6000_timeout_count =  0;
        TCPIP.bit.PLC_port6000_closed = 0;

        if(valid_data_recvd == 1)
        {
            packet_id = 0;
            valid_data = 0;


            for(packet_check_count = 5; packet_check_count <= packet_length; packet_check_count++)
            {
                packet_data = packet_data_recvd[packet_id][packet_check_count - 5];
                if(packet_data == ET_RX_6000[packet_check_count] || packet_data == ',')
                {
                    valid_data++;
                }
                else
                {
                    packet_id++;
                    valid_data = 0;
                    packet_check_count = 4;
                }

                if(packet_id > 30)
                {
                    timer.bit.TCP_comment_invalid = 1;
                    break;
                }
            }

            if(valid_data > 1)
                valid_data--;

            if(valid_data == (packet_length - 5))
            {
                reply_packet_prepare();
            }
            else if(valid_data == (packet_length - 5)  && packet_id == 2)
            {
                reply_packet_prepare();
            }
            else
            {
                reply_error_packet_prepare();
            }
        }
    }

    memset(&ET_RX_6000[0],0,60);
}


void reply_packet_prepare()
{
    memset(&ET_TX_6000[0],0,60);

    if(timer.bit.TCP_comment_invalid == 1)
    {
        reply_error_packet_prepare();
        timer.bit.TCP_comment_invalid = 0;
    }
    else
    {
        ET_TX_6000[0] = '<';
        ET_TX_6000[1] = Tx_id[0];
        ET_TX_6000[2] = Tx_id[1];
        ET_TX_6000[3] = Tx_id[2];
        ET_TX_6000[4] = ':';
        ET_TX_6000[5] = 'A';
        ET_TX_6000[6] = 'c';
        ET_TX_6000[7] = 'k';
        ET_TX_6000[8] = ',';

        memcpy(&ET_TX_6000[9], &ET_RX_6000[5], valid_data);

        valid_data += 9;
        if(packet_id == 2)
            memcpy(&ET_TX_6000[15], &ET_TX_6000[16], (valid_data - 10));

         if(valid_data > 7)
             Transmit_data(valid_data);

        timer.bit.TCP_response_flag = 1;
        status_request_mem = 0;

        if(error.bit.error_to_com_flag)
        {
            if(error.bit.CDA_error)
            {
                error_packet_prepare(1);
            }
            else if(error.bit.Vaccum_error)
            {
                error_packet_prepare(1);
            }
            else if(error.bit.Motor_pulse_count_error)
            {
                error_packet_prepare(2);
            }
            else if(error.bit.Notch_find_error)
            {
                error_packet_prepare(3);
            }
            else if(error.bit.Align_pulse_count_error)
            {
                error_packet_prepare(4);
            }
            error.bit.error_to_com_flag = 0;
        }
        else if(pwr_on_flag == 0)
        {
            error_packet_prepare(5);
        }
        else
        {
            switch(packet_id)
            {
                case 2:                 //Status
                    status_request = 1;
                    Response_data();
                    break;

                case 3:                 //Home command
                    status_request = 2;
                    break;

                case 4:                 //Align command
                    status_request = 3;
                    memcpy(&ET_RX_PROC_DATA[0], &ET_RX_6000[11], 8);
                    break;

                case 5:                 //Vaccum hold command
                    status_request = 4;
                    break;

                case 6:                 //Vaccum release command
                    status_request = 5;
                   break;

                case 7:                 //Read offset command
                    status_request = 6;
                    Response_data();
                    break;

                case 8:                 //Wafer dia command
                    status_request = 7;
                    memcpy(&ET_RX_PROC_DATA[0], &ET_RX_6000[14], 4);
                    break;

                case 9:                 //Wafer type command
                    status_request = 8;
                    memcpy(&ET_RX_PROC_DATA[0], &ET_RX_6000[15], 3);

                   break;

                case 10:                 //Lift pin command
                    status_request = 9;
                    memcpy(&ET_RX_PROC_DATA[0], &ET_RX_6000[13], 3);
                    break;

                case 11:                 //Presalign command
                    status_request = 10;
                    memcpy(&ET_RX_PROC_DATA[0], &ET_RX_6000[15], 3);

                    break;

                case 25:                 // IP address command
                    status_request = 0;
                    status_request_mem = 0;
                    status_request++;

                    memset(&IP_address[0],0,4);
                    ET_RX_6000[18] &= ~0x30;
                    ET_RX_6000[19] &= ~0x30;
                    ET_RX_6000[20] &= ~0x30;
                    IP_address[0] = (ET_RX_6000[18] * 100) + (ET_RX_6000[19] * 10) + ET_RX_6000[20];

                    dummy.ln_area = 0;

                    for(packet_check_count = 1; packet_check_count < 14; packet_check_count++)
                    {
                        if((ET_RX_6000[20 + packet_check_count] == '.') || (ET_RX_6000[20 + packet_check_count] == '>'))
                        {
                            status_request_mem++;
                        }
                        else
                        {
                            dummy.ch_area[status_request_mem]++;
                        }
                    }

                    if(dummy.ch_area[1] > 1)
                    {
                        ET_looP_count = dummy.ch_area[1] + 21;
                        status_request_mem = 0;
                        for(packet_check_count = ET_looP_count; status_request_mem < dummy.ch_area[1]; packet_check_count--)
                        {
                            if(status_request_mem == 0)
                                IP_address[1] = (ET_RX_6000[packet_check_count] &~0x30);
                            else if(status_request_mem == 1)
                                IP_address[1] += ((ET_RX_6000[packet_check_count] &~0x30) * 10);
                            else if(status_request_mem == 2)
                                IP_address[1] += ((ET_RX_6000[packet_check_count] &~0x30) * 100);

                            status_request_mem++;
                        }

                    }
                    if(dummy.ch_area[2] > 0)
                    {
                        ET_looP_count = dummy.ch_area[1] + 22 + dummy.ch_area[2];
                        status_request_mem = 0;
                        for(packet_check_count = ET_looP_count; status_request_mem < dummy.ch_area[2]; packet_check_count--)
                        {
                            if(status_request_mem == 0)
                                IP_address[2] = (ET_RX_6000[packet_check_count] &~0x30);
                            else if(status_request_mem == 1)
                                IP_address[2] += ((ET_RX_6000[packet_check_count] &~0x30) * 10);
                            else if(status_request_mem == 2)
                                IP_address[2] += ((ET_RX_6000[packet_check_count] &~0x30) * 100);

                            status_request_mem++;
                        }

                    }

                    if(dummy.ch_area[3] > 0)
                    {
                        status_request_mem = 0;
                        ET_looP_count = dummy.ch_area[1] + 23 + dummy.ch_area[2] + dummy.ch_area[3];
                        for(packet_check_count = ET_looP_count; status_request_mem < dummy.ch_area[3]; packet_check_count--)
                        {
                            if(status_request_mem == 0)
                                IP_address[3] = (ET_RX_6000[packet_check_count] &~0x30);
                            else if(status_request_mem == 1)
                                IP_address[3] += ((ET_RX_6000[packet_check_count] &~0x30) * 10);
                            else if(status_request_mem == 2)
                                IP_address[3] += ((ET_RX_6000[packet_check_count] &~0x30) * 100);

                            status_request_mem++;
                        }

                    }

                    if(IP_address[0] > 100 && IP_address[0] < 200)
                    {
                        if(IP_address[1] > 10 && IP_address[1] < 250)
                        {
                            if(IP_address[2] > 0 && IP_address[0] < 255)
                            {
                                if(IP_address[3] > 0)
                                {
                                    timer.bit.ip_save_flag = 1;
                                    timer.bit.ip_readed_flag = 0;
                                    Reply_response_data = 27;
                                    memcpy(&Mem_Tx_id[0], &Tx_id[0],3);
                                }
                            }
                        }
                    }
                    status_request = 27;
                    break;

                default:
                    break;
            }
        }
    }
}

void Response_data()
{
    unsigned char data_to_send;
    memset(&ET_TX_6000[0],0,60);
    data_to_send = 0;

    ET_TX_6000[0] = '<';
    ET_TX_6000[1] = Tx_id[0];
    ET_TX_6000[2] = Tx_id[1];
    ET_TX_6000[3] = Tx_id[2];
    ET_TX_6000[4] = ':';
    ET_TX_6000[5] = 'R';
    ET_TX_6000[6] = 'e';
    ET_TX_6000[7] = 's';
    ET_TX_6000[8] = ',';

    valid_data = 9;
    //memcpy(&ET_TX_6000[9], &reply_data_recvd[packet_id+1][1], reply_data_recvd[packet_id+1][0]);// memcpy(&ET_TX_6000[9], &ET_TX_6000[5], valid_data);
    //valid_data = reply_data_recvd[packet_id+1][0] + 9;
    switch(packet_id)
    {
        case 2:
            memcpy(&ET_TX_6000[valid_data], &reply_data_recvd[packet_id+1][1], reply_data_recvd[packet_id+1][0]);
            valid_data += reply_data_recvd[packet_id+1][0];
            ET_TX_6000[valid_data++] = ',';
            memcpy(&ET_TX_6000[valid_data], &mc_status.Placement, 17);
            valid_data += 17;
            break;
        case 7:
           /* ET_TX_6000[valid_data++] = 'R';
            ET_TX_6000[valid_data++] = 'e';
            ET_TX_6000[valid_data++] = 'a';
            ET_TX_6000[valid_data++] = 'd';
            ET_TX_6000[valid_data++] = 'O';
            ET_TX_6000[valid_data++] = 'f';
            ET_TX_6000[valid_data++] = 'f';
            ET_TX_6000[valid_data++] = 's';
            ET_TX_6000[valid_data++] = 'e';
            ET_TX_6000[valid_data++] = 't';
            ET_TX_6000[valid_data++] = ' ';
            ET_TX_6000[valid_data++] = 'D';
            ET_TX_6000[valid_data++] = 'o';
            ET_TX_6000[valid_data++] = 'n';
            ET_TX_6000[valid_data++] = 'e';*/
           // ET_TX_6000[valid_data++] = ',';
            ET_TX_6000[valid_data++] = 'X';
            ET_TX_6000[valid_data++] = '=';
            if(Wafer_Offset_X[0] == '-')
                ET_TX_6000[valid_data++] = Wafer_Offset_X[0];

            ET_TX_6000[valid_data++] = Wafer_Offset_X[1];
            ET_TX_6000[valid_data++] = Wafer_Offset_X[2];
            ET_TX_6000[valid_data++] = '.';
            ET_TX_6000[valid_data++] = Wafer_Offset_X[4];
            ET_TX_6000[valid_data++] = Wafer_Offset_X[5];
            ET_TX_6000[valid_data++] = ',';
            ET_TX_6000[valid_data++] = 'Y';
            ET_TX_6000[valid_data++] = '=';
            if(Wafer_Offset_Y[0] == '-')
                ET_TX_6000[valid_data++] = Wafer_Offset_Y[0];

            ET_TX_6000[valid_data++] = Wafer_Offset_Y[1];
            ET_TX_6000[valid_data++] = Wafer_Offset_Y[2];
            ET_TX_6000[valid_data++] = '.';
            ET_TX_6000[valid_data++] = Wafer_Offset_Y[4];
            ET_TX_6000[valid_data++] = Wafer_Offset_Y[5];
            data_to_send = valid_data;

            break;

        default:
            break;
    }
   // valid_data += data_to_send;
   /* ET_TX_6000[valid_data++] = '>';
    calculate_crc(valid_data);

    ET_TX_6000[valid_data++] = 13;
    ET_TX_6000[valid_data++] = 10;

    send_to_client_6000(ET_TX_6000, valid_data);*/
    if(valid_data > 5)
        Transmit_data(valid_data);

    ET_TX_6000[0] = '<';
    ET_TX_6000[1] = Mem_Tx_id[0];
    ET_TX_6000[2] = Mem_Tx_id[1];
    ET_TX_6000[3] = Mem_Tx_id[2];
    ET_TX_6000[4] = ':';
    ET_TX_6000[5] = 'R';
    ET_TX_6000[6] = 'e';
    ET_TX_6000[7] = 's';
    ET_TX_6000[8] = ',';

    valid_data = 0;

    switch(Reply_response_data)
    {
       case 1://Alignment done complete
           memcpy(&ET_TX_6000[9], &reply_data_recvd[4][1], reply_data_recvd[4][0]);

           valid_data = reply_data_recvd[4][0] + 9;
           Reply_response_data = 0;
           break;

       case 2://Vaccum hold complete
           memcpy(&ET_TX_6000[9], &reply_data_recvd[5][1], reply_data_recvd[5][0]);
           valid_data = reply_data_recvd[5][0] + 9;
           Reply_response_data = 0;
           break;

       case 3://Vaccum release complete

           memcpy(&ET_TX_6000[9], &reply_data_recvd[6][1], reply_data_recvd[6][0]);
           valid_data = reply_data_recvd[6][0] + 9;
           Reply_response_data = 0;

           break;

       case 4://Read offset complete
           memcpy(&ET_TX_6000[9], &reply_data_recvd[7][1], reply_data_recvd[7][0]);
           valid_data = reply_data_recvd[7][0] + 9;
           Reply_response_data = 0;
           break;

       case 5://Wafer dia updated
           memcpy(&ET_TX_6000[9], &reply_data_recvd[8][1], reply_data_recvd[8][0]);
           valid_data = reply_data_recvd[8][0] + 9;
           Reply_response_data = 0;
           break;

       case 6://Wafer Type updated

          memcpy(&ET_TX_6000[9], &reply_data_recvd[9][1], reply_data_recvd[9][0]);
          valid_data = reply_data_recvd[9][0] + 9;
          Reply_response_data = 0;
          break;

      case 7://Lift pin on complete
          memcpy(&ET_TX_6000[9], &reply_data_recvd[10][1], reply_data_recvd[10][0]);
          valid_data = reply_data_recvd[10][0] + 9;
          Reply_response_data = 0;
          break;

      case 8://Lift pin off complete
          memcpy(&ET_TX_6000[9], &reply_data_recvd[11][1], reply_data_recvd[11][0]);
          valid_data = reply_data_recvd[11][0] + 9;
          Reply_response_data = 0;
          break;

      case 9://Presalignon complete

         memcpy(&ET_TX_6000[9], &reply_data_recvd[12][1], reply_data_recvd[12][0]);
         valid_data = reply_data_recvd[12][0] + 9;
         Reply_response_data = 0;

         break;

     case 10://Presalignon off complete
         memcpy(&ET_TX_6000[9], &reply_data_recvd[13][1], reply_data_recvd[13][0]);
         valid_data = reply_data_recvd[13][0] + 9;
         Reply_response_data = 0;
         break;

     case 11://Home complete
          memcpy(&ET_TX_6000[9], &reply_data_recvd[14][1], reply_data_recvd[14][0]);
          valid_data = reply_data_recvd[14][0] + 9;
          Reply_response_data = 0;
          break;

       case 27://IP save complete
           if(timer.bit.ip_save_flag == 1)
           {
               memcpy(&ET_TX_6000[9], &reply_data_recvd[31][1], reply_data_recvd[31][0]);

               Reply_response_data = 9 + reply_data_recvd[31][0];

               ET_TX_6000[Reply_response_data++] = ',';
               valid_data = IP_address[0] / 100;
               ET_TX_6000[Reply_response_data++] = (valid_data | 0x30);
               valid_data = IP_address[0] / 10;
               valid_data %= 10;
               ET_TX_6000[Reply_response_data++] = (valid_data | 0x30);
               valid_data = IP_address[0] % 10;
               ET_TX_6000[Reply_response_data++] = (valid_data | 0x30);

               ET_TX_6000[Reply_response_data++] = '.';
               valid_data = IP_address[1] / 100;
               ET_TX_6000[Reply_response_data++] = (valid_data | 0x30);
               valid_data = IP_address[1] / 10;
               valid_data %= 10;
               ET_TX_6000[Reply_response_data++] = (valid_data | 0x30);
               valid_data = IP_address[1] % 10;
               ET_TX_6000[Reply_response_data++] = (valid_data | 0x30);

               ET_TX_6000[Reply_response_data++] = '.';
               valid_data = IP_address[2] / 100;
               ET_TX_6000[Reply_response_data++] = (valid_data | 0x30);
               valid_data = IP_address[2] / 10;
               valid_data %= 10;
               ET_TX_6000[Reply_response_data++] = (valid_data | 0x30);
               valid_data = IP_address[2] % 10;
               ET_TX_6000[Reply_response_data++] = (valid_data | 0x30);

               ET_TX_6000[Reply_response_data++] = '.';
               valid_data = IP_address[3] / 100;
               ET_TX_6000[Reply_response_data++] = (valid_data | 0x30);
               valid_data = IP_address[3] / 10;
               valid_data %= 10;
               ET_TX_6000[Reply_response_data++] = (valid_data | 0x30);
               valid_data = IP_address[3] % 10;
               ET_TX_6000[Reply_response_data++] = (valid_data | 0x30);

               valid_data = reply_data_recvd[31][0] + 25;
               Reply_response_data = 0;
           }
           else
               timer.bit.ip_save_flag = 0;

           break;
    }

    if(valid_data > 7)
       Transmit_data(valid_data);

}

void error_packet_prepare(unsigned char packet_code)
{
    if(packet_code > 0 && packet_id > 1)
    {
       // packet_code--;
        memcpy(&ET_TX_6000[5], &reply_error_data[packet_code][1], reply_error_data[packet_code][0]);
        valid_data = reply_error_data[packet_code][0] + 5;

        if(Mem_Tx_id[0] == 0 && Mem_Tx_id[1] == 0 && Mem_Tx_id[2] == 0)
        {
            memcpy(&Mem_Tx_id[0], &Tx_id[0],3);
        }
        ET_TX_6000[1] = Mem_Tx_id[0];
        ET_TX_6000[2] = Mem_Tx_id[1];
        ET_TX_6000[3] = Mem_Tx_id[2];
        Transmit_data(valid_data);
    }
}

void Transmit_data(unsigned short int total_length)
{
    ET_TX_6000[total_length++] = '>';
    dummy.int_area[0] = calculate_crc(total_length);

    ET_TX_6000[total_length++] = dummy.ch_area[0];
    ET_TX_6000[total_length++] = dummy.ch_area[1];

    ET_TX_6000[total_length++] = 13;
    ET_TX_6000[total_length++] = 10;

    send_to_client_6000(ET_TX_6000, total_length);
}

void reply_error_packet_prepare()
{
    ET_TX_6000[0] = '<';
    ET_TX_6000[1] = Tx_id[0];
    ET_TX_6000[2] = Tx_id[1];
    ET_TX_6000[3] = Tx_id[2];
    ET_TX_6000[4] = ':';

    if(timer.bit.TCP_comment_invalid == 1)
    {
        packet_id = 27;
    }

    memcpy(&ET_TX_6000[5], &reply_data_recvd[packet_id][1], reply_data_recvd[packet_id][0]);// memcpy(&ET_TX_6000[9], &ET_TX_6000[5], valid_data);

    valid_data = reply_data_recvd[packet_id][0] + 5;
    ET_TX_6000[valid_data++] = '>';
    calculate_crc(valid_data);

    ET_TX_6000[valid_data++] = 13;
    ET_TX_6000[valid_data++] = 10;

    send_to_client_6000(ET_TX_6000, valid_data);

}
