
#include <string.h>

#include <xdc/std.h>
#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/drivers/GPIO.h>

/* NDK BSD support */
#include <sys/socket.h>

/* Example/Board Header file */
#include "Board.h"
#include "Xvariable.h"
#include "Xflag.h"
#include "Macro.h"

#define TCPPACKETSIZE 256
#define NUMTCPWORKERS 4

void send_to_client_9009(unsigned char *,unsigned int);
void send_to_client_6000(unsigned char *,unsigned int);
void send_to_client_12001(unsigned char *,unsigned int);

extern void ethernet_com_port(unsigned int);
void close_tcp_socket(unsigned int port_no);


// 2K Bytes transfer buffer



int  clientfd, clientfd1, clientfd2;

/* PORT Handler Declarations */
int                server_6000;
int                clientfd_6000;
int                clientfd_9009;
int                server_9009;
int                clientfd_12001;
int                server_12001;
/* END  Handler Declarations */

/*
 *  ======== FST Task ========
 *  Task to handle TCP connection. Can be multiple Tasks running
 *  this function.
 */
Void port_6000_data(UArg arg0, UArg arg1)
{
    clientfd = (int)arg0;
    int  bytesRcvd;
   // int  bytesSent;

    while ((bytesRcvd = recv(clientfd, ET_RX_6000, TCPPACKETSIZE, 0)) > 0)
    {
        ethernet_com_port(6000);
        /*else
        {
           // bytesSent = send(clientfd, buffer, sizeof(buffer), 0);
            if (bytesSent < 0 || bytesSent != bytesRcvd) {
                System_printf("Error: send failed.\n");
                //break;
            }
        }*/
    }

    close(clientfd);
}

/*Void port_9009_data(UArg arg0, UArg arg1)
{
    clientfd1 = (int)arg0;
    int  bytesRcvd1;

    while((bytesRcvd1 = recv(clientfd1, ET_RX_9009, TCPPACKETSIZE, 0)) > 0)
    {
        if(bytesRcvd1 > 0)
            ethernet_com_port(9009);
    }

    close(clientfd1);
}

Void port_12001_data(UArg arg0, UArg arg1)
{
    clientfd2 = (int)arg0;
    int  bytesRcvd2;

    while ((bytesRcvd2 = recv(clientfd2, ET_RX_12001, TCPPACKETSIZE, 0)) > 0)
    {
        if(bytesRcvd2 > 0)
        {
            ethernet_com_port(12001);
        }
    }
    close(clientfd2);
}
*/

/*
 *  ======== TaskHandler ========
 *  Creates new Task to handle new TCP connections.
 */
Void port_6000_task(UArg arg0, UArg arg1)
{
    int                status;
    struct sockaddr_in localAddr;
    struct sockaddr_in clientAddr;
    int                optval;
    int                optlen = sizeof(optval);
    socklen_t          addrlen = sizeof(clientAddr);
    Task_Handle        taskHandle;
    Task_Params        taskParams;
    Error_Block        eb;

    server_6000 = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(server_6000 == -1)
    {
        System_printf("Error: socket not created.\n");
        goto shutdown;
    }


    memset(&localAddr, 0, sizeof(localAddr));
    localAddr.sin_family = AF_INET;
    localAddr.sin_addr.s_addr = htonl(INADDR_ANY);
    localAddr.sin_port = htons(arg0);

    status = bind(server_6000, (struct sockaddr *)&localAddr, sizeof(localAddr));
    if(status == -1)
    {
        System_printf("Error: bind failed.\n");
        goto shutdown;
    }

    status = listen(server_6000, NUMTCPWORKERS);
    if(status == -1)
    {
        System_printf("Error: listen failed.\n");
        goto shutdown;
    }

    optval = 1;
    if(setsockopt(server_6000, SOL_SOCKET, SO_KEEPALIVE, &optval, optlen) < 0)
    {
        System_printf("Error: setsockopt failed\n");
        goto shutdown;
    }

    while((clientfd_6000 = accept(server_6000, (struct sockaddr *)&clientAddr, &addrlen)) != -1)
    {
        System_printf("TaskHandler: Creating thread clientfd_6000 = %d\n", clientfd_6000);

        /* Init the Error_Block */
        Error_init(&eb);

        /* Initialize the defaults and set the parameters. */
        Task_Params_init(&taskParams);
        taskParams.arg0 = (UArg)clientfd_6000;
        taskParams.stackSize = 1280;
        taskHandle = Task_create((Task_FuncPtr)port_6000_data, &taskParams, &eb);

        if(taskHandle == NULL)
        {
            System_printf("Error: Failed to create new Task\n");
            close(clientfd_6000);
        }

        /* addrlen is a value-result param, must reset for next accept call */
        addrlen = sizeof(clientAddr);
    }

    System_printf("Error: accept failed.\n");

    shutdown:
    if (server_6000 > 0)
    {
        close(server_6000);
    }
}
/*
Void port_12001_task(UArg arg0, UArg arg1)
{
   int                status;
   struct sockaddr_in localAddr;
   struct sockaddr_in clientAddr;
   int                optval;
   int                optlen = sizeof(optval);
   socklen_t          addrlen = sizeof(clientAddr);
   Task_Handle        taskHandle;
   Task_Params        taskParams;
   Error_Block        eb;

   server_12001 = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
   if (server_12001 == -1)
   {
       System_printf("Error: socket not created.\n");
       goto shutdown;
   }

   memset(&localAddr, 0, sizeof(localAddr));
   localAddr.sin_family = AF_INET;
   localAddr.sin_addr.s_addr = htonl(INADDR_ANY);
   localAddr.sin_port = htons(arg0);

   status = bind(server_12001, (struct sockaddr *)&localAddr, sizeof(localAddr));
   if (status == -1)
   {
       System_printf("Error: bind failed.\n");
       goto shutdown;
   }

   status = listen(server_12001, NUMTCPWORKERS);
   if (status == -1)
   {
       System_printf("Error: listen failed.\n");
       goto shutdown;
   }

   optval = 1;
   if (setsockopt(server_12001, SOL_SOCKET, SO_KEEPALIVE, &optval, optlen) < 0)
   {
       System_printf("Error: setsockopt failed\n");
       goto shutdown;
   }

   while ((clientfd_12001 = accept(server_12001, (struct sockaddr *)&clientAddr, &addrlen)) != -1)
   {
       System_printf("TaskHandler: Creating thread clientfd_6000 = %d\n", clientfd_12001);

       Error_init(&eb);

       Task_Params_init(&taskParams);
       taskParams.arg0 = (UArg)clientfd_12001;
       taskParams.stackSize = 1280;
       taskHandle = Task_create((Task_FuncPtr)port_12001_data, &taskParams, &eb);

       if(taskHandle == NULL)
       {
           System_printf("Error: Failed to create new Task\n");
           close(clientfd_12001);
       }

       addrlen = sizeof(clientAddr);
   }

   System_printf("Error: accept failed.\n");

   shutdown:
   if (server_12001 > 0)
   {
       close(server_12001);
   }
}
*/
void TaskReopen(int portno)
{
   // int                status;
   // struct sockaddr_in localAddr;
    struct sockaddr_in clientAddr;
  //  int                optval;
   // int                optlen = sizeof(optval);
    socklen_t          addrlen = sizeof(clientAddr);

    Task_Handle        taskHandle;
    Task_Params        taskParams;
    Error_Block        eb;

    if(portno == 6000)
    {
        while ((clientfd_6000 = accept(server_6000, (struct sockaddr *)&clientAddr, &addrlen)) != -1)
        {
            /* Init the Error_Block */
            Error_init(&eb);

            /* Initialize the defaults and set the parameters. */
            Task_Params_init(&taskParams);
            taskParams.arg0 = (UArg)clientfd_6000;
            taskParams.stackSize = 1280;
            taskHandle = Task_create((Task_FuncPtr)port_6000_data, &taskParams, &eb);
            if (taskHandle == NULL)
            {                               //Failed to create new Task
                close(clientfd_6000);
            }

            /* addrlen is a value-result param, must reset for next accept call */
            addrlen = sizeof(clientAddr);
        }
    }

 /*   else if(portno ==12001)
    {
        while ((clientfd_12001 = accept(server_12001, (struct sockaddr *)&clientAddr, &addrlen)) != -1)
        {
            Error_init(&eb);

            Task_Params_init(&taskParams);
            taskParams.arg0 = (UArg)clientfd_12001;
            taskParams.stackSize = 1280;
            taskHandle = Task_create((Task_FuncPtr)port_12001_data, &taskParams, &eb);
            if (taskHandle == NULL)         //Failed to create new Task
            {
                close(clientfd_12001);
            }

            addrlen = sizeof(clientAddr);
        }
    }
    else if(portno == 9009)
    {
        while ((clientfd_9009 = accept(server_9009, (struct sockaddr *)&clientAddr, &addrlen)) != -1)
        {
            Error_init(&eb);

            Task_Params_init(&taskParams);
            taskParams.arg0 = (UArg)clientfd_9009;
            taskParams.stackSize = 1280;
            taskHandle = Task_create((Task_FuncPtr)port_9009_data, &taskParams, &eb);
            if (taskHandle == NULL)
            {
                close(clientfd_9009);       //Failed to create new Task
            }

            addrlen = sizeof(clientAddr);
        }
    }*/
}

// ======== TaskHandler ========
//  Creates new Task to handle new TCP connections.
/*
Void port_9009_task(UArg arg0, UArg arg1)
{
    int                status;
    struct sockaddr_in localAddr;
    struct sockaddr_in clientAddr;
    int                optval;
    int                optlen = sizeof(optval);
    socklen_t          addrlen = sizeof(clientAddr);
    Task_Handle        taskHandle;
    Task_Params        taskParams;
    Error_Block        eb2;

    server_9009 = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (server_9009 == -1) //Error: socket not created
    {
        goto shutdown;
    }

    memset(&localAddr, 0, sizeof(localAddr));
    localAddr.sin_family = AF_INET;
    localAddr.sin_addr.s_addr = htonl(INADDR_ANY);
    localAddr.sin_port = htons(arg0);

    status = bind(server_9009, (struct sockaddr *)&localAddr, sizeof(localAddr));
    if(status == -1)       //Error: bind failed
    {
        goto shutdown;
    }

    status = listen(server_9009, NUMTCPWORKERS);
    if(status == -1)              // Error: listen failed
    {
        goto shutdown;
    }

    optval = 1;
    if(setsockopt(server_9009, SOL_SOCKET, SO_KEEPALIVE, &optval, optlen) < 0)         //Error: setsockopt failed
    {
        goto shutdown;
    }

    while((clientfd_9009 = accept(server_9009, (struct sockaddr *)&clientAddr, &addrlen)) != -1)
    {
            //TaskHandler: Creating thread clientfd_9009
        Error_init(&eb2);

        Task_Params_init(&taskParams);
        taskParams.arg0 = (UArg)clientfd_9009;
        taskParams.stackSize = 1280;
        taskHandle = Task_create((Task_FuncPtr)port_9009_data, &taskParams, &eb2);
        if (taskHandle == NULL)             //Error: Failed to create new Task
        {
            close(clientfd_9009);
        }

        addrlen = sizeof(clientAddr);
    }

  //Error: accept failed.

    shutdown:
    if(server_9009 > 0)
    {
        close(server_9009);
    }
}

void send_to_client_12001(unsigned char *data,unsigned int len)
{
    unsigned int bytesSent;

    bytesSent = send(clientfd2, data, len, 0);

    if(bytesSent > 0)
        bytesSent = 0;
    memset(&ET_RX_12001[0],0,250);
}
*/
void send_to_client_6000(unsigned char *data,unsigned int len)
{
    unsigned int bytesSent;
    bytesSent = send(clientfd, data, len, 0);
  //  memset(&ET_RX_6000[0],0,250);
    if(bytesSent > 0)
        bytesSent = 0;
}
/*
void send_to_client_9009(unsigned char *data,unsigned int len)
{
    unsigned int bytesSent;

    bytesSent = send(clientfd1, data, len, 0);
    if(bytesSent > 0)
        bytesSent = 0;
    memset(&ET_RX_9009[0],0,250);
}
*/
void close_tcp_socket(unsigned int port_no)
{
    if(port_no == 6000)
    {
        close(clientfd_6000);
        System_printf("\nPort reopened 6000\n");
    }

   /* if(port_no == 9009)
    {
        close(clientfd_9009);
        System_printf("\nPort reopened 9009\n");
    }

    if(port_no == 12001)
    {
        close(clientfd_12001);
        System_printf("\nPort reopened 12001\n");
    }*/
    System_flush();
}
