
/*
 *    ======== FST_HOOKS.c ========
 *    Contains non-BSD sockets code (NDK Network Open Hook)
 */

/* XDCtools Header files */
#include <xdc/std.h>
#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

/* BIOS Header files */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>

#define TCPPORT1 6000
#define TCPPORT2 9009
#define TCPPORT3 12001

#define TCPHANDLERSTACK 1424

unsigned int dlyu;

/* Prototypes */
Void port_6000_task(UArg arg0, UArg arg1);

Void port_9009_task(UArg arg0, UArg arg1);

Void port_12001_task(UArg arg0, UArg arg1);
/*
 *  ======== netOpenHook ========
 *  NDK network open hook used to initialize IPv6
 */
Task_Handle taskHandle1,taskHandle2,taskHandle3;
Task_Params taskParams1,taskParams2,taskParams3;
Error_Block eb1,eb2,eb3;

void netOpenHook()
{
//============//TASK #1 PORT 12000=====================================================
    // Make sure Error_Block is initialized
    Error_init(&eb1);

    /* Create the Task that farms out incoming TCP connections.
     *  arg0 will be the port that this task listens to. */
    Task_Params_init(&taskParams1);
    taskParams1.stackSize = TCPHANDLERSTACK;
    taskParams1.priority = 1;
    taskParams1.arg0 = TCPPORT1;
    taskHandle1 = Task_create((Task_FuncPtr)port_6000_task, &taskParams1, &eb1);
    if (taskHandle1 == NULL)
    {
        System_printf("netOpenHook #1: Failed to create tcpHandler Task\n");
    }
    dlyu = 65000;
    while(dlyu>2)
        dlyu--;
//============//TASK #3 PORT 12001=====================================================
    //TASK #3 FOR THE PORT 12001
  /*  Task_Params_init(&taskParams3);
    taskParams3.stackSize = TCPHANDLERSTACK;
    taskParams3.priority = 1;
    taskParams3.arg0 = TCPPORT3;
    taskHandle3 = Task_create((Task_FuncPtr)port_12001_task, &taskParams3, &eb3);

    if (taskHandle3 == NULL)
    {
        System_printf("netOpenHook #3: Failed to create tcpHandler Task\n");
    }

//============//TASK #2 PORT 9009=====================================================
    Error_init(&eb2);

    Task_Params_init(&taskParams2);
    taskParams2.stackSize = TCPHANDLERSTACK;
    taskParams2.priority = 2;
    taskParams2.arg0 = TCPPORT2;
    taskHandle2 = Task_create((Task_FuncPtr)port_9009_task, &taskParams2, &eb2);
    if (taskHandle2 == NULL)
    {
        System_printf("netOpenHook #2: Failed to create tcpHandler Task\n");
    }
    else
        System_printf("Port 9009\n");
*/
    System_flush();
}
