/***********************************************************************************************************************************

    Module name             =   GPIO_Interrupt.c
    Created By              =   Yuvaraj
    Created On              =   01-Feb-2024
    Formula used            =
    Interrupts used         =
    Description             =

    Modified By             =
    Modified On             =
    Reason for modification =

    Special function        =
*****************************************************************************************************************************************/

#include <string.h>
#include <stdbool.h>

#include <xdc/std.h>
#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/drivers/GPIO.h>
#include <driverlib/gpio.h>
#include <driverlib/interrupt.h>
#include <driverlib/adc.h>

#include <ti/sysbios/knl/Swi.h>
#include <inc/hw_memmap.h>
#include <inc/hw_ints.h>

/* NDK BSD support */
#include <sys/socket.h>

/* Example/Board Header file */
#include "Board.h"
#include "XFlag.h"
#include "Xvariable.h"
#include "Macro.h"


unsigned char pulse_switch;
unsigned int sensor_old_val;

void GPIO_interrupt_ISR();

void GPIO_interrupt_set()
{
//*****************************************************************************
    // GPIO Activate
    //*****************************************************************************

    GPIO_setCallback(INT_GPIOP7, GPIO_interrupt_ISR);
   GPIO_enableInt(INT_GPIOP7);
   GPIOPinTypeGPIOInput(GPIO_PORTL_BASE, GPIO_PIN_7);             //define PL7 as an input
   GPIOIntClear(GPIO_PORTL_BASE,GPIO_PIN_7);                      //clear interrupt on PP
   GPIOIntTypeSet(GPIO_PORTL_BASE,GPIO_PIN_7,GPIO_RISING_EDGE);   //sets type of interrupt that is coupled to the pin
   GPIOIntEnable(GPIO_PORTL_BASE,GPIO_PIN_7);                     //enables the interrupt
   IntPrioritySet(INT_GPIOP7, 0);                                 //sets priority of interrupt

   // install Button callback
   GPIO_setCallback(INT_GPIOL, GPIO_interrupt_ISR);
  // GPIOIntRegister

   // Enable interrupts
   GPIO_enableInt(INT_GPIOL);
}

void GPIO_interrupt_ISR()
{
    unsigned int input_portL1;
    input_portL1 = GPIOPinRead(INT_GPIOL, 0X00FF);
   // if((input_portL1 & 0x80)==0)
    {
        Motor_CW_pulse++;
       // if(Sensor_capture_start_flag)
        {
           // Sensor_volt_avg[Sensor_volt_avg_count++] = adc_value[0];

            if(align_seq_no == 2 || align_seq_no == 5)
            {
                //if(++Sensor_volt_avg_count > 1)
                {
                    Sensor_volt_avg_count = 0;
                    //Motor_CCW_pulse++;
                    ADCProcessorTrigger(ADC0_BASE, ADC_CTL_CH0);
                    while(!ADCIntStatus(ADC0_BASE, 0, false))
                    {}

                    ADCIntClear(ADC0_BASE,0);
                    ADCSequenceDataGet(ADC0_BASE,0,adc_value);

                    if(Motor_pulse_count > 25)
                        Wafer_recording_flag = 1;
                    else
                        align_logic_delay = 200;

                    if(Motor_pulse_count < 55000)
                        Sensor_value_count[Motor_pulse_count++] = adc_value[0];

                   /* sensor_old_val = 0;
                    for(pulse_switch = 0; pulse_switch < Sensor_volt_avg_count; pulse_switch++)
                    {
                        sensor_old_val += Sensor_volt_avg[pulse_switch];
                    }
                    sensor_old_val /= Sensor_volt_avg_count;
                    Sensor_volt_avg_count = 0;
                    memset(&Sensor_volt_avg[0], 0, 20);

                    Sensor_value_count[Motor_pulse_count++] = sensor_old_val;//adc_value[0];*/
                }
            }
            else
            {
                Motor_pulse_count_min++;
                if(align_seq_no == 4)
                {
                    if(Motor_pulse_count_min < 10)
                        align_logic_delay = 500;
                }
            }
        }
    }
}





