/***********************************************************************************************************************************

	Module name				= 	Init_controller.c
	Created By 				= 	Yuvaraj V
	Created On 				= 	09.01.2020
	Formula used 			=
	Interrupts used 		=
	Description 			=

	Modified By 			=
	Modified On 			=
	Reason for modification =

	Special function		=
*****************************************************************************************************************************************/

#include <stdbool.h>
#include <stdint.h>
#include "inc/hw_ints.h"
#include "inc/hw_memmap.h"
#include "driverlib/gpio.h"
#include "driverlib/interrupt.h"
#include "driverlib/pin_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/timer.h"
#include "driverlib/uart.h"
#include "inc/hw_emac.h"
#include "inc/hw_ints.h"
#include "inc/hw_types.h"
#include "driverlib/debug.h"
#include "driverlib/emac.h"
#include "driverlib/flash.h"
#include "driverlib/rom.h"
#include "driverlib/rom_map.h"
#include "driverlib/systick.h"
#include "driverlib/eeprom.h"

#include "utils/uartstdio.h"
//*****************************************************************************
//#include "main.h"
#include "XFlag.h"
#include "Xvariable.h"
#include "string.h"
#include "Macro.h"



void init_controller();
void init_ram_variables();
void init_ybs_uart();

extern void ADC_init();

void init_controller()
{
  //  SysCtlClockFreqSet((SYSCTL_XTAL_20MHZ |	SYSCTL_OSC_MAIN | SYSCTL_USE_PLL | SYSCTL_CFG_VCO_480), 120000000);
//============ Init GPIO ====================================================================================================================

	GPIOPinTypeGPIOInput(GPIO_PORTD_BASE, GPIO_PIN_4);
	//==============sound buzzer====================================//
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOL);
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOK);
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOE);
	GPIOPinTypeGPIOOutput(GPIO_PORTL_BASE, GPIO_PIN_0);
	GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_0, 0);

	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOL);
	GPIOPinTypeGPIOOutput(GPIO_PORTL_BASE, GPIO_PIN_1);
	GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_1, 0);

//------------I2C -------------------//
	/*SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOB);
	while(!SysCtlPeripheralReady(SYSCTL_PERIPH_GPIOB));
	SysCtlPeripheralEnable(SYSCTL_PERIPH_I2C0);
	while(!SysCtlPeripheralReady(SYSCTL_PERIPH_I2C0));

	GPIOPinConfigure(GPIO_PB2_I2C0SCL);
	GPIOPinConfigure(GPIO_PB3_I2C0SDA);
	GPIOPinTypeI2C(GPIO_PORTB_BASE, GPIO_PIN_3);
	GPIOPinTypeI2CSCL(GPIO_PORTB_BASE, GPIO_PIN_2);*/

	//IntEnable(INT_TIMER0A);

	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPION);
	GPIOPinTypeGPIOOutput(GPIO_PORTN_BASE, GPIO_PIN_0);
	GPIOPinWrite(GPIO_PORTN_BASE, GPIO_PIN_0, 0);

	GPIOPinTypeGPIOOutput(GPIO_PORTA_BASE, GPIO_PIN_4|GPIO_PIN_6);
    GPIOPinTypeGPIOOutput(GPIO_PORTB_BASE, GPIO_PIN_4|GPIO_PIN_5);
    GPIOPinTypeGPIOOutput(GPIO_PORTD_BASE, GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3);
    GPIOPinTypeGPIOOutput(GPIO_PORTE_BASE, GPIO_PIN_4|GPIO_PIN_5);
    GPIOPinTypeGPIOOutput(GPIO_PORTF_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4);
    GPIOPinTypeGPIOOutput(GPIO_PORTG_BASE, GPIO_PIN_0|GPIO_PIN_1);
    GPIOPinTypeGPIOOutput(GPIO_PORTH_BASE, GPIO_PIN_2|GPIO_PIN_3);
    GPIOPinTypeGPIOOutput(GPIO_PORTN_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5);
    GPIOPinTypeGPIOOutput(GPIO_PORTP_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5);

    GPIOPinWrite(GPIO_PORTN_BASE,GPIO_PIN_1, 0);
    GPIOPinWrite(GPIO_PORTD_BASE,GPIO_PIN_2, 0);
    GPIOPinTypeGPIOOutput(GPIO_PORTC_BASE, GPIO_PIN_5);
    //GPIOPinTypeGPIOOutput(GPIO_PORTN_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5);

    SysCtlPeripheralEnable(SYSCTL_PERIPH_EEPROM0);
    while(!SysCtlPeripheralReady(SYSCTL_PERIPH_EEPROM0))
    {}
    EEPROMInit();

    memset(&IP_address[0],0,4);
    EEPROMRead(&dummy.ln_area, 0x400, 4);
    memcpy(&IP_address[0], &dummy.ch_area[0], 4);

    EEPROMRead(&Total_cycle_counter, 0x404, 4);

    if(IP_address[0] > 100 && IP_address[0] < 200)
    {
       if(IP_address[1] > 100 && IP_address[1] < 200)
       {
           if(IP_address[2] > 0 && IP_address[2] < 200)
           {
               if(IP_address[3] > 0)
               {
                   if(!(IP_address[0] == 192 && IP_address[1] == 168 && IP_address[2] == 1 && IP_address[3] == 200))
                   {
                       timer.bit.ip_readed_flag = 1;
                       timer.bit.ip_save_flag = 1;
                   }
               }
           }
       }
    }

    GPIOPinTypeGPIOOutput(GPIO_PORTL_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4);
    GPIOPinTypeGPIOOutput(GPIO_PORTN_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5);
    GPIOPinTypeGPIOOutput(GPIO_PORTK_BASE, GPIO_PIN_7|GPIO_PIN_6);

    GPIOPinTypeGPIOOutput(GPIO_PORTE_BASE, GPIO_PIN_4);

    GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_0, GPIO_PIN_0);
    GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_1, GPIO_PIN_1);
    GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_2, GPIO_PIN_2);
    GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_3, GPIO_PIN_3);
    GPIOPinWrite(GPIO_PORTL_BASE, GPIO_PIN_4, GPIO_PIN_4);

    GPIOPinWrite(GPIO_PORTK_BASE, GPIO_PIN_7, GPIO_PIN_7);
    GPIOPinWrite(GPIO_PORTK_BASE, GPIO_PIN_6, GPIO_PIN_6);

    GPIOPinTypeGPIOInput(GPIO_PORTA_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_5);
    GPIOPinTypeGPIOInput(GPIO_PORTB_BASE, GPIO_PIN_2|GPIO_PIN_3);
    GPIOPinTypeGPIOInput(GPIO_PORTC_BASE, GPIO_PIN_4);
    GPIOPinTypeGPIOInput(GPIO_PORTD_BASE, GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7);
    GPIOPinTypeGPIOInput(GPIO_PORTH_BASE, GPIO_PIN_0|GPIO_PIN_1);
    GPIOPinTypeGPIOInput(GPIO_PORTK_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7);
    GPIOPinTypeGPIOInput(GPIO_PORTL_BASE, 0x000000FF);
    GPIOPinTypeGPIOInput(GPIO_PORTQ_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3);

    ADC_init();

    SERVO_OFF;
    HOMING_OFF;
    MOTOR_RUN_OFF;

}

void init_ram_variables()
{}


void init_ybs_uart()
{
	SysCtlPeripheralEnable(SYSCTL_PERIPH_UART5);
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOC);

	GPIOPinConfigure(GPIO_PC6_U5RX);
	GPIOPinConfigure(GPIO_PC7_U5TX);

	GPIOPinTypeUART(GPIO_PORTC_BASE, GPIO_PIN_6 | GPIO_PIN_7);
	UARTConfigSetExpClk(UART5_BASE, 120000000, 19200, (UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));

	IntDisable(INT_UART5); //enable the UART interrupt

    UARTFIFODisable(UART5_BASE);
    UARTIntDisable(UART5_BASE, UART_INT_TX);
    UARTIntEnable(UART5_BASE, UART_INT_RX);

	IntMasterEnable();
	IntEnable(INT_UART5); //enable the UART interrupt
}






