
#ifndef INCLUDE_MACRO_H_
#define INCLUDE_MACRO_H_


#include "Outputs.h"

#define UART5_TX_Enable       GPIOPinWrite(GPIO_PORTC_BASE, GPIO_PIN_5, 0x20)
#define UART5_RX_Enable       GPIOPinWrite(GPIO_PORTC_BASE, GPIO_PIN_5, 0)

#define RSM_TX_Enable       GPIOPinWrite(GPIO_PORTP_BASE, GPIO_PIN_0, 1)
#define RSM_RX_Enable       GPIOPinWrite(GPIO_PORTP_BASE, GPIO_PIN_0, 0)


#define LED1_ON             GPIOPinWrite(GPIO_PORTH_BASE, GPIO_PIN_2, GPIO_PIN_2)
#define LED1_OFF            GPIOPinWrite(GPIO_PORTH_BASE, GPIO_PIN_2, 0)

#define LED2_ON             GPIOPinWrite(GPIO_PORTH_BASE, GPIO_PIN_3, GPIO_PIN_3)
#define LED2_OFF            GPIOPinWrite(GPIO_PORTH_BASE, GPIO_PIN_3, 0)

#define TASKSTACKSIZE     512
#define THREADSTACKSIZE     512
#define CLOCK_SUBMAIN_DURATION     5 //Used for SUB Main clock reoccur duration
#define E2PROM_TEST_ADRES 0x400AF000

#define GPIO_PORTH_DATA (*((volatile unsigned long *)0x4005F038))

#define ERROR_CHECK             0
#define CLAMP_MODE              1
#define DOCK_MODE               2
#define LATCH_MODE              3
#define DOOR_OPEN_MODE          4
#define DOOR_DOWN_MODE          5
#define MAPPING_ARM_IN_MODE     6
#define MAPPING_START_MODE      7
//#define MAPPING_STOP_MODE       8
#define MAPPING_ARM_OUT_MODE    8
#define DOOR_DOWN_END_POS_MODE  9


#define DOOR_UP                 0
#define DOOR_CLOSE              1
#define UNLATCH_MODE            2
#define UNDOCK_MODE             3
#define UNCLAMP_MODE            4

//=========LOAD LOGIC SV's===============
#define CLAMP_SV_ON             1
#define CLAMP_SV_OFF            0
#define DOCK_SV_ON              1
#define DOCK_SV_OFF             0
#define LATCH_SV_ON             1
#define LATCH_SV_OFF            0
#define DOOR_OPEN_SV_ON         1
#define DOOR_OPEN_SV_OFF        0
#define DOOR_DOWN_SV_ON         1
#define DOOR_DOWN_SV_OFF        0
#define MAP_ARM_IN_SV_ON        1
#define MAP_ARM_IN_SV_OFF       0

//=========UNLOAD LOGIC SV's===============
#define UNCLAMP_SV_ON           1
#define UNCLAMP_SV_OFF          0
#define UNDOCK_SV_ON            1
#define UNDOCK_SV_OFF           0
#define UNLATCH_SV_ON           1
#define UNLATCH_SV_OFF          0
#define UNDOOR_OPEN_SV_ON       1
#define UNDOOR_OPEN_SV_OFF      0
#define UNDOOR_DOWN_SV_ON       1
#define UNDOOR_DOWN_SV_OFF      0
#define MAP_ARM_OUT_SV_ON       1
#define MAP_ARM_OUT_SV_OFF      0


#define UNDOCK_SV               0
#define DOCK_SV                 1
#define DOOR_DOWN_SV            2
#define MAP_ARM_IN_SV           3
#define DOOR_OPEN_SV            4
#define DOOR_UP_SV              5
#define MAP_ARM_OUT_SV          6
#define DOOR_CLOSE_SV           7
#define UNCLAMP_SV              8
#define UNLATCH_SV              9
#define LATCH_SV                10
#define CLAMP_SV                11

#define SERVO_ON        OUTPUT8_ON
#define SERVO_OFF       OUTPUT8_OFF

#define HOMING_ON       OUTPUT7_ON
#define HOMING_OFF      OUTPUT7_OFF

#define MOTOR_RUN_ON    OUTPUT6_ON
#define MOTOR_RUN_OFF   OUTPUT6_OFF



#endif /* INCLUDE_MACRO_H_ */
