/***********************************************************************************************************************************

    Module name             =   Main.c
    Created By              =   Yuvaraj
    Created On              =   27.04.2023
    Formula used            =
    Interrupts used         =
    Description             =

    Modified By             =
    Modified On             =
    Reason for modification =

    Special function        =
*****************************************************************************************************************************************/

#include <string.h>
#include <stdbool.h>

#include <xdc/std.h>
#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/drivers/GPIO.h>
#include <driverlib/gpio.h>

#include <ti/sysbios/knl/Swi.h>
#include <inc/hw_memmap.h>

/* NDK BSD support */
#include <sys/socket.h>

/* Example/Board Header file */
#include "Board.h"
#include "Var.h"
#include "Flag.h"
#include "main.h"
#include "Macro.h"

unsigned char crc_test[20];
unsigned char loop_ptr;
unsigned int crc;


Swi_Handle swiHandleMain, swi1Handle;
void SubMain_Function(UArg);

extern void test_out_contl();
extern void Step_out_on(unsigned char);
void Process_recvd_data(unsigned char );

//======== Initial Main Call ================================================
int main(void)
{
    Board_initGeneral();
    Board_initGPIO();
    init_controller();
    Board_initEMAC();

    init_UARTs();
    start_sub_main_thread();
    timer_5ms_init();
  //  timer_1ms_init();
    GPIO_interrupt_set();

    Speed_update_time = 100;
    Power_on_counter = 0;
    pwr_on_flag = 0;
    wafer_limit_cross = 91;
    memset(&mc_status.Placement, 0x30, 17);
    memset(&Wafer_Offset_X, 0x30, 6);
    memset(&Wafer_Offset_Y, 0x30, 6);

    BIOS_start();


    while(1)
    {}
}

/* Clock Function */
void SubMain_Function(UArg arg0)
{
    if(timer.bit.one_sec_completed_flag)
    {
        one_sec_once_process();
        timer.bit.one_sec_completed_flag = 0;

        if(Power_on_counter < 6 && pwr_on_flag == 0)
        {
            if(++Power_on_counter > 5)
            {
                pwr_on_flag = 1;
                poll_seq = 5;
            }
        }
    }

    if(timer.bit.two_50ms_sec_flag)
    {
        if(pwr_on_flag == 1 && Wafer_recording_flag == 0)
            Modus_comm();

        timer.bit.two_50ms_sec_flag = 0;
    }

    if(status_request > 0 && pwr_on_flag == 1)
   {
       Process_recvd_data(status_request);
       status_request = 0;
   }

    output_control();
 //   test_out_contl();
    Swi_post(swiHandleMain);
}

void Process_recvd_data(unsigned char recvd_data)
{
    switch(recvd_data)
    {
        case 1:
           break;

        case 2://Home
            Home_seq_start_flag = 1;
            Home_logic_delay = 100;
            home_seq_no = 0;
            Output_off.disable = 0x0fff;
            error.status = 0;
            memcpy(&Mem_Tx_id[0], &Tx_id[0],3);
            Reply_response_data = 11;
            break;

        case 3://Align

          //  Output_off.disable = 0x0fff;
           // error.bit.machine_error = 0;
            memcpy(&Mem_Tx_id[0], &Tx_id[0],3);
            dummy.ln_area  = 0;
            if(ET_RX_PROC_DATA[5] == '>')
            {
                dummy.ln_area = (ET_RX_PROC_DATA[4] - 48);
                dummy.ln_area += (ET_RX_PROC_DATA[2] - 48) * 10;
                dummy.ln_area += (ET_RX_PROC_DATA[1] - 48) * 100;
                dummy.ln_area += (ET_RX_PROC_DATA[0] - 48) * 1000;
            }
            else
            {
                dummy.ln_area = (ET_RX_PROC_DATA[3] - 48);
                dummy.ln_area += (ET_RX_PROC_DATA[1] - 48) * 10;
                dummy.ln_area += (ET_RX_PROC_DATA[0] - 48) * 100;
            }

            Align_angle = dummy.ln_area;

            start_align_proc_flag = 1;
            //Reply_response_data = 1;
            Wafer_record_start_flag = 1;
            align_logic_delay = 20;
            align_seq_no = 0;
            break;

        case 4://Vaccum on command

          //  Output_off.disable = 0x0fff;
            memcpy(&Mem_Tx_id[0], &Tx_id[0],3);
            Output_off.bit.SV_vaccum_off = 0;
            Output_on.bit.SV_vaccum_on = 1;
            Reply_response_data = 2;
            if(error.status > 0)
            {
                error_to_com_flag = 1;
            }
            break;

        case 5://Vaccum off command
            Output_on.bit.SV_vaccum_on = 0;
            Output_off.bit.SV_vaccum_off = 1;
            Reply_response_data = 3;
            break;

        case 6://Read offset command
            //Reply_response_data = 4;
            memcpy(&Mem_Tx_id[0], &Tx_id[0],3);
            break;

        case 7://Wafer dia command
            memcpy(&Mem_Tx_id[0], &Tx_id[0],3);
            dummy.ln_area  = 0;
            dummy.ln_area = (ET_RX_PROC_DATA[2] - 48);
            dummy.ln_area += (ET_RX_PROC_DATA[1] - 48) * 10;
            dummy.ln_area += (ET_RX_PROC_DATA[0] - 48) * 100;
            Wafer_dia = dummy.ln_area;
            Reply_response_data = 5;
            break;

        case 8://Wafer Type command
            memcpy(&Mem_Tx_id[0], &Tx_id[0],3);
            Wafer_type = ET_RX_PROC_DATA[0] - 48;
            Reply_response_data = 6;
            break;

        case 9://Lift command
            memcpy(&Mem_Tx_id[0], &Tx_id[0],3);

            if(ET_RX_PROC_DATA[0] == 'O' && ET_RX_PROC_DATA[1] == 'n')
            {
                Output_on.bit.SV_Lift_pin_up_on = 1;
                Output_off.bit.SV_Lift_pin_up_off = 0;
                Reply_response_data = 7;
            }
            else if(ET_RX_PROC_DATA[0] == 'O' && ET_RX_PROC_DATA[1] == 'f' && ET_RX_PROC_DATA[2] == 'f')
            {
                Output_on.bit.SV_Lift_pin_up_on = 0;
                Output_off.bit.SV_Lift_pin_up_off = 1;
                Reply_response_data = 8;
            }
            break;
        case 10://Presalign command
            memcpy(&Mem_Tx_id[0], &Tx_id[0],3);

            if(ET_RX_PROC_DATA[0] == 'O' && ET_RX_PROC_DATA[1] == 'n')
            {
                start_pres_align_proc_flag = 1;
                Reply_response_data = 9;
            }
            else if(ET_RX_PROC_DATA[0] == 'O' && ET_RX_PROC_DATA[1] == 'f' && ET_RX_PROC_DATA[2] == 'f')
            {
                start_pres_align_proc_flag = 0;
                Reply_response_data = 10;
            }
            break;

        default:
            break;
    }

    if(recvd_data > 6)
    {
        if(error.status > 0)
        {
            error_to_com_flag = 1;
            Manual_oper_cmnd = 0;
        }
    }

    memset(&ET_RX_PROC_DATA[0], 0, 10);
}



