/***********************************************************************************************************************************

    Module name             =   Modbus RTU.c
    Created By              =   Yuvaraj
    Created On              =   04.01.2024
    Formula used            =
    Interrupts used         =
    Description             =

    Modified By             =
    Modified On             =
    Reason for modification =

    Special function        =
*****************************************************************************************************************************************/


#include <stdbool.h>
#include <stdint.h>

#include "inc/hw_memmap.h"
#include "driverlib/gpio.h"
#include "driverlib/interrupt.h"
#include "driverlib/pin_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/timer.h"
#include "driverlib/uart.h"
#include "driverlib/eeprom.h"


#include "Xvariable.h"
#include "Xflag.h"
#include "string.h"
#include "math.h"
#include "Macro.h"
#include "EEPROM.h"


unsigned char table_crc_hi[20], table_crc_lo[20];
unsigned short int  Mod_CRC;
unsigned short int Modbus_CRC(uint8_t *buffer, uint16_t);
unsigned char next_poll_seq;
void Modus_comm();




extern void Send_data_to_uart5(unsigned char);

/*==============================================
 * Byte0 = Device id
 * Byte1 = Read or write
 * Byte2,3 = Register starting address 2 bytes. ex: 40001, 0, 01
 * Byte4,5 = Data to be transfer or Number register to be read
 * Byte6,7 = CRC
 */

void Modus_comm()
{
    uart5_tx_buffer[0] = 1; // address
    uart5_tx_buffer[14] = 7;

    if(poll_seq < 1 || poll_seq > 8)
        poll_seq = 1;

    if(Sensor_capture_start_flag && Motor_pulse_count > 10)
        return;

    switch(poll_seq)
    {
        case 1://Read
           uart5_tx_buffer[1] = 3;//3 Read Holding register and 6 Write register
           uart5_tx_buffer[2] = 0; //Register starting address 2 bytes.
           uart5_tx_buffer[3] = 4;
           uart5_tx_buffer[4] = 0;
           uart5_tx_buffer[5] = 2; // Number register to be read

           dummy.ln_area = Modbus_CRC(&uart5_tx_buffer[0], 6);
           uart5_tx_buffer[6] = dummy.ch_area[0];
           uart5_tx_buffer[7] = dummy.ch_area[1];

           uart5_tx_buffer[29] = 8;
           uart5_read_byte_count = 7;

           break;

        case 2://Write Speed
            uart5_tx_buffer[0] = 1;
            uart5_tx_buffer[1] = 0x10;//3 Read Holding register and 6 Write register
            uart5_tx_buffer[2] = 0; //Register starting address 2 bytes. ex: 40001, 0, 01
            uart5_tx_buffer[3] = 0x1B;
            uart5_tx_buffer[4] = 0;
            uart5_tx_buffer[5] = 5; // Number register to be read
            uart5_tx_buffer[6] = 0x0A;

            Step_Drive[0].accl = 200;//100;
            dummy.ln_area = Step_Drive[0].accl;
            uart5_tx_buffer[7] = dummy.ch_area[1];
            uart5_tx_buffer[8] = dummy.ch_area[0];

            Step_Drive[0].decl = 50;
            dummy.ln_area = Step_Drive[0].decl;
            uart5_tx_buffer[9] = dummy.ch_area[1];
            uart5_tx_buffer[10] = dummy.ch_area[0];

            //Step_Drive[0].speed = 3000;

            if(Step_Drive[0].speed < 50)
                Step_Drive[0].speed = 50;

            dummy.ln_area = Step_Drive[0].speed;
            uart5_tx_buffer[11] = dummy.ch_area[1];
            uart5_tx_buffer[12] = dummy.ch_area[0];

           // Step_Drive[0].Position = 200000;
            if(Step_Drive[0].Position < 2)
                Step_Drive[0].Position = 2;
            dummy.ln_area = Step_Drive[0].Position;
            uart5_tx_buffer[13] = dummy.ch_area[3];
            uart5_tx_buffer[14] = dummy.ch_area[2];
            uart5_tx_buffer[15] = dummy.ch_area[1];
            uart5_tx_buffer[16] = dummy.ch_area[0];

            dummy.ln_area = Modbus_CRC(&uart5_tx_buffer[0], 17);
            uart5_tx_buffer[17] = dummy.ch_area[0];
            uart5_tx_buffer[18] = dummy.ch_area[1];

            uart5_tx_buffer[29] = 19;
            uart5_read_byte_count = 19;
            next_poll_seq = 4;

            if(align_seq_no > 5)
            {
                align_seq_no = align_seq_no;
            }

            break;

        case 3://Absolute move
            uart5_tx_buffer[1] = 6;//3 Read Holding register and 6 Write register
            uart5_tx_buffer[2] = 0; //Register starting address 2 bytes. ex: 40001, 0, 01
            uart5_tx_buffer[3] = 0x7C;
            uart5_tx_buffer[4] = 0;
            uart5_tx_buffer[5] = 0x67;

            dummy.ln_area = Modbus_CRC(&uart5_tx_buffer[0], 6);
            uart5_tx_buffer[6] = dummy.ch_area[0];
            uart5_tx_buffer[7] = dummy.ch_area[1];

            uart5_tx_buffer[29] = 8;
            uart5_read_byte_count = 8;
            poll_seq = 15;

            if(align_seq_no == 5)
            {
                Motor_pulse_count = 0;
                Wafer_recording_flag = 0;
            }

            break;

        case 4://Relative move
            uart5_tx_buffer[1] = 6;//3 Read Holding register and 6 Write register
            uart5_tx_buffer[2] = 0; //Register starting address 2 bytes. ex: 40001, 0, 01
            uart5_tx_buffer[3] = 0x7C;
            uart5_tx_buffer[4] = 0;
            uart5_tx_buffer[5] = 0x66; // Number register to be read

            dummy.ln_area = Modbus_CRC(&uart5_tx_buffer[0], 6);
            uart5_tx_buffer[6] = dummy.ch_area[0];
            uart5_tx_buffer[7] = dummy.ch_area[1];

            uart5_tx_buffer[29] = 8;
            uart5_read_byte_count = 8;
            poll_seq = 15;
            break;

        case 5://Motor Enable
            uart5_tx_buffer[1] = 6;//3 Read Holding register and 6 Write register
            uart5_tx_buffer[2] = 0;
            uart5_tx_buffer[3] = 0x7C;
            uart5_tx_buffer[4] = 0;
            uart5_tx_buffer[5] = 0x9F;

            dummy.ln_area = Modbus_CRC(&uart5_tx_buffer[0], 6);
            uart5_tx_buffer[6] = dummy.ch_area[0];
            uart5_tx_buffer[7] = dummy.ch_area[1];

            uart5_tx_buffer[14] = 8;
            uart5_read_byte_count = 8;
            poll_seq = 15;
            break;

        case 6://Motor Disable
           uart5_tx_buffer[1] = 6;//3 Read Holding register and 6 Write register
           uart5_tx_buffer[2] = 0;
           uart5_tx_buffer[3] = 0x7C;
           uart5_tx_buffer[4] = 0;
           uart5_tx_buffer[5] = 0x9E;

           dummy.ln_area = Modbus_CRC(&uart5_tx_buffer[0], 6);
           uart5_tx_buffer[6] = dummy.ch_area[0];
           uart5_tx_buffer[7] = dummy.ch_area[1];

           uart5_tx_buffer[14] = 8;
           uart5_read_byte_count = 8;
           poll_seq = 15;
           break;

        case 7://Write Speed
            uart5_tx_buffer[0] = 1;
            uart5_tx_buffer[1] = 0x10;//3 Read Holding register and 6 Write register
            uart5_tx_buffer[2] = 0; //Register starting address 2 bytes. ex: 40001, 0, 01
            uart5_tx_buffer[3] = 0x1B;
            uart5_tx_buffer[4] = 0;
            uart5_tx_buffer[5] = 5; // Number register to be read
            uart5_tx_buffer[6] = 0x0A;

            Step_Drive[0].accl = 200;//100;
            dummy.ln_area = Step_Drive[0].accl;
            uart5_tx_buffer[7] = dummy.ch_area[1];
            uart5_tx_buffer[8] = dummy.ch_area[0];

            Step_Drive[0].decl = 100;
            dummy.ln_area = Step_Drive[0].decl;
            uart5_tx_buffer[9] = dummy.ch_area[1];
            uart5_tx_buffer[10] = dummy.ch_area[0];

            //Step_Drive[0].speed = 3000;

            if(Step_Drive[0].speed < 300)
                Step_Drive[0].speed = 300;

            dummy.ln_area = Step_Drive[0].speed;
            uart5_tx_buffer[11] = dummy.ch_area[1];
            uart5_tx_buffer[12] = dummy.ch_area[0];

            Step_Drive[0].Position = -900;
            dummy.ln_area = Step_Drive[0].Position;
            uart5_tx_buffer[13] = dummy.ch_area[3];
            uart5_tx_buffer[14] = dummy.ch_area[2];
            uart5_tx_buffer[15] = dummy.ch_area[1];
            uart5_tx_buffer[16] = dummy.ch_area[0];

            dummy.ln_area = Modbus_CRC(&uart5_tx_buffer[0], 17);
            uart5_tx_buffer[17] = dummy.ch_area[0];
            uart5_tx_buffer[18] = dummy.ch_area[1];

            uart5_tx_buffer[29] = 19;
            uart5_read_byte_count = 19;
            next_poll_seq = 4;
            break;

        default:
            break;
    }

    if(poll_seq > 0)
    {
       Send_data_to_uart5(uart5_tx_buffer[29]);
       poll_seq = next_poll_seq;
       next_poll_seq = 0;
    }

}

unsigned short int Modbus_CRC(uint8_t *buffer, uint16_t len)
{
    unsigned short int crc = 0xFFFF, pos,i;

    for (pos = 0; pos < len; pos++)
    {
        crc ^= (unsigned short int)uart5_tx_buffer[pos];          // XOR byte into least sig. byte of crc

        for(i = 8; i != 0; i--)
        {    // Loop over each bit
            if ((crc & 0x0001) != 0)
            {      // If the LSB is set
                crc >>= 1;                    // Shift right and XOR 0xA001
                crc ^= 0xA001;
            }
            else                            // Else LSB is not set
                crc >>= 1;                    // Just shift right
        }
    }
    return(crc);
  // Note, this number has low and high bytes swapped, so use it accordingly (or swap bytes)

}

