/***********************************************************************************************************************************

    Module name             =   One second once process.c
    Created By              =   Yuvaraj
    Created On              =   27.04.2023
    Formula used            =
    Interrupts used         =
    Description             =

    Modified By             =
    Modified On             =
    Reason for modification =

    Special function        =
*****************************************************************************************************************************************/


#include <stdbool.h>
#include <stdint.h>
//#include "inc/tm4c123gh6pm.h"

#include "inc/hw_memmap.h"
#include "driverlib/gpio.h"
#include "driverlib/interrupt.h"
#include "driverlib/pin_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/timer.h"
#include "driverlib/uart.h"
#include "driverlib/eeprom.h"


#include "Xvariable.h"
#include "Xflag.h"
#include "string.h"
#include "math.h"
#include "main.h"
#include "Macro.h"
#include "EEPROM.h"


void one_sec_once_process();
extern void ethernet_init();
void quadrant_update(unsigned int, unsigned char);
extern void fnSetNewIp();
extern void close_tcp_socket(unsigned int);


unsigned char LED_swap;


void one_sec_once_process()
{
    GPIO_PORTH_DATA ^= GPIO_PIN_2;

    if(timer.bit.ip_save_flag)
    {
        if(IP_address[0] > 100 && IP_address[0] < 200)
        {
            if(IP_address[1] > 100 && IP_address[1] < 200)
            {
                if(IP_address[2] > 0 && IP_address[0] < 200)
                {
                    if(IP_address[3] > 0)
                    {
                        fnSetNewIp();
                        if(timer.bit.ip_readed_flag == 0)
                        {
                            memcpy(&dummy.ch_area[0], &IP_address[0], 4);
                            EEPROMProgram(&dummy.ln_area, 0x400, 4);
                        }
                    }
                }
            }
        }
        timer.bit.ip_save_flag = 0;
        timer.bit.ip_readed_flag  = 0;
    }


    if(++PLC_port6000_timeout > 248)
    {
        PLC_port6000_timeout = 0;

       if(TCPIP.bit.PLC_port6000_closed == 0 && port6000_timeout_count < 9)
       {
           close_tcp_socket(6000);
           if(++port6000_timeout_count > 8)
               TCPIP.bit.PLC_port6000_closed = 1;
       }
    }

    if(++PLC_test_count > 10)
    {
        PLC_test_count = 0;
        PLC_test_start_flag = 1;
      //  OUT1_OFF_flag = 1;
        OUT1_ON_flag = 0;
        OUT1_ON_count = 0;
        OUT2_OFF_flag = 1;
        out2_on_time = 9;
    }
}


