/***********************************************************************************************************************************

    Module name             =   Output_control.c
    Created By              =   Yuvaraj
    Created On              =   27.04.2023
    Formula used            =
    Interrupts used         =
    Description             =

    Modified By             =
    Modified On             =
    Reason for modification =

    Special function        =
*****************************************************************************************************************************************/


#include <stdbool.h>
#include <stdint.h>
//#include "inc/tm4c123gh6pm.h"

#include "inc/hw_memmap.h"
#include "driverlib/gpio.h"
#include "driverlib/interrupt.h"
#include "driverlib/pin_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/timer.h"
#include "driverlib/uart.h"
#include "driverlib/eeprom.h"


#include "Xvariable.h"
#include "Xflag.h"
#include "string.h"
#include "math.h"
#include "main.h"
#include "Macro.h"
#include "EEPROM.h"
#include "Outputs.h"


void output_control();

void Solenoids_on(unsigned char);
void Solenoids2_on(unsigned char);
void Solenoids_off(unsigned char);
void Solenoids2_off(unsigned char);
void delay(unsigned char);
void output_EV_off();
void HC_output_test();

unsigned char out_data;
unsigned int out_data_clr;
unsigned char loop_count;
unsigned char output_pin;
unsigned char HC_test_count;

void output_control()
{
//===========Solenoid on - 1 to 8========================================
    out_data = Output_on.enable & 0x0000FF;
    out_data_clr = out_data;
    if((old_out_on_data[0] != out_data) && out_data > 0)
    {
      //  for(loop_count = 0; loop_count < 8; loop_count++)
        {
       //     output_pin = (1 << loop_count);
            if(out_data)// & output_pin)
            {
                Solenoids_on(out_data);
            }
        }
    }
    Output_on.enable &= ~out_data;
    old_out_on_data[0] = out_data;
//===========Solenoid on - 9 to 16========================================
    out_data = (Output_on.enable >> 8) & 0x0000FF;
    //out_data <<= 4;
    if((old_out_on_data[1] != out_data) && out_data > 0)
    {
      //  for(loop_count = 0; loop_count < 8; loop_count++)
        {
            //output_pin = (1 << loop_count);
            if(out_data)
            {
                Solenoids2_on(out_data);
            }
          //  output_pin = (1 << out_data);
          //  Solenoids2_on(output_pin);
        }
    }

    old_out_on_data[1] = out_data;
   // Output_on.enable &= ~(out_data >> 4);
    Output_on.enable &= ~(out_data << 8);
//===========Solenoid on - logic end========================================
    output_EV_off();
//===========High current output on logic========================================

}

void output_EV_off()
{
   // Output_off.disable = 0xffff;
    //===========Solenoid off - 1 to 8========================================
    out_data = Output_off.disable & 0x000FF;
    if(old_out_off_data[0] != out_data)
    {
       // for(loop_count = 0; loop_count < 8; loop_count++)
        {
            output_pin = (1 << loop_count);
            if(out_data)// & output_pin)
            {
                //output_pin = (1 << out_data);
                Solenoids_off(out_data);
             //   Output_off.disable &= ~(1<<loop_count);
            }
        }
    }
    old_out_off_data[0] = out_data;
    Output_off.disable &= ~out_data;
//===========Solenoid off - 9 to 16========================================
    out_data = (Output_off.disable >> 8) & 0x0000FF;
    //out_data <<= 4;
    if(old_out_off_data[1] != out_data)
    {
       // for(loop_count = 0; loop_count < 8; loop_count++)
        {
            output_pin = (1 << loop_count);
            if(out_data)// & output_pin)
            {
              //  output_pin = (1 << out_data);
                Solenoids2_off(out_data);
               // Output_off.disable &= ~(1<<(loop_count+8));
            }
        }
    }

    old_out_off_data[1] = out_data;
    Output_off.disable &= ~(out_data << 8);
//===========Solenoid off - logic end========================================

}


void Solenoids_on(unsigned char data_1)//SPI1 OUTPUT_1 to OUTPUT_8
{
    unsigned char status=0x01,x=0;

    Solenoid_status = data_1;

    DRV8860_Latch_Low
    DRV8860_clk_Low
    delay(1);

    for(x=0;x<8;x++)
    {
        if(Solenoid_status & (status << x))
            DRV8860_Data_High
        else
            DRV8860_Data_Low

        delay(1);
        DRV8860_clk_High
        delay(2);
        DRV8860_clk_Low
        delay(1);
    }

    delay(1);
    DRV8860_Latch_High
    DRV8860_Enable_High

}

void Solenoids2_on(unsigned char data_1)//SPI2 OUTPUT_9 to OUTPUT_16
{
    unsigned char status=0x01,x=0;

    Solenoid_status2 = data_1;

    DRV8860_Latch_Low2
    DRV8860_clk_Low2
    delay(1);

    for(x=0;x<8;x++)
    {
        if(Solenoid_status2 & (status << x))
            DRV8860_Data_High2
        else
            DRV8860_Data_Low2

        delay(1);
        DRV8860_clk_High2
        delay(2);
        DRV8860_clk_Low2
        delay(1);
    }

    delay(1);
    DRV8860_Latch_High2
    DRV8860_Enable_High2
}

void Solenoids_off(unsigned char data)//SPI1 OUTPUT_1 to OUTPUT_8
{
    unsigned char status=0x01,x=0;

    Solenoid_status = 0xff;
    Solenoid_status = 0;// ^= data;

    DRV8860_Latch_Low
    DRV8860_clk_Low
    SysCtlDelay(110);

    for(x=0;x<8;x++)
    {
        if(Solenoid_status & (status << x))
            DRV8860_Data_High
        else
            DRV8860_Data_Low

     //   delay(1);
        SysCtlDelay(110);
        DRV8860_clk_High
       // delay(2);
        SysCtlDelay(120);
        DRV8860_clk_Low
        SysCtlDelay(110);
       // delay(1);
    }

   // delay(1);
    SysCtlDelay(110);
    DRV8860_Latch_High
    DRV8860_Enable_High

}

void Solenoids2_off(unsigned char data)
{
    unsigned char status=0x01,x=0;

    Solenoid_status2 &= ~data;
    Solenoid_status2 = 0xff;
    Solenoid_status2 = 0;//^= data;

    DRV8860_Latch_Low2
    DRV8860_clk_Low2
    delay(1);

    for(x=0;x<8;x++)
    {
        if(Solenoid_status2 & (status << x))
            DRV8860_Data_High2
        else
            DRV8860_Data_Low2

        delay(1);
        DRV8860_clk_High2
        delay(2);
        DRV8860_clk_Low2
        delay(1);
    }

    delay(1);
    DRV8860_Latch_High2
    DRV8860_Enable_High2

}

void delay(unsigned char ms)/*in milliseconds*/
{
    /*delay_interval = ms+2;
    while(delay_interval > 0)
    {}*/

    unsigned int delay_time=0;

    for(delay_time = 0; delay_time < 100; delay_time++)
    {
    }
}

void HC_output_test()
{
    HC_test_count++;
    switch(HC_test_count)
    {
        case 1:
                OUTPUT1_OFF;
                OUTPUT8_ON;
            break;
        case 2:
                OUTPUT2_OFF;
                OUTPUT1_ON;
            break;
        case 3:
                OUTPUT3_OFF;
                OUTPUT2_ON;
            break;
        case 4:
                OUTPUT4_OFF;
                OUTPUT3_ON;
            break;
        case 5:
                OUTPUT5_OFF;
                OUTPUT4_ON;
            break;
        case 6:
                OUTPUT6_OFF;
                OUTPUT5_ON;
            break;
        case 7:
                OUTPUT7_OFF;
                OUTPUT6_ON;
            break;
        case 8:
                OUTPUT8_OFF;
               // OUTPUT9_OFF;
                OUTPUT7_ON;
            break;

        case 9:
            HC_test_count = 0;
            break;
    }
}



