
/* XDCtools Header files */
#include <xdc/std.h>
#include <xdc/runtime/System.h>

/* BIOS Header files */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
#include <stdbool.h>

/* TI-RTOS Header files */
#include <ti/drivers/GPIO.h>
#include <driverlib/gpio.h>
#include <driverlib/uart.h>
#include <driverlib/eeprom.h>
#include <driverlib/sysctl.h>
#include <ti/drivers/UART.h>
#include <ti/sysbios/knl/Semaphore.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/knl/Swi.h>

// Example/Board Header files
#include "Board.h"

#include <stdint.h>

#include <inc/hw_memmap.h>

#include "XFlag.h"
#include "Xvariable.h"
#include "string.h"
#include "Macro.h"
#include "Inputs.h"
#include "Outputs.h"



Clock_Struct Timer_Thread_Struct1_ms;
void TimerThread1_ms(UArg arg0);
void timer_1ms_init();


unsigned int input_portB;
unsigned int input_portC;
unsigned int input_portE;
unsigned int input_portF;
unsigned int input_portH;
unsigned int input_portK;
unsigned int input_portL;
unsigned int input_portM;
unsigned int input_portQ;
unsigned int input_portA;



void test_PLC();

//============ Clock Function ============================================================
void TimerThread1_ms(UArg arg0)
{
    if(delay_interval > 0)
       delay_interval--;

    Input.status = 0;
    input_portA = GPIOPinRead(GPIO_PORTA_BASE, 0X00FF);
    input_portB = GPIOPinRead(GPIO_PORTB_BASE, 0X00FF);
    input_portC = GPIOPinRead(GPIO_PORTC_BASE, 0X00FF);
    input_portE = GPIOPinRead(GPIO_PORTD_BASE, 0X00FF);
    input_portH = GPIOPinRead(GPIO_PORTH_BASE, 0X00FF);
    input_portK = GPIOPinRead(GPIO_PORTK_BASE, 0X00FF);
    input_portL = GPIOPinRead(GPIO_PORTL_BASE, 0X00FF);
    input_portQ = GPIOPinRead(GPIO_PORTQ_BASE, 0X00FF);




    //==========Input29 - PB2===========
    if((input_portB & 0x04)== 0)
    {
        Input.bit.Vaccum_presence_flag = 1;
    }


}

void timer_1ms_init()
{
    Clock_Params TimerThreadParams1_ms;
    Clock_Params_init(&TimerThreadParams1_ms);
    TimerThreadParams1_ms.startFlag = TRUE;
    TimerThreadParams1_ms.period = 1;   //========= 1 ms value

    Clock_construct(&Timer_Thread_Struct1_ms, (Clock_FuncPtr)TimerThread1_ms, 1, &TimerThreadParams1_ms);
}

void test_PLC()
{}

