
/* XDCtools Header files */
#include <xdc/std.h>
#include <xdc/runtime/System.h>

/* BIOS Header files */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
#include <stdbool.h>

/* TI-RTOS Header files */
#include <ti/drivers/GPIO.h>
#include <driverlib/gpio.h>
#include <driverlib/uart.h>
#include <driverlib/adc.h>
#include <driverlib/eeprom.h>
#include <driverlib/sysctl.h>
#include <ti/drivers/UART.h>
#include <ti/sysbios/knl/Semaphore.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/knl/Swi.h>

// Example/Board Header files
#include "Board.h"

#include <stdint.h>

#include <inc/hw_memmap.h>

#include "XFlag.h"
#include "Xvariable.h"
#include "string.h"
#include "Macro.h"

Semaphore_Handle semHandleTaskI2C;
Clock_Struct Timer_Thread_Struct;

void TimerThread(UArg arg0);
void timer_5ms_init();
extern void ADC_trigger();

unsigned char loop_counter;
unsigned char op_push_button_counter;

float Sensor_volt;
unsigned int Sensor_volt_tot_count;

extern unsigned int input_portB;
//============ Clock Function ============================================================
void TimerThread(UArg arg0)
{
    Input.status = 0;
    input_portB = GPIOPinRead(GPIO_PORTB_BASE, 0X00FF);

    //==========Input29 - PB2===========
    if((input_portB & 0x04)== 0)
    {
        Input.bit.Vaccum_presence_flag = 1;
    }
    //Input.bit.Vaccum_presence_flag = 1;

    if(Wafer_recording_flag == 0)
    {
        if(++ten_ms_counter > 4)
        {
            ten_ms_counter = 0;

            if(align_seq_no < 2 || align_seq_no > 8)
                ADC_trigger();

          //  if(Sensor_capture_start_flag == 0)
            //    ADC_trigger();
        }

        if(++One_sec_counter > 199)
        {
            One_sec_counter = 0;
            timer.bit.one_sec_completed_flag = 1;
        }

        for(loop_counter = 0; loop_counter < 14; loop_counter++)
        {
            if(solenoid_on_delay[loop_counter] > 0)
            {
                solenoid_on_delay[loop_counter]--;

                if(solenoid_on_delay[loop_counter] == 0)
                {
                    Output_on.enable &= ~(1<<loop_counter);
                    Output_off.disable |= (1<<loop_counter);
                }
            }
        }
    }

    if(++two_50_msec_counter > 20)
    {
        if(Wafer_recording_flag == 0)
        {
            two_50_msec_counter = 0;
            timer.bit.two_50ms_sec_flag = 1;
        }
    }

    if(wafer_time_clac_flag)
    {
        cycle_time += 5;
    }

    if(align_logic_delay > 0)
    {
        align_logic_delay--;
        if(align_logic_delay == 0)
            Align_seq_change_flag = 1;
    }

    if(distance_check > 300 && distance_check < 2500)
    {
        mc_status.Presence = '1';
    }
    else
        mc_status.Presence = '0';

}

void timer_5ms_init()
{
    Clock_Params TimerThreadParams;
    Clock_Params_init(&TimerThreadParams);
    TimerThreadParams.startFlag = TRUE;
    TimerThreadParams.period = 5;   //========= 5 ms value

    Clock_construct(&Timer_Thread_Struct, (Clock_FuncPtr)TimerThread, 2, &TimerThreadParams);
}

/*
//============ Clock Function ============================================================
void TimerThread1_ms(UArg arg0)
{

}

void timer_1ms_init()
{
    Clock_Params TimerThreadParams1_ms;
    Clock_Params_init(&TimerThreadParams1_ms);
    TimerThreadParams1_ms.startFlag = TRUE;
    TimerThreadParams1_ms.period = 1;   //========= 1 ms value

    Clock_construct(&Timer_Thread_Struct1_ms, (Clock_FuncPtr)TimerThread1_ms, 1, &TimerThreadParams1_ms);
}
*/
