/***********************************************************************************************************************************

    Module name             =   UART Functions.c
    Created By              =   Yuvaraj
    Created On              =   09.01.2020
    Formula used            =
    Interrupts used         =
    Description             =

    Modified By             = UART reassigned(UART5 added)
    Modified On             = 25.02.2020
    Reason for modification =

    Special function        =

    YBS ---- UART5
    RSM ---- UART3
    LED ---- UART2
    RAP ---- UART4
******************************************************************************************************************************************/


/* XDCtools Header files */
#include <xdc/std.h>
#include <xdc/runtime/System.h>

/* BIOS Header files */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
#include <stdbool.h>

/* TI-RTOS Header files */
#include <ti/drivers/GPIO.h>
#include <driverlib/gpio.h>
#include <driverlib/uart.h>
#include <driverlib/eeprom.h>
#include <driverlib/sysctl.h>
#include <ti/drivers/UART.h>
#include <ti/sysbios/knl/Semaphore.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/knl/Swi.h>

#include <ti/ndk/inc/usertype.h>
#include <ti/ndk/inc/bsd/socketndk.h>
#include <ti/ndk/inc/nettools/nettools.h>
#include <ti/ndk/inc/nettools/inc/dhcpif.h>
#include <ti/ndk/inc/nettools/netcfg.h>

/* Example/Board Header files */
#include "Board.h"
#include <stdint.h>
#include <inc/hw_memmap.h>

#include "XFlag.h"
#include "Xvariable.h"
#include "string.h"
#include "Macro.h"



void init_UARTs();
void start_sub_main_thread();
void Send_data_to_uart5(unsigned char, unsigned char);
void Send_data_to_rsm_uart(unsigned char);
void Send_data_to_led_uart(unsigned char);
void Send_data_to_RAP_uart(unsigned char);
void fnSetNewIp();
void init_uart1();
void init_uart2();
void init_uart3();
void init_uart4();
void init_uart5();

extern void SubMain_Function(UArg);
extern void TimerThread(UArg arg0);
void UART_REOPEN(int uartnum);


// Foresight Global Variable declaration

Semaphore_Struct semStructUART1, semStructUART2, semStructUART3, semStructUART4, semStructUART5, semStructMain;
Semaphore_Handle semHandleUART1, semHandleUART2, semHandleUART3, semHandleUART4, semHandleUART5, semHandleMain;
Clock_Struct clk0Struct;
Swi_Struct swiStructMain, swi1Struct;
Swi_Handle swiHandleMain, swi1Handle;

// Construct BIOS objects
Task_Struct taskUART1Struct, taskUART2Struct, taskUART3Struct, taskUART4Struct, taskUART5Struct, taskMainThreadStruct;
Char taskUART1Stack[TASKSTACKSIZE], taskUART2Stack[TASKSTACKSIZE],taskUART3Stack[TASKSTACKSIZE], taskUART4Stack[TASKSTACKSIZE], taskUART5Stack[TASKSTACKSIZE], taskMainThreadStack[TASKSTACKSIZE];
Task_Params taskParamsUART1, taskParamsUART2, taskParamsUART3, taskParamsUART4, taskParamsUART5, taskMainThread;

UART_Handle uart1,uart2,uart3,uart4,uart5;
int Task1_run_count=0, Task2_run_count=0, Task3_run_count=0, Task4_run_count=0, Task5_run_count=0;


/* END Global Declarations */

/* UART Call Back function */
/* Mohan 170819 Read function */
unsigned char uart_led, C_value51=0;
unsigned char uart7readbuf[20], C_value7=0, d=0;
unsigned char uart1readbuf[20], C_value1=0;

extern void YBS_UART_IntHandler(unsigned char);

/* UART 1 */
static void UART1IntHandlerRead( UART_Handle handle, void *buf, size_t count)
{

    Semaphore_post(semHandleUART1);

}
static void UART1IntHandlerWrite(UART_Handle handle, void *buf, size_t count)
{
    ////GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_4, 0x10);
     System_printf("WRITE 1");
     //System_flush();
     //null;
}

/* UART 2 */
static void UART2IntHandlerRead( UART_Handle handle, void *buf, size_t count)
{

}

static void UART2IntHandlerWrite(UART_Handle handle, void *buf, size_t count)
{
    //GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_4, 0);
     //System_printf("\n UART WRITE2 ");
     //System_flush();
}


/* UART 3 */
static void UART3IntHandlerRead( UART_Handle handle, void *buf, size_t count)
{

    //Semaphore_post(semHandleUART3);
}

static void UART3IntHandlerWrite(UART_Handle handle, void *buf, size_t count)
{
    ////GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_4, 0x10);
     System_printf("WRITE 3");
     //System_flush();
     //null;
}

/* UART 4 */

static void UART4IntHandlerRead( UART_Handle handle, void *buf, size_t count)
{
    //Semaphore_post(semHandleUART4);
}

static void UART4IntHandlerWrite(UART_Handle handle, void *buf, size_t count)
{
    ////GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_4, 0x10);
     System_printf("WRITE 4");
     //System_flush();
     //null;
}

static void UART5IntHandlerWrite(UART_Handle handle, void *buf, size_t count)
{
    System_printf("WRITE 5");
    //System_flush();
}


/*
 *  ======== UART TASK Function ========
 */
Void Task_UART1(UArg arg0, UArg arg1)
{
   //char input;
    UART_Params uartParams;
    UART_Params_init(&uartParams);

    uartParams.writeDataMode = UART_DATA_BINARY;
    uartParams.readDataMode = UART_DATA_BINARY;
    uartParams.readReturnMode = UART_RETURN_FULL;
    uartParams.readEcho = UART_ECHO_OFF;
    uartParams.baudRate = 19200;
    uartParams.readMode = UART_MODE_CALLBACK;
    uartParams.readCallback = UART1IntHandlerRead;
    uartParams.writeMode = UART_MODE_CALLBACK;
    uartParams.writeCallback = UART1IntHandlerWrite;
    uart1 = UART_open(Board_UART1, &uartParams);

    Task1_run_count++;
    if (uart1 == NULL)
    {
        System_abort("Error opening the UART #1");
    }
    while (1)
    {
        System_printf("UART 1 \n");

        System_flush();
        Semaphore_pend(semHandleUART1, BIOS_WAIT_FOREVER);
    }
}

Void Task_UART2(UArg arg0, UArg arg1)
{
   //char input;
    UART_Params uartParams;
    UART_Params_init(&uartParams);

    uartParams.writeDataMode = UART_DATA_BINARY;
    uartParams.readDataMode = UART_DATA_BINARY;
    uartParams.readReturnMode = UART_RETURN_FULL;
    uartParams.readEcho = UART_ECHO_OFF;
    uartParams.baudRate = 19200;
    uartParams.readMode = UART_MODE_CALLBACK;
    uartParams.readCallback = UART2IntHandlerRead;
    uartParams.writeMode = UART_MODE_CALLBACK;
    uartParams.writeCallback = UART2IntHandlerWrite;
    uart2 = UART_open(Board_UART2, &uartParams);

    Task2_run_count++;
    if (uart2 == NULL)
    {
        System_abort("Error opening the UART #2");
    }
    while (1)
    {
        System_printf("UART 2 \n");

        System_flush();
        Semaphore_pend(semHandleUART2, BIOS_WAIT_FOREVER);
    }
}

Void Task_UART3(UArg arg0, UArg arg1)
{
    //char input;
    UART_Params uartParams;
    UART_Params_init(&uartParams);

    uartParams.writeDataMode = UART_DATA_BINARY;
    uartParams.readDataMode = UART_DATA_BINARY;
    uartParams.readReturnMode = UART_RETURN_FULL;
    uartParams.readEcho = UART_ECHO_OFF;
    uartParams.baudRate = 115200;
    uartParams.readMode = UART_MODE_CALLBACK;
    uartParams.readCallback = UART3IntHandlerRead;
    uartParams.writeMode = UART_MODE_CALLBACK;
    uartParams.writeCallback = UART3IntHandlerWrite;
    uart3 = UART_open(Board_UART3, &uartParams);

    Task3_run_count++;
    if (uart3 == NULL)
    {
        System_abort("Error opening the UART #3");
    }

    while (1)
    {
        System_printf("UART 3\n");
       // UART_read(uart3, &input, 1);
        System_flush();

        Semaphore_pend(semHandleUART3, BIOS_WAIT_FOREVER);
    }
}

Void Task_UART4(UArg arg0, UArg arg1)
{
    UART_Params uartParams;
    UART_Params_init(&uartParams);

    uartParams.writeDataMode = UART_DATA_BINARY;
    uartParams.readDataMode = UART_DATA_BINARY;
    uartParams.readReturnMode = UART_RETURN_FULL;
    uartParams.readEcho = UART_ECHO_OFF;
    uartParams.baudRate = 19200;
    uartParams.readMode = UART_MODE_CALLBACK;
    uartParams.readCallback = UART4IntHandlerRead;
    uartParams.writeMode = UART_MODE_CALLBACK;
    uartParams.writeCallback = UART4IntHandlerWrite;
    uart4 = UART_open(Board_UART4, &uartParams);

    Task4_run_count++;
    if(uart4 == NULL)
    {
        System_abort("Error opening the UART #4");
    }

    while (1)
    {
        System_printf("UART 4\n");
       // UART_read(uart3, &input, 1);
        System_flush();

        Semaphore_pend(semHandleUART4, BIOS_WAIT_FOREVER);
    }
}



void init_UARTs()
{
    Board_initUART();

    //init_uart1();
    init_uart2();
    init_uart3();
    init_uart4();
    init_uart5();

}

void init_uart1()
{
    /* SEMAPHORE THREAD */
    Semaphore_Params semParamsUART1;
    Semaphore_Params_init(&semParamsUART1);
    Semaphore_construct(&semStructUART1, 1, &semParamsUART1);

    Task_Params_init(&taskParamsUART1);
    taskParamsUART1.stackSize = TASKSTACKSIZE;
    taskParamsUART1.stack = &taskUART1Stack;
    taskParamsUART1.priority = 1;
    taskParamsUART1.instance->name = "UART1_THREAD";
    Task_construct(&taskUART1Struct, (Task_FuncPtr)Task_UART1, &taskParamsUART1, NULL);
    semHandleUART1 = Semaphore_handle(&semStructUART1); //To obtain instance handle

}

void init_uart2()
{
    /* SEMAPHORE THREAD */
    Semaphore_Params semParamsUART2;
    Semaphore_Params_init(&semParamsUART2);
    Semaphore_construct(&semStructUART2, 1, &semParamsUART2);

    Task_Params_init(&taskParamsUART2);
    taskParamsUART2.stackSize = TASKSTACKSIZE;
    taskParamsUART2.stack = &taskUART2Stack;
    taskParamsUART2.priority = 10;
    taskParamsUART2.instance->name = "UART2_THREAD";
    Task_construct(&taskUART2Struct, (Task_FuncPtr)Task_UART2, &taskParamsUART2, NULL);
    semHandleUART2 = Semaphore_handle(&semStructUART2); //To obtain instance handle

}

void init_uart3()
{
    /* SEMAPHORE THREAD */
    Semaphore_Params semParamsUART3;
    Semaphore_Params_init(&semParamsUART3);
    Semaphore_construct(&semStructUART3, 1, &semParamsUART3);

    GPIOPinTypeGPIOOutput(GPIO_PORTP_BASE, GPIO_PIN_0);
    GPIOPinWrite(GPIO_PORTP_BASE, GPIO_PIN_0, 0);

    Task_Params_init(&taskParamsUART3);
    taskParamsUART3.stackSize = TASKSTACKSIZE;
    taskParamsUART3.stack = &taskUART3Stack;
    taskParamsUART3.priority = 9;
    taskParamsUART3.instance->name = "UART3_THREAD";
    Task_construct(&taskUART3Struct, (Task_FuncPtr)Task_UART3, &taskParamsUART3, NULL);
    semHandleUART3 = Semaphore_handle(&semStructUART3); //To obtain instance handle

}

void init_uart4()
{
    /* SEMAPHORE THREAD */
    Semaphore_Params semParamsUART4;
    Semaphore_Params_init(&semParamsUART4);
    Semaphore_construct(&semStructUART4, 1, &semParamsUART4);

    Task_Params_init(&taskParamsUART4);
    taskParamsUART4.stackSize = TASKSTACKSIZE;
    taskParamsUART4.stack = &taskUART4Stack;
    taskParamsUART4.priority = 8;
    taskParamsUART4.instance->name = "UART4_THREAD";
    Task_construct(&taskUART4Struct, (Task_FuncPtr)Task_UART4, &taskParamsUART4, NULL);
    semHandleUART4 = Semaphore_handle(&semStructUART4); //To obtain instance handle
}


void start_sub_main_thread()
{
    /* CLOCK SUB MAIN */
     Clock_Params clkParamsSubMain;
     Clock_Params_init(&clkParamsSubMain);
     clkParamsSubMain.startFlag = TRUE;
     clkParamsSubMain.period = CLOCK_SUBMAIN_DURATION;

     Clock_construct(&clk0Struct, (Clock_FuncPtr)SubMain_Function, 1, &clkParamsSubMain);
}

void Send_data_to_uart5(unsigned char length, unsigned char ybs_or_rsm)
{
    UART5_TX_Enable;
    GPIOPinWrite(GPIO_PORTP_BASE, GPIO_PIN_0, GPIO_PIN_0);
    unsigned char ybs_dummy_var;//,send_len;

    ybs_dummy_var = 200;
    while(ybs_dummy_var > 0)
        ybs_dummy_var--;
    RS485_rply_start_flag = 0;

    SysCtlDelay(110);

    if(RS485_rply_start_flag == 0)
    {
        UART_write(uart3, &uart5_tx_buffer[0], length);
        while(UARTBusy(UART3_BASE));
        C_value51 = 0;

        memset(&uart5_rx_buffer[0],0,20);
        ybs_dummy_var = 200;
        while(ybs_dummy_var > 0)
            ybs_dummy_var--;
        C_value51 = 0;
        UART5_RX_Enable;
        GPIOPinWrite(GPIO_PORTP_BASE, GPIO_PIN_0, 0);
        UART_read(uart5, &uart5_rx_buffer, uart5_read_byte_count);
    }
    else
    {
        UART_REOPEN(5);
        RS485_rply_start_flag = 0;
    }
}

static void UART5IntHandlerRead( UART_Handle handle, void *buf, size_t count)
{
    C_value51 = count;

    if(C_value51 >= uart5_read_byte_count)             //with senFail,AB slip,25th sensor rpm
    {
        memcpy(&uart5_rx_Proc_buffer[0], &uart5_rx_buffer[0], C_value51);

        if(uart5_rx_Proc_buffer[0] == 1)
        {
            Uart5_read_compltd_flag = 1;
            RS485_rply_start_flag = 0;

            dummy.ln_area = 0;
            dummy.ch_area[1] = uart5_rx_Proc_buffer[3]; //Register starting address 2 bytes. ex: 40001, 0, 01
            dummy.ch_area[0] = uart5_rx_Proc_buffer[4];

            switch(poll_seq)
            {
                case 1:
                    Drive.Motor_Enocder_position = dummy.ln_area;
                    break;
                case 2:
                    Drive.Motor_Speed = dummy.ln_area;
                    break;

                case 5:
                    dummy.ch_area[1] = uart5_rx_Proc_buffer[4]; //Register starting address 2 bytes. ex: 40001, 0, 01
                    dummy.ch_area[0] = uart5_rx_Proc_buffer[5];
                    if(Drive.Set_Speed == dummy.ln_area)
                        Set_speed_updated_flag = 1;
                    break;
                default:
                    break;
            }

        }
    }
}

Void Task_UART5(UArg arg0, UArg arg1)
{
    UART_Params uartParams;
    UART_Params_init(&uartParams);

    uartParams.writeDataMode = UART_DATA_BINARY;
    uartParams.readDataMode = UART_DATA_BINARY;
    uartParams.readReturnMode = UART_RETURN_FULL;
    uartParams.readEcho = UART_ECHO_OFF;
    uartParams.baudRate = 19200;
    uartParams.parityType = UART_PAR_EVEN;
    uartParams.readMode = UART_MODE_CALLBACK;
    uartParams.readCallback = UART5IntHandlerRead;
    uartParams.writeMode = UART_MODE_CALLBACK;
    uartParams.writeCallback = UART5IntHandlerWrite;
    uart5 = UART_open(Board_UART5, &uartParams);

    Task5_run_count++;
    if (uart5 == NULL) {
        System_abort("Error opening the UART #5");
    }
    while (1)
    {
        System_printf("UART 5 \n");

        System_flush();
        Semaphore_pend(semHandleUART5, BIOS_WAIT_FOREVER);
    }
}

void init_uart5()
{
    /* SEMAPHORE THREAD */
    /* SEMAPHORE THREAD */
        Semaphore_Params semParamsUART5;
        Semaphore_Params_init(&semParamsUART5);
        Semaphore_construct(&semStructUART5, 1, &semParamsUART5);

    //========= UART 5 initialize============================================================
        GPIOPinTypeGPIOOutput(GPIO_PORTC_BASE, GPIO_PIN_5);
        GPIOPinWrite(GPIO_PORTC_BASE, GPIO_PIN_5, 0);
        Task_Params_init(&taskParamsUART5);
        taskParamsUART5.stackSize = TASKSTACKSIZE;
        taskParamsUART5.stack = &taskUART5Stack;
        taskParamsUART5.priority = 11;
        taskParamsUART5.instance->name = "UART5_THREAD";
        Task_construct(&taskUART5Struct, (Task_FuncPtr)Task_UART5, &taskParamsUART5, NULL);
        semHandleUART5 = Semaphore_handle(&semStructUART5); //To obtain instance handle
}

void Send_data_to_rsm_uart(unsigned char length)
{
    RSM_TX_Enable;
    unsigned int rsm_dummy_var;//,send_len;

    rsm_dummy_var = 40;
    while(rsm_dummy_var > 0)
        rsm_dummy_var--;

    UART_write(uart3, &rsm_uart_tx_buffer, length);
    while(UARTBusy(UART3_BASE));

    RSM_RX_Enable;
}

void Send_data_to_led_uart(unsigned char length)
{
    //LED_TX_Enable;
   // RAP_TX_Enable;
    unsigned char send_len;
    unsigned int led_dummy_var;

    for(send_len = 0; send_len < length; send_len++)
    {
     //  UART_write(uart2, &led_uart_tx_buffer[send_len], 1);
       //UART_write(uart4, &led_uart_tx_buffer[send_len], 1);

       led_dummy_var = 30000;
       while(led_dummy_var > 0)
           led_dummy_var--;
    }

    //LED_RX_Enable;
    //RAP_RX_Enable;
}

void Send_data_to_RAP_uart(unsigned char length)
{
   //RAP_TX_Enable;
    unsigned int rap_dummy_var;//,send_len;

    rap_dummy_var = 40;
    while(rap_dummy_var > 0)
        rap_dummy_var--;

   // UART_write(uart4, &led_uart_tx_buffer[0], length);

  //  RAP_RX_Enable;
}


void fnSetNewIp()
{
    char newip[16];
    unsigned char temp_ip[4];
    char *HostName = "_csl_";
    IPN IPTmp;

    CI_IPNET NA;
    CI_ROUTE RT;

    HANDLE hCfgIpAddr, hCfg;
    memcpy(&temp_ip[0], &IP_address[0],4);

    Board_initEMAC();

    newip[2] = (temp_ip[0] % 10) | 0x30;
    temp_ip[0] /= 10;
    newip[1] = (temp_ip[0] % 10) | 0x30;
    temp_ip[0] /= 10;

    if(temp_ip[0] > 0)
        newip[0] = (temp_ip[0] % 10) | 0x30;
    else
        newip[0] = ' ';

    newip[3] = '.';

    newip[6] = (temp_ip[1] % 10) | 0x30;
    temp_ip[1] /= 10;
    newip[5] = (temp_ip[1] % 10) | 0x30;
    temp_ip[1] /= 10;
    if(temp_ip[1] > 0)
        newip[4] = (temp_ip[1] % 10) | 0x30;
    else
        newip[4] = ' ';

    newip[7] = '.';

    newip[10] = (temp_ip[2] % 10) | 0x30;
    temp_ip[2] /= 10;
    if(temp_ip[2] > 0)
        newip[9] = (temp_ip[2] % 10) | 0x30;
    else
        newip[9] = ' ';
    temp_ip[2] /= 10;
    if(temp_ip[2] > 0)
        newip[8] = (temp_ip[2] % 10) | 0x30;
    else
        newip[8] = ' ';

    newip[11] = '.';

    newip[14] = (temp_ip[3] % 10) | 0x30;
    temp_ip[3] /= 10;
    if(temp_ip[3] > 0)
        newip[13] = (temp_ip[3] % 10) | 0x30;
    else
        newip[13] = ' ';
    temp_ip[3] /= 10;
    if(temp_ip[3] > 0)
        newip[12] = (temp_ip[3] % 10) | 0x30;
    else
     newip[12] = ' ';

    newip[15] = 0;
    // Setup manual IP address
    bzero(&NA, sizeof(NA));
    NA.IPAddr = inet_addr(newip);
    NA.IPMask = inet_addr("255.255.255.0");
    strcpy(NA.Domain, "demo.net");
    NA.NetType = 0;
    System_flush();
    // get the current static IP entry
    CfgGetEntry(0, CFGTAG_IPNET, 1, 1, &hCfgIpAddr);

    // remove the current static IP entry
    CfgRemoveEntry(0, hCfgIpAddr);

    // add a new static IP entry
    CfgAddEntry(0, CFGTAG_IPNET, 1, 0,
    sizeof(CI_IPNET), (UINT8 *)&NA, 0);

    // Add the default gateway.
    bzero( &RT, sizeof(RT) );
    RT.IPDestAddr = 0;
    RT.IPDestMask = 0;
    RT.IPGateAddr = inet_addr("192.168.1.1");

    hCfg = CfgNew();
    CfgAddEntry( hCfg, CFGTAG_SYSINFO, CFGITEM_DHCP_HOSTNAME, 0,
    strlen(HostName), (UINT8 *)HostName, 0 );

    // Add the route
    CfgAddEntry( hCfg, CFGTAG_ROUTE, 0, 0, sizeof(CI_ROUTE), (UINT8 *)&RT, 0 );

    // Manually add the DNS server when specified
    IPTmp = inet_addr("192.168.1.5");
    if(IPTmp)
    {
        CfgAddEntry( hCfg, CFGTAG_SYSINFO, CFGITEM_DHCP_DOMAINNAMESERVER,0, sizeof(IPTmp), (UINT8 *)&IPTmp, 0 );
    }
}

//  ======== UART Reopen TASK Function ========

void UART_REOPEN(int uartnum)
{
    UART_Params uartParams;
    UART_Params_init(&uartParams);

    uartParams.writeDataMode = UART_DATA_BINARY;
    uartParams.readDataMode = UART_DATA_BINARY;
    uartParams.readReturnMode = UART_RETURN_FULL;
    uartParams.readEcho = UART_ECHO_OFF;
    uartParams.baudRate = 19200;
    uartParams.readMode = UART_MODE_CALLBACK;
    uartParams.writeMode = UART_MODE_CALLBACK;
    System_printf("Re-opening the UART #%d",uartnum);

    if(uartnum == 1)
    {
        UART_close(uart1);
        uartParams.readCallback = UART1IntHandlerRead;
        uartParams.writeCallback = UART1IntHandlerWrite;
        uart1 = UART_open(Board_UART1, &uartParams);
        if(uart1 == NULL)
        {
            System_abort("Error opening the UART #1");
        }
    }
    else if(uartnum==2)
    {
        UART_close(uart2);
        uartParams.readCallback = UART2IntHandlerRead;
        uartParams.writeCallback = UART2IntHandlerWrite;
        uart2 = UART_open(Board_UART2, &uartParams);
        if(uart2 == NULL)
        {
            System_abort("Error opening the UART #2");
        }
    }
    else if(uartnum == 3)
    {
        UART_close(uart3);
        uartParams.readCallback = UART3IntHandlerRead;
        uartParams.writeCallback = UART3IntHandlerWrite;
        uart3 = UART_open(Board_UART3, &uartParams);
        if(uart3 == NULL)
        {
            System_abort("Error opening the UART #3");
        }
    }
    else if(uartnum==4)
    {
        UART_close(uart4);
        uartParams.readCallback = UART4IntHandlerRead;
        uartParams.writeCallback = UART4IntHandlerWrite;
        uart4 = UART_open(Board_UART4, &uartParams);
        if(uart4 == NULL)
        {
            System_abort("Error opening the UART #4");
        }
    }
    else if(uartnum==5)
    {
       UART_close(uart5);
       uartParams.readCallback = UART5IntHandlerRead;
       uartParams.writeCallback = UART5IntHandlerWrite;
       uart5 = UART_open(Board_UART5, &uartParams);
       if(uart5 == NULL)
       {
           System_abort("Error opening the UART #5");
       }
    }
    System_printf("\nUART #%d Opened ",uartnum);
    System_flush();
}


