//---------------------------------------------------------------------------------------------------------------
//  sm_comm.cc    dispatch: BT_COMM_TASK
//
//  Communicating via "Serial Port Connection" between here and iOS or Android.
//
//  Copyright (c) 2025 Doug Broadwell, all rights reserved.
//---------------------------------------------------------------------------------------------------------------
//  The Backlight uses a DSD Tech HM-11 Bluetooth module to communicate with smart phones.  It is configured
//  using "AT" like modem commands for configuration and once connected becomes a "wire" - passing data
//  transparently to the phone.
//
//  After every "AT" command the software must wait for the response to that command before issuing another.
//  The file sm_bt_at_comnd.cc takes care of issuing commands and waiting for the response and, optionally,
//  checking that the response was what was expected and also checking for a lack of response.
//
//  sm_bluetooth.cc keeps track of the state of the Bluetooth connection - Inactive, Truing to Advertise,
//  Advertising, Connected, and Disconnected.  The function BtInitialize() in sm_bluetooth.cc sends the commands
//  to set up the module and start it Advertising and waits until the commands either succeed or fail.
//---------------------------------------------------------------------------------------------------------------


#include "common.h"
#include "bt_comm.h"
#include "dispatch.h"
#include "error.h"
#include "sm_bluetooth.h"
#include "uarts.h"

#include <stdio.h>
#include <string.h>




//-------------------------
//  FORWARD DECLARATIONS  |
//---------------------------------------------------------------------------------------------------------------
void PingRx ( u8, u8, char* );
void PingAck( u8, u8, char* );
//---------------------------------------------------------------------------------------------------------------




//-----------------------------------
//  MESSAGE HANDLER DISPATCH TABLE  |
//---------------------------------------------------------------------------------------------------------------

const struct sBtCommMsgDispatch {

    u8     MsgNmbr;                                         // Message number.
    u8     MsgLength;                                       // Payload size.
    void(*pFunct)(u8 MsgNmbr, u8 MsgLength, char* pMsg);    // Function to deal with the message.
    const char* Name;                                       // Name of the Message.

} BtMsg[] {

// MsgNmbr  Length  Function     Name               BL->Phone  Phone->BL     Type
//-------------------------------------------------------------------------------------
     0,       0,    PingRx,     "Ping",         //     X          X       Request
     1,       0,    PingAck,    "Ping Ack",     //     X          X           Response
};

const uint BtMsgSize = sizeof(BtMsg) / sizeof(BtMsg[0]);

//---------------------------------------------------------------------------------------------------------------




//-----------------------------------------------
//  DISPATCH TO FUNCTION TO HANDLE THE MESSAGE  |  BT_COMM_TASK
//---------------------------------------------------------------------------------------------------------------
//  struct sBtComm_Msg {
//      u8     MsgNmbr;     // Message number.
//      u8     MsgLength;   // Payload size.
//      char*  pPayload;    // Pointer to message payload.
//  };
//---------------------------------------------------------------------------------------------------------------
void BT_Comm_Dispatch(u16 Msg_Cnt, void* vMsg, ulong Ticks) {           //
                                                                        //
    struct sBtComm_Msg* pMsg;                                           //
    pMsg = (struct sBtComm_Msg*)vMsg;                                   // Cast message pointer from "void".
                                                                        //
    if(BT_DATA_MSG_NOT_CONNECTED != BtConnected) {                      // Not in the correct mode.
        sprintf(sBuff, "Enumeration: %d", BT_DATA_MSG_NOT_CONNECTED);   //
        Error(BT_DATA_MSG_NOT_CONNECTED, sBuff);                        //
    }                                                                   //
                                                                        //
    while( Msg_Cnt-- ) {                                                // For all the messages ...
                                                                        //
        if(pMsg->MsgNmbr >= BtMsgSize) {                                // Bad message number.
            sprintf(sBuff, "Invalid Msg #: %d", pMsg->MsgNmbr);         //
            Error(BT_INVALID_MSG_NMB, sBuff);                           //
        }                                                               //
        if(pMsg->MsgLength >= BtInLinBuffSize - 3) {                    // Length > maximum payload length.
            sprintf(sBuff, "Invalid Length: %d", pMsg->MsgLength);      //
            Error(BT_INVALID_MSG_SIZE, sBuff);                          //
        }                                                               //
        (*BtMsg[pMsg->MsgNmbr].pFunct)(pMsg->MsgNmbr,                   // Dispatch to Msg handling function.
                                       pMsg->MsgLength,                 //
                                       pMsg->pPayload );                //
        if( Msg_Cnt ) pMsg = (struct sBtComm_Msg*) Get_Message();       // Get next message if there is one.
    }                                                                   // Loop for next message.
}                                                                       //
//---------------------------------------------------------------------------------------------------------------




//-----------------
//  HANDLE PINGS  |
//---------------------------------------------------------------------------------------------------------------
void PingRx(  u8 MsgNmbr, u8 MsgLength, char* pMsg) {


}
//---------------------------------------------------------------------------------------------------------------
void PingAck( u8 MsgNmbr, u8 MsgLength, char* pMsg) {


}
//---------------------------------------------------------------------------------------------------------------


