//--------------------------------------------------------------------------------------------------
//  can_local.h
//
//  CAN Bus functions.
//
//  Called can_local.h instead of can.h as can.h is in the TivaWare library.
//
//  Copyright (c) 2025 Doug Broadwell, all rights reserved.
//--------------------------------------------------------------------------------------------------

#ifndef CAN_LOCAL_H_
#define CAN_LOCAL_H_

#include "common.h"
#include "defines.h"

//#define ENABLE_CAN2     // Enable Can 2 (CAN0 in the MPU). Moved to defines.h

void SendCan1Msg(u32 Id, u8* pMsg, u8 Length);
void SendCan1Msg(u32 Id, u32 Data, u8 Length);

#ifdef ENABLE_CAN2
    void Can2LoopbackTest(void);                        // ** FIXME **
    void SendCan2Msg(u32 ID, u8* pMsg, u8 Length);
    void SendCan2Msg(u32 Id, u32 Data, u8 Length);
#endif

void Init_CAN(void);
uint GetRpm(void);

enum CanLastError { CAN_NO_ERROR, STUFF_ERROR, FORMAT_ERROR, ACK_ERROR,
                    BIT_1_ERROR, BIT_0_ERROR, CRC_ERROR, NO_EVENT_ERROR };


#endif /* CAN_LOCAL_H_ */
