//---------------------------------------------------------------------------------------------------------------
//  common.h
//
//  DEFINITIONS COMMON TO ALL FILES
//
//  Copyright (c) 2025 Doug Broadwell, all rights reserved.
//---------------------------------------------------------------------------------------------------------------

#ifndef COMMON_H_

    #define COMMON_H_


//  #include <stdint.h>		// As recommended to use TivaWare libraries.

    #include "defines.h"
    #include "stdint.h"         // 5/4/19 Move from Mentor to CCS.
    #include <stdbool.h>
    #include "tm4c123ae6pm.h"


    //-- CLARIFYING DEFINITIONS ------------------------------------------------------------------------------//

    #define  PUBLIC
    #define  PRIVATE    static  // Remember, not to be used with variables within
                                // a function, where "static" really means static.
    #define  SUCCESS    1
    #define  FAILURE    0

    #define  ON         1
    #define  OFF        0

    #define  NO_DATA    0	// To indicate Events where the Data is not used.

    #ifndef  NULL
      #define  NULL     0
    #endif

    #define INVAL_DATA -1


    //-- COMPILER / CPU SPECIFIC TYPEDEFS FOR ARM ------------------------------------------------------------//

    typedef char               byte;	 // 8 bits.
    typedef signed char        s8;
    typedef unsigned char      ubyte;
    typedef unsigned char      uchar;
    typedef unsigned char      u8;

    typedef short              word;	 // 16 bits.
    typedef short              s16;
    typedef unsigned short     uword;
    typedef unsigned short     u16;

    typedef unsigned int       uint;	 // 32 bits.
    typedef int                s32;
    typedef unsigned int       u32;
    typedef unsigned long      ulong;

    typedef long long          s64;	 // 64 bits.
    typedef unsigned long long u64;

//  typedef u32                uint32_t; // G+



    //-- CPU CLOCK SPEED -------------------------------------------------------------------------------------//

    const u32 CPU_CLK_SPEED = 80000000;  // Allows us to catch code relying on the CPU clock if we change it.


    //-- HELPER FUNCTION DEFINITIONS -------------------------------------------------------------------------//

    #define  MIN(a,b)   ((a) < (b) ? (a) : (b))
    #define  MAX(a,b)   ((a) > (b) ? (a) : (b))


    //-- PROGRAM SPECIFIC TYPEDEFS ---------------------------------------------------------------------------//

    typedef  u16  event_t;
    typedef  s32  event_data_t;
    typedef  s32  handle_t;
    typedef  u16  sm_t;
    typedef  s16  state_nmb_t;
    typedef  s32  count_t;


    //-- GPIO BITS -------------------------------------------------------------------------------------------//

    const u8 PA_Can1Rx_BIT      = 0x01;
    const u8 PA_Can1Tx_BIT      = 0x02;
    const u8 PA_BriteSw1_BIT    = 0x04;
    const u8 PA_BriteSw2_BIT    = 0x08;
    const u8 PA_4_BIT           = 0x10;
    const u8 PA_5_BIT           = 0x20;
    const u8 PA_6_BIT           = 0x40;
    const u8 PA_7_BIT           = 0x80;

    const u8 PB_BtRx_BIT        = 0x01;
    const u8 PB_BtTx_BIT        = 0x02;
    const u8 PB_TP5_BIT         = 0x04;
    const u8 PB_BtDiscon_BIT    = 0x08;
    const u8 PB_Can2Rx_BIT      = 0x10;
    const u8 PB_Can2Tx_BIT      = 0x20;
    const u8 PB_Pwm2_1_BIT      = 0x40;         // M0-0

    const u8 PC_DebugRx_BIT     = 0x10;
    const u8 PC_DebugTx_BIT     = 0x20;
    const u8 PC_TP6_BIT         = 0x40;
    const u8 PC_TP7_BIT         = 0x80;

    const u8 PD_Pwm1_2_BIT      = 0x01;
    const u8 PD_TP11_BIT        = 0x02;
    const u8 PD_DipSw1_BIT      = 0x04;
    const u8 PD_DipSw2_BIT      = 0x08;
    const u8 PD_TP12_BIT        = 0x10;
    const u8 PD_TP13_BIT        = 0x20;
    const u8 PD_6_BIT           = 0x40;
    const u8 PD_7_BIT           = 0x80;

    const u8 PE_Fault3_BIT      = 0x01;
    const u8 PE_Fault2_BIT      = 0x02;
    const u8 PE_Fault1_BIT      = 0x04;
    const u8 PE_3_BIT           = 0x08;
    const u8 PE_Pwm1_1_BIT      = 0x10;
    const u8 PE_TP14            = 0x20;

    const u8 PF_BtRts_BIT       = 0x01;
    const u8 PF_BtCts_BIT       = 0x02;
    const u8 PF_Pwm3_2_BIT      = 0x04;
    const u8 PF_TP15_BIT        = 0x08;
    const u8 PF_4_BIT           = 0x10;

    const u8 PG_HB_LED_BIT      = 0x01;
    const u8 PG_ER_LED_BIT      = 0x02;
    const u8 PG_Pwm3_1_BIT      = 0x04;
    const u8 PG_TP16_BIT        = 0x08;
    const u8 PG_Pwm2_2_BIT      = 0x10;
    const u8 PG_TP17_BIT        = 0x20;


    //-- INLINE FUNCTIONS  -----------------------------------------------------------------------------------//


    //---------------
    //  DEBUG LEDS  |
    //----------------------------------------------------------------------
    void inline LED_1_On(void) {
    	GPIO_PORTG_DATA_R |= PG_HB_LED_BIT;
    }
    void inline LED_1_Off(void) {
    	GPIO_PORTG_DATA_R &= ~PG_HB_LED_BIT;
    }
    void inline LED_1_Toggle(void) {
    	GPIO_PORTG_DATA_R ^= PG_HB_LED_BIT;
    }
    void inline HB_LED_On(void)     { LED_1_On();     }
    void inline HB_LED_Off(void)    { LED_1_Off();    }
    void inline HB_LED_Toggle(void) { LED_1_Toggle(); }
    //----------------------------------------------------------------------
    void inline LED_2_On(void) {
    	GPIO_PORTG_DATA_R |= PG_ER_LED_BIT;
    }
    void inline LED_2_Off(void) {
    	GPIO_PORTG_DATA_R &= ~PG_ER_LED_BIT;
    }
    void inline LED_2_Toggle(void) {
    	GPIO_PORTG_DATA_R ^= PG_ER_LED_BIT;
    }
    void inline ERR_LED_On(void)     { LED_2_On();     }
    void inline ERR_LED_Off(void)    { LED_2_Off();    }
    void inline ERR_LED_Toggle(void) { LED_2_Toggle(); }
    //----------------------------------------------------------------------



#endif  /* COMMON_H_ */
