//---------------------------------------------------------------------------------------------------------------
//  eeprom.h
//
//  Copyright (c) 2025 Doug Broadwell, all rights reserved.
//---------------------------------------------------------------------------------------------------------------

#ifndef EEPROM_H_
#define EEPROM_H_

#include "led.h"

//------ Format of Multi-Read Structure ------//

enum eVarType { NULL_T, UINT_T, FLOAT_T, COLOR_T };

struct sMultiRead {
    const u16       EEAddr;               // Address of data in EEProm
          void*     pVar;                 // Pointer to the variable to write to.
    const eVarType  Type;                 // Type of the variable.
    const uint      UintDefault;          // Default of uint data.
    const float     FloatDefault;         // Default of float data.
    const eColors   ColorDefault;         // Default Color Index.
};




//------------ EEProm Addresses --------------//


//---------------------
//  EEPROM ADDRESSES  |
//---------------------------------------------------------------------------------------------------------------
// These are 32 bit word addresses, not byte addresses.
//
//  ***************************************************************
//  ** IMPORTANT **  Keep in sync with array in ListEEPromData() **
//  ***************************************************************

const u16 MagicAddr          =  0;
const u16 RpmCaution1Addr    =  1;
const u16 RpmCaution2Addr    =  2;
const u16 RpmWarnAddr        =  3;
const u16 RpmOverAddr        =  4;
const u16 BlinkThresholdAddr =  5;
const u16 NormalColorAddr    =  6;
const u16 Caution1ColorAddr  =  7;
const u16 Caution2ColorAddr  =  8;
const u16 RpmWarnColorAddr   =  9;
const u16 RpmOverColorAddr   = 10;



//------------- Single Word Data -------------//


//-------------- Multi-Word Data -------------//


//------------- Other Functions --------------//

   void  Init_EEProm(void);
   bool  CheckEEPromDone(void);
   void  Reset_EEProm_Data(void);
   uint  MassEraseEEProm(void);
    u32  ReadEEPromLin( u32 Addr);
  float  fReadEEPromLin(u32 Addr);
   void  WriteEEPromLin(u32 Addr,    u32 Data);
   void  WriteEEPromLin(u32 Addr, float fData);
   void  ListEEPromData(void);
   void  ReadInVars(const sMultiRead* pData);

   void ReadInBLThreshVars(sBacklightThresholds* pArray, uint Size);
   void ReadInNeedleVars(sNeedleThresholds* pArray, uint Size);
   void ReadInSpeedoVars(sSpeedoBLThresholds* pArray, uint Size);



//------------- Global Variables ---------------//


//------------- Global Constants ---------------//

const uint MagicNumber = 0x9B5AF4B2;
extern const uint EEPROM_SIZE;				// Size of EEProm in 32 Bit Words.


#endif /* EEPROM_H_ */
