//---------------------------------------------------------------------------------------------------------
//  error.cc
//
//  Handle errors.
//
//  Copyright (c) 2025 Doug Broadwell, all rights reserved.
//---------------------------------------------------------------------------------------------------------


#include "common.h"
#include "uarts.h"
#include "error.h"
//#include "sm_main.h"
//#include "beep.h"
#include "interrupt.h"

#include "systick.h"

#include <string.h>





//------------------
//  ERROR STRINGS  |
//---------------------------------------------------------------------------------------------------------------
const char* Error_Str[] = {                             //
                                                        //
    "BT_Comm_Dispatch() while Bluetooth not connected", //  1
    "Invalid value in a switch() statement'",           //  2
    "ISR Message Overflow in ISR_Send_Message()",       //  3
    "Send_Event() Message Error",                       //  4
    "Invalid State Machine",                            //  5
    "Invalid Event",                                    //  6
    "Unhandled Event",                                  //  7
    "Invalid State",                                    //  8
    "No More Timers",                                   //  9
    "Timer Queue Overflow",                             // 10
    "Initialize EEPROM Failure",                        // 11
    "Event Subscribe Array Full",                       // 12
    "Debug Output Buffer Overflow",                     // 13
    "Debug Input Buffer Overflow",                      // 14
    "RxCharacter() Null Callback Addr",                 // 15
    "Write EEProm Failed",                              // 16
    "Send_Message() queue overflow",                    // 17
    "Bluetooth Circular Input Buffer Overflow",         // 18
    "Bluetooth Circular Output Buffer Overflow",        // 19
    "AT Command Response Buffer Overflow.",             // 20
    "Invalid last entry in ListEEPromData() table",     // 21
    "Invalid BT Message Number",                        // 22
    "AT Command or Expected Response Buffer Overflow",  // 23   *FIXME* Don't think this is used.
                                                        //
    "!! Last Error Number !!",                          // 24
};                                                      //
//---------------------------------------------------------------------------------------------------------------
//  NOT OPERATIONAL CODE
//  This will throw a compile time error: "size of array 'arry' is negative", if the Error_Str[]
//  array is not the same size as the eError_Nmbs enumerations.  This is contained inside a struct
//  that never gets instantiated so it never takes up any memory space.

struct NeverGetsInstantiated__ {
    int arry[ sizeof(Error_Str) / sizeof(Error_Str[0]) == LAST_Error_Nmbs ? 1 : -1 ];
};
//---------------------------------------------------------------------------------------------------------------




//---------------------------------------------------------------------------------------------------------------
void Init_Error(void) {

    ERR_LED_Off();
}
//---------------------------------------------------------------------------------------------------------------

/*
#include <stdio.h>      *FIXME*  G+
#include "dispatch.h"
#include "state.h"
*/
//----------------
//  DEBUG ERROR  |
//---------------------------------------------------------------------------------------------------------------
//  Blink LED 1 fast and blink the error number on LED 2.

void Error(eError_Nmbs Error_Number) { Error(Error_Number, (const char*)""); }

//---------------------------------------------------------------------------------------------------------------

void Error(eError_Nmbs Error_Number, const char* Message) {

    u16  Cntr      = 0;
    u16  Err_Dly   = 0;
    int  PwrOffDly = 925;                           // ~20 seconds. Value for 60MHz clock.
    u16  Err_Nmbr  = Error_Number << 1;		    // Multiply by 2.
    volatile u32 i;                                 // volatile to increase the delay time.
    char pStr[120];
//  const char* pStr = Error_Str[Error_Number-1];   // Pointer to error message.

    strcpy(pStr, "\n\n\r Error: ");
    strcat(pStr, Error_Str[Error_Number-1]);
    strcat(pStr, ": ");
    strcat(pStr, Message);
    strcat(pStr, "\r\n");
    uint Idx = 0;

    ERR_LED_Off();
/*
    if(Error_Number != DEBUG_OUT_BUFF_OVF) {
        while(GetOutChrCnt()) {}                    // If data in the Debug uart out buffer, don't disable
    }                                               // interrupts till it's flushed out.
    IntMasterDisable();                             // Disable Interrupts.
*/
    for(;;) {

        if(pStr[Idx] != 0) {
            if( ! (UART4_FR_R & UART_FR_TXFF)) {// If space in the UART FIFO,
                UART4_DR_R = pStr[Idx++];
            }                                       //
        }                                           //

        for(i=195000; i != 0; i--) {}               // Fast Blink Delay, this value for 60MHz *
	HB_LED_Toggle();
	PwrOffDly--;

	if(++Cntr >= 40) {			    // Delay between error number readout.
	    if(Cntr == 40) Err_Dly = 0;		    // Reset Delay.
	    if(Err_Dly++ % 10 == 0) {
		if( ! (Err_Nmbr & 0x01)) {	    // Even.
		    ERR_LED_On();
		} else {			    // Odd.
		    ERR_LED_Off();
		}
		if(--Err_Nmbr == 0) {
		    Err_Nmbr = Error_Number << 1;   // Multiply by 2.
		    Cntr = 0;
		}
	    }
	}
    }
}
//---------------------------------------------------------------------------------------------------------------



#if ( defined(CONSOLE_TRACE) or defined(CONSOLE_TO_TTY) ) and defined(DEBUG)

#include <stdio.h>
#include "uarts.h"

PUBLIC struct sPrt Prt;			// Circular Buffer Array.

//-------------------------
//  PRINT TRACING BUFFER  |
//----------------------------------------------------------------------------------------------------------------
//  Since interrupts get delayed when printing out to the IDE Console via the JTAG interface, which messes up the
//  inter-processor communication, and possibly other interrupt driven functions, we buffer tracing messages until
//  we know it's OK to do so.  At the time this was implemented, we subscribed to the pushbutton events sm_test.cc
//  to call this.
//
//  Output can either go to the JTAG console or the Monitor TTY port depending on the definition of CONSOLE_TO_TTY

void PrtTracingBuff(void) {

    static int I = 1;

#if defined(DEBUG)

    IntMasterDisable();					// Master Disable interrupts.
    SysTickIntDisable();


    if(Prt.Count) {
	if(Prt.Count < PrtBuffSize) {
	    for(int i=0; i<Prt.Count; i++) {

#ifdef CONSOLE_TO_TTY
		sprintf(DbMsgBuff, "%s\n\r", Prt.Buff[i]);
		TxDebugStr(DbMsgBuff);
#else
		printf("%s", Prt.Buff[i]);
#endif

	    }
	} else {
	    for(int i=0; i<PrtBuffSize; i++) {

#ifdef CONSOLE_TO_TTY
		sprintf(DbMsgBuff, "%s\n\r", Prt.Buff[Prt.Idx++]);
		TxDebugStr(DbMsgBuff);
#else
		printf("%s", Prt.Buff[Prt.Idx++]);
#endif

		if(Prt.Idx >= PrtBuffSize) Prt.Idx = 0;	// Wrap the index.
	    }
	}
    } else {

#ifdef CONSOLE_TO_TTY
	sprintf(DbMsgBuff, "* %d\n", I++);
	TxDebugStr(DbMsgBuff);
#else
	printf("* %d\n\r", I++);			// # of times called with no data.
#endif

    }

    IntMasterEnable();					// Master enable interrupts.
    SysTickIntEnable();

#endif
}
//---------------------------------------------------------------------------------------------------------------

#endif // CONSOLE_TRACE

