//----------------------------------------------------------------------------------------------------------
//  error.h
//
//  Handle errors.
//
//  Copyright (c) 2025 Doug Broadwell, all rights reserved.
//----------------------------------------------------------------------------------------------------------

#ifndef ERROR_H_
#define ERROR_H_


#include "common.h"


//-----------------------
//  Error Enumerations  |
//----------------------------------------------------------------------------------------------------------
enum eError_Nmbs {
    BT_DATA_MSG_NOT_CONNECTED   =  1,	// BT_Comm_Dispatch() while Bluetooth not connected.
    INVAL_SWITCH_VALUE          =  2,	// Invalid value in a switch() statement.
    ISR_MESSAGE_OVERFLOW        =  3,	// In ISR_Send_Message()
    SEND_MSG_SEND_EVENT         =  4,	// Send_Event() Send Message Error.
    INVALID_STATE_MACHINE       =  5,	//
    INVALID_EVENT               =  6,	//
    UNHANDLED_EVENT_ERR         =  7,	// Unhandled Event in Unhandled Event function.
    INVALID_STATE_NUMBER        =  8,	//
    NO_MORE_TIMERS              =  9,	// In Set_Timer_Sub()
    TIMER_QUEUE_OVERFLOW        = 10,	// In Set_Timer()
    INIT_EEPROM_FAILURE         = 11,	//
    SUBSCRTIBE_ARRAY_OVF        = 12,	// Event Subscribe Array Full.
    DEBUG_OUT_BUFF_OVF          = 13,	//
    DEBUG_IN_BUFF_OVF           = 14,	//
    NULL_CALLBACK_ADDR          = 15,	// In RxCharacter() in uarts.cc
    EEPROM_WRITE_FAILURE        = 16,	// Error writing to EEProm.
    SEND_MESSAGE_OVERFLOW       = 17,   // Send_Message() queue overflow.
    BT_IN_CIRC_BUFF_OVF         = 18,   // Bluetooth Circular Input Buffer Overflow.
    BT_OUT_CIRC_BUFF_OVF        = 19,   // Bluetooth Circular Output Buffer Overflow.
    BT_IN_LIN_BUFF_OVF          = 20,   // AT Command Response Buffer Overflow.
    INVAL_LAST_TBL_ENTRY        = 21,   // Invalid last entry in ListEEPromData() table.
    BT_INVALID_MSG_NMB          = 22,   //
    BT_INVALID_MSG_SIZE         = 23,   //
                                        //
    LAST_Error_Nmbs	        = 24,   // ** Must be last entry **
};
//----------------------------------------------------------------------------------------------------------


void Init_Error(void);
void Error(eError_Nmbs Error_Number);
void Error(eError_Nmbs Error_Number, const char* Message);

// *IMPORTANT*  KEEP IN SYNC WITH Error_Str[] IN error.cc


//#if defined(DEBUG) //-------------------------

#if ( defined(CONSOLE_TRACE) or defined(CONSOLE_TO_TTY) ) and defined(DEBUG)

#include <string.h>

    // Circular buffer of tracing messages.

    const int PrtBuffSize   = 130;
    const int LineBuffSize = 140;

    struct sPrt {
	int  Idx;
	int  Count;
	char Buff[PrtBuffSize][LineBuffSize];	// array of PrtBuffSize, LineBuffSize-character line buffers.
    };

    extern  sPrt  Prt;

    extern  void  PrtTracingBuff(void);

    inline  void  ClrTracingBuff(void) { Prt.Idx = 0; Prt.Count = 0; }

    inline  void  PrtStartStr(char* pStr)       { strcpy(Prt.Buff[Prt.Idx], pStr); }	// Use these when concatenating strings.
    inline  void  PrtStartStr(const char* pStr) { strcpy(Prt.Buff[Prt.Idx], pStr); }
    inline  void  PrtAddStr  (char* pStr)       { strcat(Prt.Buff[Prt.Idx], pStr); }
    inline  void  PrtAddStr  (const char* pStr) { strcat(Prt.Buff[Prt.Idx], pStr); }
    inline  void  PrtDone    (void)             { strcat(Prt.Buff[Prt.Idx], "\n");
						  if(++Prt.Idx >= PrtBuffSize) {
						      Prt.Idx = 0;
						      strcat(Prt.Buff[Prt.Idx++], "=== Buffer Wrap ===\n");
						  }
						  if(++Prt.Count > PrtBuffSize) Prt.Count = PrtBuffSize;
// Uncomment the following line to send output to the console immediately.
						  PrtTracingBuff(); ClrTracingBuff();
						}


#endif //--------------------------------


#endif /* ERROR_H_ */
