//--------------------------------------------------------------------------------------------------
//  events.h
//
//  Events and Event Queues header file.
//
//  *NOTE*  The e_Event enumerations defined here must be kept in sync with Event_Names[]
//	    in events.cc
//--------------------------------------------------------------------------------------------------
//  Copyright (c) 2025 Doug Broadwell, all rights reserved.
//--------------------------------------------------------------------------------------------------
 
#ifndef EVENTS_H_
    #define  EVENTS_H_

    #include "common.h"

    enum e_Event {

	E_INITIALIZE,		//  0   All SM's get this to initialize themselves.

	//- Test Events -//

	E_TEST,			//  1

	//- Timer Events -//

	E_TIMEOUT,		//  2

	//- Brightness Switch Events -//

	E_BRITE_SW_1_ON,	//  3
	E_BRITE_SW_1_OFF,       //
	E_BRITE_SW_2_ON,        //
	E_BRITE_SW_2_OFF,       //

	//- CAN Events -//

	E_CAN_MSG,              //  7
	                        // -- Warnings/Errors --
	E_CAN_BOFF_ERR,         // Has gone into a Bus Off state.
	E_CAN_EWARN_ERR,        // Warning, an error counter is > 96
	E_CAN_EPASS_ERR,        // Rx or Tx error count > 127, is in Error Passive state.
	                        //
	                        // -- Comm Reestablished after Error --
	E_CAN_RX_REESTABLISHED, // *FIXME* Not checked yet.
        E_CAN_TX_REESTABLISHED, // *FIXME* Not checked yet.
                                //
                                // -- Errors Not Changing State --
                                // -- Should Not Happen in Silent Mode --
        E_CAN_STUFF_ERR,        // > 5 equal bits where not allowed.
        E_CAN_FORMAT_ERR,       //
        E_CAN_ACK_ERR,          // No ACK Received.
        E_CAN_BIT1_ERR,         // Tried to Xmit 1 but bus is 0.
        E_CAN_BIT0_ERR,         // Tried to Xmit 0 but bus is 1.
                                // -- Other Warning/Error --
        E_CAN_CRC_ERR,          // CRC Error in Received Message.

        //- Bluetooth Events -//

        E_BT_CONNECTED,         // Now Connected.
        E_BT_DISCONNECTED,      // Now Disconnected.
                                //
        E_BT_SEND_AT_CMNDS,     // Send AT command to BT module.
        E_BT_AT_CMND_ECHO,      // Send single AT command and echo response to Debug.
        E_BT_CMND_RESPONSE,     // Response to AT command received.
        E_BT_CMND_SUCCESS,      // AT Command(s) succeeded.
        E_BT_CMND_FAILURE,      // AT Command(s) failed.
        E_BT_CMND_TIMEOUT,      // AT Command no Response.

	//- ** MAGIC LAST ENTRY = MUST ALWAYS BE LAST !! ** -//

	LAST_E_Event_ENTRY
    };


    enum eSubscribeFlag { SUBSCRIBE, UNSUBSCRIBE, PUSH_SUBSCRIBE, POP_UNSUBSCRIBE };
    enum eSyncFlag      { SYNCHRONOUS, ASYNCHRONOUS };

    const char* Get_Event_Name( event_t Event );
          void  SM_Event_Dispatch( u16 Msg_Cnt, void* pMsg, ulong Ticks );
          void  Send_Event( sm_t SM, event_t Event, event_data_t Data );
          void  RxMsg_Event(int Msg_Nmb, int Length, u8* pBuff);
          void  ISR_Send_Event( sm_t SM, event_t Event, event_data_t Data );
//        void  Subscribe_Events( eSubscribeFlag Sub_Flag, eSyncFlag Sync_Flag,
//	                                 sm_t SM, event_t* pEvents, int Size );
//        void  Subs_Dispatch( u16 Msg_Cnt, void* vMsg, ulong Ticks );

          void PowerOff(void);
          void DisplayPowerOn(uint Timeout);
          void DisplayPowerOff(uint Timeout);
//        void CancelKeepAlive(void);



void PrintActiveSubscriptions(void);        // *FIXME* Testing.


#endif /* EVENTS_H_ */
