//---------------------------------------------------------------------------------------------------------------
//  init.cc
//
//  Initialize all software modules ("cold boot").
//
//  Copyright (c) 2025 Doug Broadwell, all rights reserved.
//---------------------------------------------------------------------------------------------------------------


#include "common.h"
#include "uarts.h"
#include "tick.h"
#include "error.h"
#include "state.h"
//#include "switch.h"
#include "monitor.h"
#include "led.h"
#include "can_local.h"
#include "eeprom.h"



//--------------------------------
//  RESET (COLD) INITIALIZATION  |
//---------------------------------------------------------------------------------------------------------------
//  Only called by main().  Note that Init_State_Machines() runs each SM with event INITIALIZE before
//  the dispatcher has started running.

void Init_All(void) {

#if ( defined(CONSOLE_TRACE) or defined(CONSOLE_TO_TTY) ) and defined(DEBUG)
    ClrTracingBuff();		 // Initialize tracing buffer in error.c
#endif

    Init_Error();               //
    Init_EEProm();	        //
    Init_Uarts();	        //
    Init_SysTick();	        //
    Init_Monitor();	        //
    Init_State_Machines();      //
    Init_LEDs();                //
    Init_CAN();                 //
//  Init_Switch();              //
}
//---------------------------------------------------------------------------------------------------------------


