//---------------------------------------------------------------------------------------------------------------
//  led.h
//
//  Control the LEDs.
//
//  Copyright (c) 2025 Doug Broadwell, all rights reserved.
//---------------------------------------------------------------------------------------------------------------

#ifndef LED_H_
#define LED_H_


void Tmp(void); // ** FIXME **


enum ePWM { RED, GREEN, BLUE, WHITE, NEEDLES, SPEEDO };

struct sColors {
    float fRed;
    float fGreen;
    float fBlue;
    float fWhite;
};

extern const sColors Red;
extern const sColors Yellow;
extern const sColors Orange;
extern const sColors Blue;
extern const sColors Purple;
extern const sColors White;
extern const sColors CoolWht;
extern const sColors BriteWht;

// Keep the two following in sync.
extern const sColors Colors[]; /* { Black, Red, Yellow, Orange, Blue, Purple, White, CoolWht, BriteWht }; */
enum         eColors { BlackIdx,  RedIdx,   YellowIdx,  OrangeIdx,   BlueIdx,
                       PurpleIdx, WhiteIdx, CoolWhtIdx, BriteWhtIdx, NullIdx };

struct sBacklightThresholds {
    uint     RPM;
    sColors  Color;
    uint     Blink;
    uint     Brightness;
    bool     InterpolateColor;
    bool     InterpolateBlink;
    bool     InterpolateBrightness;
};

struct sNeedleThresholds {
    int    RPM;
    uint   Speed;
    uint   Blink;
    uint   Brightness;
};

struct sSpeedoBLThresholds {
    uint   Speed;
    uint   Blink;
    uint   Brightness;

};

extern const uint BLThreshSize;
extern const uint NeedleThreshSize;
extern const uint SpeedoBLThreshSize;


void TachBacklightColor(float fRed, float fGreen, float fBlue, float fWhite);
void TachBacklightColor(eColors ColorIdx);
void TachBacklightBrightness(uint Brite);
void NeedleBrightness(uint Brite);
void SpeedoBacklightBrightness(uint Brite);
void ManualPWM(ePWM Which, uint PwmPct);
void Init_LEDs(void);

#endif /* LED_H_ */
