//---------------------------------------------------------------------------------------------------------------
//  981 Backlight v1.0: main.cc
//
//  MAIN MAN !  Where all the Magic Starts.
//
//  Copyright (c) 2025 Doug Broadwell, all rights reserved.
//---------------------------------------------------------------------------------------------------------------
//
//  TM4C123AE6PM
//---------------------------------------------------------------------------------------------------------------
//
//  SOFTWARE REVISION HISTORY
//
//  1.0	  7/2/25	D.B.
//	  1) Start of project, code modified from K9G-Plus project.
//
//---------------------------------------------------------------------------------------------------------------
//
//	Dip Switch Functions
//
//	Switch	Off				On
//
//	   1
//	   2
//
//---------------------------------------------------------------------------------------------------------------
//
//  TO DO
//
//       1) Constant arrays like sMultiRead should be made constant - need to figure out how to do this.
//       2) Have separate user configs for each smartphone it is paired with (i.e., for each user).
//
//
//  FOR K9G+ SOFTWARE, May be applicable or not.
//
//       3) Set up MPU Sleep configuration.
//  ???  5) Move sBuff out of uarts to somewhere more applicable, Main?
//      10) Move the state enumerations for each state machine from the header file to the source file.
//      13) The Mod-C had a nicer way of specifying eeProm addresses, use it.
//      16) Instead of, e.g., SM_MAIN having to Unsubscribe to events when passing control SM_USER_MENU,
//            to have SM_USER_MENU to a Push-Subscription to the events it needs to take control of.
//      20) Change each State in the State Machines to be an object so that it can have local variables shared
//            between it's Entry and Event functions (instead of them being module global).
//      23) Change all declarations of, e.g. uword, long, etc. to more appropriate, uword should probably be u32.
//      29) Take anything that's not meant to be global out of the .h file and into the .cc file.
//
//
//  FOLLOWING FROM K9G SOFTWARE, May be applicable or not.
//
//	     4) Add PRIVATE everywhere it should be.
//	    16) Be sure all Constant arrays are const.
//
//  See also the To Do's in other source files.
//  See also the *FIXME*s
//  See also 'G+'.
//  See also 'DB+'
//
//---------------------------------------------------------------------------------------------------------------




//-------------------------------------------------------------------------------
//  NOTES TO WHOMEVER POOR SOUL(S) HAVE TO TAKE UP THE BATTLE TO MAINTAIN THIS  |
//---------------------------------------------------------------------------------------------------------------
//
//  First off, I must apologize for the inconsistencies in naming: SomeTimesLikeThis(), Somtimes_This(),
//  sometimes all upper-case, ... well, you get the idea.
//
//  This code was copied over from another project so there may be some documentation leftover from it.
//
//---------------------------------------------------------------------------------------------------------------



#include "common.h"
#include "main.h"
#include "init.h"
#include "init_cpu.h"
#include "dispatch.h"
#include "interrupt.h"



// Hardware version via GetHwVersion();

const char SoftwareVer[] = "1.0";
const char SoftDate[]    = "11/5/25";
const char Copyright[]   = "Copyright (c) 2025, 2026, Doug Broadwell, all rights reserved.";



//---------
//  MAIN  |
//---------------------------------------------------------------------------------------------------------------
int main(void) {		//
				//
    Init_CPU();			// Configure the CPU and Peripherals.
    Init_All();                 // Initialize the Software and Peripherals.
    IntMasterEnable();          // Master Enable Interrupts.
    Dispatch();			// Never Returns (ala Charlie on the MTA - Kingston Trio).
}                               //
//---------------------------------------------------------------------------------------------------------------





                                        ////////////////////////
                                        //                    //
                                        //  GLOBAL FUNCTIONS  //
                                        //                    //
                                        ////////////////////////


/*
//---------------------
//  HARDWARE VERSION  |
//---------------------------------------------------------------------------------------------------------------
const char* HW_VERSION[] = {

    "v1.0",
    "v2.0",
};
//---------------------------------------------------------------------------------------------------------------
const char* GetHwVersionStr(void) {

    return( HW_VERSION[(int)GetHwVersion()] );
}
//---------------------------------------------------------------------------------------------------------------
*/


