//---------------------------------------------------------------------------------------------------------------
//  sm_bluetooth.h
//
//  Bluetooth State Machine header file.
//
//  Copyright (c) 2025 Doug Broadwell, all rights reserved.
//---------------------------------------------------------------------------------------------------------------

#ifndef SM_BLUETOOTH_H_
#define SM_BLUETOOTH_H_

#include "common.h"
#include "state.h"


enum   eBtState { BtIdle, BtAdvertising, BtConnected, BtDisconnected };   // Global Bluetooth State
extern eBtState BtCurrentState;

void BT_Dispatch(u16 Count, void* pMsg, ulong Ticks);

enum eBtCommMode { BtAtMode, BtDataMode };
extern eBtCommMode BtCommMode;                      // Global state of communication mode.

void SetAtCmnd(u8 Idx, char* pCmnd, char* pResp);
/*
inline void SetAtCmnd(u8 Idx, const char* pCmnd, const char* pResp) {
    SetAtCmnd(Idx, const_cast<char*>(pCmnd), const_cast<char*>(pResp));
} */



namespace nsBtState {


  extern state_nmb_t Unhandled_Event(state_nmb_t CurrentState, event_t Event, event_data_t Event_Data );

  extern const int StateTbl_Size;
  extern const StateTbl States[];


} /* namespace nsBtState */


#endif /* SM_BLUETOOTH_H_ */
