//---------------------------------------------------------------------------------------------------------------
//  sm_bt_at_cmnd.h     enum SM_BT_AT_CMND
//
//  Communicating via "Serial Port Connection" between here and iOS or Android.
//
//  Copyright (c) 2025 Doug Broadwell, all rights reserved.
//---------------------------------------------------------------------------------------------------------------

#ifndef SM_BT_AT_CMND_H_
#define SM_BT_AT_CMND_H_

#include "state.h"

struct sAtCmnd {
    char* pAtCommand;
    char* pExpectedResponse;
};

const  uint MaxAtCommands = 11;                 // Maximum of 10 character AT commands plus null command end.
extern sAtCmnd AtCommands[MaxAtCommands];       // Instantiate AT commands buffer.

void BtAtCmndEcho(char* pCmnd);
inline void BtAtCmndEcho(const char* pChar) { BtAtCmndEcho(const_cast<char*>(pChar)); }


namespace nsBtAtState {

  extern state_nmb_t Unhandled_Event(state_nmb_t CurrentState, event_t Event, event_data_t Event_Data );
  extern const int StateTbl_Size;
  extern const StateTbl States[];

} /* namespace nsBtAtState */


#endif /* SM_BT_AT_CMND_H_ */
