//---------------------------------------------------------------------------------------------------------------
//  sm_main.cc
//
//  Copyright (c) 2025 Doug Broadwell, all rights reserved.
//---------------------------------------------------------------------------------------------------------------


#include "common.h"
#include "uarts.h"
#include "main.h"
#include "error.h"
#include "state.h"
#include "timers.h"
#include "events.h"
#include "sm_main.h"
#include "eeprom.h"
#include "tick.h"
#include "monitor.h"
#include "init_cpu.h"
#include "eeprom.h"
#include "switch.h"

#include "interrupt.h"      // Tivaware files.
#include "sysctl.h"

#include <cmath>            // C Library files.
#include <stdio.h>




					////////////////////////////
					//                        //
					//  "MAIN" STATE MACHINE  //
					//                        //
					////////////////////////////

namespace nsMain {


//----------
//  STUFF  |
//--------------------------------------------------------------------------------------------------------------
enum eMainStates { S0_Startup, };

PRIVATE    handle_t SmMainTimerHandle;
PRIVATE state_nmb_t PriorStateSave;

PRIVATE event_t MyEvents[] = {                                                  // ** FIXME ** Not Used.
                            // -- Instrument Cluster Brightness Switches --
    E_BRITE_SW_1_ON,        //
    E_BRITE_SW_1_OFF,       //
    E_BRITE_SW_2_ON,        //
    E_BRITE_SW_2_OFF,       //
                            // -- CAN Message Received --
    E_CAN_MSG,              //
                            // -- Warnings/Errors --
    E_CAN_BOFF_ERR,         // Has gone into a Bus Off state.
    E_CAN_EWARN_ERR,        // Warning, an error counter is > 96
    E_CAN_EPASS_ERR,        // Rx or Tx error count > 127, is in Error Passive state.
                            // -- Comm Reestablished after Error --
    E_CAN_RX_REESTABLISHED, //
    E_CAN_TX_REESTABLISHED, //
                            // -- Errors Not Changing State --
                            // -- Should Not Happen in Silent Mode --
    E_CAN_STUFF_ERR,        // > 5 equal bits where not allowed.
    E_CAN_FORMAT_ERR,       //
    E_CAN_ACK_ERR,          // No ACK Received.
    E_CAN_BIT1_ERR,         // Tried to Xmit 1 but bus is 0.
    E_CAN_BIT0_ERR,         // Tried to Xmit 0 but bus is 1.
                            // -- Other Warning/Error --
    E_CAN_CRC_ERR,          // CRC Error in Received Message.

};

const int MyEventSize = sizeof(MyEvents) / sizeof(MyEvents[0]);
//--------------------------------------------------------------------------------------------------------------




//-----------------------------
//  UNHANDLED EVENT FUNCTION  |
//--------------------------------------------------------------------------------------------------------------
//  Implements a crude 2 level "hierarchical state machine"

state_nmb_t Unhandled_Event(state_nmb_t CurrentState, event_t Event, event_data_t EventData ) {

/*  switch(Event) {

	    return(NO_STATE_CHANGE);
    }
*/
    return(UNHANDLED_EVENT);		        // This will throw an Error.
}
//---------------------------------------------------------------------------------------------------------------




//----------------------------------------------
//  STATE 0, STARTUP AND SWITCHES  S0_Startup  |
//---------------------------------------------------------------------------------------------------------------
state_nmb_t S0_Startup_Entry(state_nmb_t PriorState) {	                //
                                                                        //
    return(NO_STATE_CHANGE);						//
}									//
//---------------------------------------------------------------------------------------------------------------
state_nmb_t S0_Startup_Event(event_t Event, event_data_t Data) {        //
                                                                        //
    switch(Event) {							//
									//
        case E_INITIALIZE:                                              //
                                                                        //
            return(NO_STATE_CHANGE);                                    //
                                                                        //
        case E_CAN_MSG:                                                 //
                                                                        //
            TxDebugStr("\r\n CAN Message Received\r\n");                //
            return(NO_STATE_CHANGE);                                    //
                                                                        //
        case E_CAN_BOFF_ERR:                                            // Has gone into a Bus Off state.
        case E_CAN_EWARN_ERR:                                           // Warning, an error counter is > 96
        case E_CAN_EPASS_ERR:                                           // Rx/Tx err cnt>127, Err Passive state.
        case E_CAN_RX_REESTABLISHED:                                    //
        case E_CAN_TX_REESTABLISHED:                                    //
        case E_CAN_STUFF_ERR:                                           // > 5 equal bits where not allowed.
        case E_CAN_FORMAT_ERR:                                          // Format Error.
        case E_CAN_ACK_ERR:                                             // No ACK Received.
        case E_CAN_BIT1_ERR:                                            // Tried to Xmit 1 but bus is 0.
        case E_CAN_BIT0_ERR:                                            // Tried to Xmit 0 but bus is 1.
        case E_CAN_CRC_ERR:                                             // CRC Error in Received Message.
                                                                        //
            TxDebugStr("\r\n CAN Error Received\r\n");                  //
            return(NO_STATE_CHANGE);                                    //
                                                                        //
    }                                                                   //
    return(UNHANDLED_EVENT);                                            //
}									//
//---------------------------------------------------------------------------------------------------------------




//----------------
//  STATE TABLE  |
//---------------------------------------------------------------------------------------------------------------

const StateTbl States[] = {

//    State Name            Addr of Entry Function     Addr of Event Function
//    -------------------   -----------------------   ------------------------
    { "S0_Startup       ",  S0_Startup_Entry,         S0_Startup_Event       },
};

const int StateTbl_Size = sizeof(States) / sizeof(struct StateTbl);
//---------------------------------------------------------------------------------------------------------------


} /* namespace nsMain */

