//--------------------------------------------------------------------------------------------------------------
//  state.h
//
//  State Machine header file.
//
//  Copyright (c) 2011-2023 CSECO, Alameda, CA., all rights reserved.
//--------------------------------------------------------------------------------------------------------------

#ifndef STATE_H_
#define STATE_H_

#include "common.h"


//void GetLastState(sm_t &LastState, event_t &LastEvent, event_data_t &LastData); // *FIXME*  G+
sm_t         GetLastState(void);
event_t      GetLastEvent(void);
event_data_t GetLastData(void);



const int SPEC_STATES =  100;	// Special States.

enum eSpecialStates {

    NO_STATE_CHANGE = SPEC_STATES + 0,
    UNHANDLED_EVENT = SPEC_STATES + 1,
    NULL_STATE      = SPEC_STATES + 2,  // Used in Beep() and NotifyBeep().
    SM_NULL         = SPEC_STATES + 3,  // Send event to state(s) that have subscribed to it, e.g. button events

    // Magic Enum, MUST BE LAST ENTRY //

    End_Special_States = SPEC_STATES + 4,
};


// The order of these enumerations is the order the SM's will get Reset Events.

enum eStateMachines {	// *NOTE* Must be kept in sync with StateMachines[] in state.cc
    SM_BLUETOOTH,	// Bluetooth.
    SM_BT_AT_CMND,    // Bluetooth AT Command.
    SM_MAIN,		// Things kick off here.
};
const uint LAST_SM = SM_MAIN;

extern const int StateMachines_Size;

struct StateTbl {
    const char*        StateName;
    state_nmb_t (*pEntryFunct)(state_nmb_t);
    state_nmb_t (*pEventFunct)(event_t, event_data_t);
};


extern void Init_State_Machines(void);
extern void Handle_Event(sm_t SM, event_t Event, event_data_t EventData);
extern const char* Get_SM_Name(sm_t);

const int SM_LOG_SIZE = 100;

struct sSM_Log {
    sm_t         SM;
    event_t      Event;
    event_data_t Data;
    sm_t         Next_State;
};


#endif /* STATE_H_ */
