//------------------------------------------------------------------------------------------------------
//  switch.cc
//
//  Brightness Switch functions.
//
//  Copyright (c) 2025 Doug Broadwell, all rights reserved.
//------------------------------------------------------------------------------------------------------


#include "init.h"
#include "state.h"
#include "events.h"

#include "gpio.h"
#include "hw_memmap.h"



PRIVATE bool Brite_1_State;     // true = switch ON (low).
PRIVATE bool Brite_2_State;



//---------------------------
//  BRITE SWITCH INTERRUPT  |
//------------------------------------------------------------------------------------------------------
void Switch_Interrupt(void) {

    u8 State = ! GPIO_PORTG_DATA_R;                             // Make switch low = high.

    if( (State & PA_BriteSw1_BIT) && ( ! Brite_1_State) ) {
        ISR_Send_Event( SM_MAIN, E_BRITE_SW_1_ON, 0 );          // Switch 1 now ON.
        Brite_1_State = true;
    } else if( ! (State & PA_BriteSw1_BIT) && (Brite_1_State)) {
        ISR_Send_Event( SM_MAIN, E_BRITE_SW_1_OFF, 0 );         // Switch 1 now OFF.
        Brite_1_State = false;
    }

    if( (State & PA_BriteSw2_BIT) && ( ! Brite_2_State) ) {
        ISR_Send_Event( SM_MAIN, E_BRITE_SW_2_ON, 0 );          // Switch 2 now ON.
        Brite_2_State = true;
    } else if( ! (State & PA_BriteSw2_BIT) && (Brite_2_State)) {
        ISR_Send_Event( SM_MAIN, E_BRITE_SW_2_OFF, 0 );         // Switch 2 now OFF.
        Brite_2_State = false;
    }
}
//------------------------------------------------------------------------------------------------------




//-----------------------------
//  GET CURRENT SWITCH STATE  |
//------------------------------------------------------------------------------------------------------
bool Get_Brite_1_State(void) { return(Brite_1_State); }
bool Get_Brite_2_State(void) { return(Brite_2_State); }
//------------------------------------------------------------------------------------------------------




//-----------------------
//  INITIALIZE CAN BUS  |
//------------------------------------------------------------------------------------------------------
void Init_Switch(void) {

    GPIOIntRegisterPin(GPIO_PORTA_BASE, PA_BriteSw1_BIT, Switch_Interrupt);
    GPIOIntRegisterPin(GPIO_PORTA_BASE, PA_BriteSw2_BIT, Switch_Interrupt);
    u8 State = ! GPIO_PORTG_DATA_R;                             // Make switch low = high.
    State & PA_BriteSw1_BIT ? Brite_1_State = true : Brite_1_State = false;
    State & PA_BriteSw2_BIT ? Brite_2_State = true : Brite_2_State = false;
}
//------------------------------------------------------------------------------------------------------





