//----------------------------------------------------------------------------------------------------------
//  tick.h
//
//  System Tick.
//
//  Copyright (c) 2025 Doug Broadwell, all rights reserved.
//----------------------------------------------------------------------------------------------------------

#ifndef TICK_H_
#define TICK_H_



const int TICK_TIME_MS  = 10;			// Number of milliseconds per tick.
const int TICKS_PER_SEC = 100;			// Tick = 10mS.
const int TICKS_PER_MIN = 6000;
const int uS_PER_TICK   = ((1000000 / TICKS_PER_SEC)+1);
const int US_PER_TICK   = uS_PER_TICK;
const int nS_PER_TICK   = (1000000000 / TICKS_PER_SEC);

#define   MS_TO_TICKS(s)  (((s) * 1000000 + (nS_PER_TICK/2)) / nS_PER_TICK)
#define   SEC_TO_TICKS(s)  (s * TICKS_PER_SEC)

const int ms1000 =  TICKS_PER_SEC;
const int ms500  = (TICKS_PER_SEC /   2);
const int ms333  = (TICKS_PER_SEC /   3);
const int ms250  = (TICKS_PER_SEC /   4);
const int ms280  = 28;
const int ms200  = (TICKS_PER_SEC /   5);
const int ms120  = 12;
const int ms100  = (TICKS_PER_SEC /  10);
const int ms80   = 8;
const int ms70   = 7;
const int ms60   = 6;
const int ms50   = (TICKS_PER_SEC /  20);
const int ms20   = (TICKS_PER_SEC /  50);
const int ms10   = (TICKS_PER_SEC / 100);

const int JmpMsTime       = ms70;               //*NOTE* Keep these two
const int TickCntBuffSize = 7;                  // values in sync.


void  SysTickISR(void);
void  DelayMs(int DelayTicks);
 u32  Timer_Foreground(void);
 s32  Get_Wakeup_Time(void);
void  Set_Wakeup_Time(s32);
void  Init_SysTick(void);
u32   Get_Run_Time(void);


#endif /* TICK_H_ */
